//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/20                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class for Visualizing directions from each element (normal, curvature direction etc)
 */

#ifndef _OM_DIRECTIONS_GEO_H_
#define _OM_DIRECTIONS_GEO_H_

#include <osg/MatrixTransform>
#include <osg/Projection>

#include <OMToolkit\OMTypes.h>
#include <OpenMesh\Core\Utils\Property.hh>
#include <osg/Geometry>

namespace osg
{
	/**
	 * Class which visualises vectors associed with vertices or faces
	 * @tparam Mesh Class of OpenMesh mesh to work with
	 * @tparam Vector Vector type of visualised vector
	 */
	template <class Mesh, class Vector>
	class OMDirectionsGeometry : public Geometry
	{
		protected:
			/**
			 * Mesh vector type
			 */
			typedef typename Mesh::Normal VectorT;

			/**
			 * Mesh vector scalar type
			 */
			typedef typename VectorT::value_type ScalarT;

		public:
			/**
			 * Constructor
			 * Creates an instance of this class by drawing vectors specified by handle from each vertex
			 * @param mesh Mesh to work with
			 * @param handle Handle to vector vertex property
			 * @param norm Lenght of showed distances
			 * @param defaultColor Default color of visualised normal
			 * 
			 */
			OMDirectionsGeometry(Mesh &mesh, OpenMesh::VPropHandleT<Vector> handle, ScalarT norm = 1.0, Vec4f defaultColor = Vec4f(1.0, 1.0, 1.0, 1.0));
			/**
			 * Constructor
			 * Creates an instance of this class by drawing vectors specified by handle from each face
			 * @param mesh Mesh to work with
			 * @param handle Handle to vector vertex property
			 * @param norm Lenght of showed distances
			 * @param defaultColor Default color of visualised normal
			 */
			OMDirectionsGeometry(Mesh &mesh, OpenMesh::FPropHandleT<Vector> handle, ScalarT norm = 1.0, Vec4f defaultColor = Vec4f(1.0, 1.0, 1.0, 1.0));

	protected:
		}; // class OMDirectionGeo

#include <OMToolkitOSG/OMDirectionsGeo.hxx>
} // namespace osg

#endif