//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/20                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class for showing error log
 */

#ifndef _OM_ERROR_LOG_H_
#define _OM_ERROR_LOG_H_

#include <string>
#include <iostream>

namespace OMToolkit
{
	/**
	 * Class contains a static method for logging
	 */
	class ErrorLog
	{
		public:
			/**
			 * Method shows one log line
			 * Modify this if you want to show log elsewhere
			 * @param message Message to be showed.
			 */
			static void ShowLog(std::string message)
			{
//#ifdef _DEBUG
				std::cerr << message << std::endl;
//#endif
			}
	}; // class
}

#endif