function G = random_forest_update(F, X, Y, W, predictor, pPredictor)
% Recalc predictor in nodes using new samples

G = F;

[~,I] = random_forest_predict(G, X);

% Normalize weights
for c = G.classes, W(Y==c) = W(Y==c)/(length(G.classes)*sum(Y==c)); end;

for t = 1:numel(I)
    for n = 1:numel(I{t})
        G.tree{t}(n).p = feval(predictor, Y, W, I{t}{n}, G.classes, pPredictor{:});
    end
end