function [F,splits,err] = random_planes(n, X, ~, ~, ind, ~, tp)

if nargin < 7, tp = 'unconstrained'; end;

tp = lower(tp);

dim = size(X,1)-1;

b = zeros(n,1);

switch (tp)
    case 'unconstrained'
        g = normr(randn(n,dim));
        F = [g b];
    case 'aligned'
        g = bsxfun(@eq, randi(dim,n,1), 1:dim);
        F = [g b];
    otherwise
        error('Unknown type of plane');
end % switch

[~,M] = lin_features_eval(X, ind, F);

%{
thr = splitopt(single(M), uint8(Y(ind)), single(W(ind)), uint8(unique(Y)));
%}

m0 = min(M); m1 = max(M);
thr = m0 .* rand(1,size(M,2)) .* (m1 - m0);
F(:,end) = -thr';

splits = bsxfun(@gt, M, thr);

err = [];

end
