function [splits,M] = lin_features_eval(X, IND, F, field)
% Evaluate linear projections F of vectors X
%
%   S = lin_features_eval(X, IND, F);
%
% F must be a matrix with linear projections stored in rows, and X matrix
% of instances stored in rows. The function calculates signum of response
% of every feature in F to samples in X specified by IND, and returns a
% matrix S where columns corresponds to features, and rows to samples.
% S(i,j) therefore is response of F(j,:) to X(i,:).
%
% F can be generated by random_planes function
%
% See also: random_planes, random_forest_train
%
% Author: Roman Juranek <ijuranek@fit.vutbr.cz>, FIT, BUT, Brno
% Part of Random Forest Toolbox

if isstruct(X)
    if nargin < 4, field = 'feature'; end;
    if ~isempty(IND), X1 = vertcat(X(IND).(field));
    else X1 = vertcat(X.(field)); end;
else
    if ~isempty(IND), X1 = X(IND,:);
    else X1 = X; end;
end

M = (F * X)';
splits = M > 0;

end
