function u = infogain(Y, ~, ind, classes, splits)

ig = @(p) -sum(p.*log(p+1e-4));

Y = Y(ind);
u = inf(1,size(splits,2));

n = size(splits,1); % number of samples
nl = sum(splits,1);
nr = n - nl;

for i = 1:size(splits,2)
    pl = histc(Y(splits(:,i)),classes) ./ nl(i);
    pr = histc(Y(~splits(:,i)),classes) ./ nr(i);
    rl = nl(i)/n; rr = nr(i)/n;
    u(i) = rl * ig(pl) + rr * ig(pr);
end