function [F,splits,err] = default(n,X,~,~,ind,~)

err = []; sz = size(X);
dim = prod(sz(1:end-1)); K = sz(end);

if nargin == 2, ind = 1:K; end;

fid = randi(dim,n,1); % Feature id
[u,v] = meshgrid(fid,int32(ind));

j = sub2ind([dim,K],single(u),single(v));
M = X(j);
[m0,m1] = deal(min(M,[],1), max(M,[],1));
t = (m0 + rand(1,n) .* (m1 - m0))';
F = [fid, t];
splits = bsxfun(@gt, M, t');