function T1 = compact_tree(T)
% Converts tree to structure array
%
%   T1 = COMPACT_TREE(T)
%
% Compact tree T from nested structure format to structure array. Every
% node is represented with structure with following fields:
%   tp          Node type
%   p           Probabilites
%   H           Histogram of samples
%   split       Split function parameters
%   children    Indices of cild nodes
%   user_data   Any user generated data (ignored in prediction)
%
% This function is used internally by RANDOM_FOREST_TRAIN as it stores tree
% as nested structures but struct array is more convenient in prediction.
%
% Author:   Roman Juranek <ijuranek@fit.vutbr.cz>

nodes{1} = T;

n_id = 0;
while n_id < numel(nodes)
    n_id = n_id + 1;
    if nodes{n_id}.tp ~= 0
        i = numel(nodes);
        nodes{i+1} = nodes{n_id}.l;
        nodes{i+2} = nodes{n_id}.r;
        nodes{n_id}.children = [i+1, i+2];
    end
end

T1 = struct;

for i = 1:numel(nodes)
    T1(i).tp = int32(nodes{i}.tp);
    T1(i).p = single(nodes{i}.p(:));
    T1(i).H = int32(nodes{i}.H(:));
    if isfield(nodes{i}, 'split')
        T1(i).split = nodes{i}.split;
    end
    if isfield(nodes{i}, 'children')
        T1(i).children = int32(nodes{i}.children(:));
    else
        T1(i).children = zeros(2,1,'int32');
    end
    if isfield(nodes{i}, 'udata')
        T1(i).udata = nodes{i}.udata;
    end
end

end