/******************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by Robo@FIT group.
 *
 * Author: Jaroslav Rozman
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 20.11.2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
  ... short description, important information, modules in belongs to, etc.
*/ 


#include <ros/ros.h>
#include <std_msgs/Float32.h>
#include <std_msgs/Int32.h>
#include <actionlib/server/simple_action_server.h>
#include <wait_action_server/WaitAction.h>
#include <data_bridge/DTB_ObjReport.h>

class WaitAction
{
protected:
    
  ros::NodeHandle nh_;
  actionlib::SimpleActionServer<wait_action_server::WaitAction> as_;
  std::string action_name_;
  int data_count_, goal_;
  float sum_, sum_sq_;
  wait_action_server::WaitFeedback feedback_;
  wait_action_server::WaitResult result_;
  ros::Subscriber sub_;
  ros::Subscriber sub2;
  ros::Subscriber sub;
  volatile int prom;
  volatile int preempted;
  volatile int preemptRequested;

public:
    /*
  WaitAction(std::string name) : 
    as_(nh_, name, false),
    action_name_(name)
  {
    //register the goal and feeback callbacks
    as_.registerGoalCallback(boost::bind(&WaitAction::goalCB, this));
 //   as_.registerPreemptCallback(boost::bind(&WaitAction::preemptCB, this));

    //subscribe to the data topic of interest
 //   sub_ = nh_.subscribe("/wait_time", 1, &WaitAction::analysisCB, this);
    sub2 = nh_.subscribe("/data_bridge_objdet", 1, &WaitAction::detectObstacles, this);
	prom = 0;
	preempted = 0;
    as_.start();
  }*/

 WaitAction(std::string name) :
    as_(nh_, name, boost::bind(&WaitAction::executeCB, this, _1), false),
    action_name_(name)
  {
    preemptRequested = 0;
    as_.start();
  //  cmd_vel_pub_ = nh_.advertise<geometry_msgs::Twist>("cmd_vel", 1);
    sub2 = nh_.subscribe("/data_bridge_objdet", 1, &WaitAction::detectObstacles, this);
  }

  ~WaitAction(void)
  {
  }

  void detectObstacles(const data_bridge::DTB_ObjReport::ConstPtr& msg)
  {
	volatile int priority = 0;	
	//testing zones are free 
	for (int i = 0; i < msg->objects.size(); i++)
	{
		if (msg->objects[i].m_zone > priority)
			priority = msg->objects[i].m_zone;
	} 

        if (priority == 0) 
	{
          ROS_INFO("%i: Read from Wait", msg->objects[0].m_class);
	  ROS_INFO("prom je %i", prom);
//	  if (/*(msg->objects[0].m_class == 0) && */(prom == 1))
		{
			preempted = 1;
			preemptRequested = 1;//area is free, robot can GO
//			as_.setPreempted();
//			ROS_INFO("%s: Preempted", action_name_.c_str());
//			ROS_INFO("Poslano cancel requested z callbacku Wait");
		}
         }
  }

/*
  void goalCB()
  {
	int success = 1;
	int counter = 0;
    // reset helper variables
//    data_count_ = 0;
//    sum_ = 0;
//    sum_sq_ = 0;
	ros::Rate rate(10);
	// accept the new goal
	goal_ = as_.acceptNewGoal()->goal;
	ROS_INFO("goal je %i", goal_);	
	while (10*goal_ > counter)
{
	prom = 1;	
	counter++;	
	if (preempted == 1 || !ros::ok())	
	{
		as_.setPreempted();
		ROS_INFO("%s: Preempted", action_name_.c_str());
		success = 0;
		break;
	}
	//else	
	//{
		//prom = 1;
		//ROS_INFO("promenna prom je %i", prom);
    		//goal_ = as_.acceptNewGoal()->goal;
		//ROS_INFO("goal je %i", goal_);	
		//ROS_INFO("Jsme zde");
	//	ros::Rate rate(1.0/msg->data);
		//ros::Rate rate(1.0/goal_);
		//ROS_INFO("Jsme zde1");
	 	//ros::spinOnce();
	rate.sleep();
		ros::spinOnce();
		//success = 1;
	//}
}
	if (success == 1)
	{
		ROS_INFO("%s: Akce Succeeded", action_name_.c_str());
		as_.setSucceeded();
	}		

	//ROS_INFO("Jsme zde2");
	prom = 0;
	preempted = 0;
	
  }
*/
/*
  void preemptCB()
  {
    ROS_INFO("%s: Preempted", action_name_.c_str());
    // set the action state to preempted
    as_.setPreempted();
  }
*/
 // int obstacleType = 0;
//  void detectObstaclesCB(const robot_msgs::obstacles::ConstPtr& msg)
//	{
//		if (msg->objectType == 0)
//		{
//			as_.setPreempted();
//			ROS_INFO("Poslano cancel requested z callbacku Wait");
//		}
//	}
/*
  void analysisCB(const std_msgs::Int32::ConstPtr& msg)
  {
	//sub = nh_.subscribe("/obstacles", 1, detectObstaclesCB);    

	// make sure that the action hasn't been canceled
	if (!as_.isActive())
		return;
	ROS_INFO("msg je %i", msg->data);

	ROS_INFO("Jsme zde");
//	ros::Rate rate(1.0/msg->data);
	ros::Rate rate(1.0/goal_);
	ROS_INFO("Jsme zde1");
 
	rate.sleep();

	if(msg->data == 512)
	{
		//ROS_INFO("%s: Aborted", action_name_.c_str());
	        ////set the action state to aborted
	        //as_.setAborted(result_);
		ROS_INFO("Poslano cancel requested");
		as_.setPreempted();
	}
	else 
	{
		//rate.sleep();
		ROS_INFO("%s: Succeeded", action_name_.c_str());
	        // set the action state to succeeded
        	as_.setSucceeded(result_);
	}
	 
  }
*/

void executeCB(const wait_action_server::WaitGoalConstPtr &goal)
{
	ROS_INFO("We are entering the waiting state");	
	bool success = true;
    	ros::Rate rate(10);

	int poc = 0;
    	
	while (poc < 200)
	{
		
		rate.sleep();
		ros::spinOnce();
		ROS_INFO("%i: poc je", poc);
		poc++;
		if (preemptRequested != 0 || !ros::ok())
		{
			as_.setSucceeded();	// area is free, we can go
			ROS_INFO("%s: Succeeded", action_name_.c_str());
			success = 0;
			break;
		}
	}

	
    
    if(success)
    {
	ROS_INFO("%s: Preempted", action_name_.c_str());
      
      as_.setPreempted();	//the area is still occupied, we have to stay
    }

   /* 
    if(!success)
    {

      ROS_INFO("%s: Preempted", action_name_.c_str());
      // set the action state to succeeded
      as_.setPreempted();
    }*/

  

}

};

int main(int argc, char** argv)
{
  ros::init(argc, argv, "wait");

  WaitAction wait(ros::this_node::getName());
  ros::spin();

  return 0;
}
