/**
 * Developed by dcgm-robotics@FIT group
 * Author: Khelifa baizid & Viorela Ila (baizid@fit.vutbr.cz OR baizid.khelifa@gmail.com)
 *         Viorela Ila (ila@fit.vutbr.cz OR iviorela@gmail.com)
 * Date: 10.04.2012 (version 1.0)
 *
 * License: BUT OPEN SOURCE LICENSE
 *
 * Description:
 * Sample tracking stack with allow the robot to reach detected objected. 
 * The stack is still under development
 *------------------------------------------------------------------------------
 */

#include <ros/ros.h>
#include <move_base_msgs/MoveBaseAction.h>
#include <actionlib/client/simple_action_client.h>
#include <geometry_msgs/PoseStamped.h>
#include <vector>
#include <string>
#include <boost/thread/mutex.hpp>

#include <tf/transform_listener.h>
#include <tf/tf.h>
#include <sensor_msgs/LaserScan.h>

#include "std_msgs/String.h"

#include "tf/message_filter.h"
#include "message_filters/subscriber.h"

#include <boost/thread.hpp>
#include <boost/bind.hpp>

#include <geometry_msgs/Twist.h>

#include <stdio.h>
#include <time.h>

//#include <pcl/point_types.h>
#include <eigen3/Eigen/Dense>
#include <eigen3/Eigen/Geometry>

//#include <tf/transform_listener.h>
//#include <sensor_msgs/LaserScan.h>
//#include <sensor_msgs/PointCloud.h>

#include <gazebo_msgs/SetModelState.h>
#include "gazebo_msgs/GetModelState.h"
#include "gazebo_msgs/GetPhysicsProperties.h"
#include <gazebo_msgs/ModelState.h>

#include "but_objdet_msgs/DetectionArray.h"

// ObjDet API
#include "but_objdet/but_objdet.h" // Main objects of ObjDet API
#include "but_objdet/services_list.h" // Names of services provided by but_objdet package
#include "but_objdet/convertor/convertor.h" // Translator from but_objdet messages to standard C++ structures
#include "but_objdet/matcher/matcher_overlap.h" // Matcher (based on overlap)
#include "but_objdet/PredictDetections.h" // Autogenerated service class

#include <ros/ros.h> // Main header of ROS
#include <sensor_msgs/Image.h> // Image message
#include <sensor_msgs/CameraInfo.h>

// OpenCV is available within a vision_opencv ROS stack
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <cv_bridge/cv_bridge.h>

#include <message_filters/subscriber.h>
#include <message_filters/synchronizer.h>
#include <message_filters/sync_policies/approximate_time.h>
#include <message_filters/cache.h>

using namespace sensor_msgs;
using namespace message_filters;

//home/bkhelifa/ros/stacks/trunk/ros/but_object_detection/but_objdet/include/but_objdet

//home/bkhelifa/ros/stacks/trunk/ros/but_object_detection/but_objdet_msgs/msg_gen/cpp/include/

namespace hmi {

/**
 * @class hmi
 * @brief A class adhering to the robot_actions::Action interface that moves the robot base to explore its environment.
 */

//waiting for result from laser and/or Slam
volatile bool waitingforScanOrPos;

//for the obstacle avoidance return true, so the movement should be interrupted
volatile bool isPathNotSafe;
//robot state
volatile bool isMoving;
//laser scan object
static sensor_msgs::LaserScan curr_scan1;
//the robot is searching for target 
volatile bool searchingForTarget;
//the robot reaching the target 
volatile bool reachingTarget;
//waiting for target detection 
volatile bool detectingObject;
//ask the robot to stop all actions 
volatile bool stopInteraction;
//the target has been detected
volatile bool targetDetected;
volatile bool missingTarget;
//the robot is avoiding obstacle, this is not used in this stack
volatile bool isAvoidingObst;
//set to true if the odm is working
volatile bool useOdometry;
//Odm is combined with pcl or not
volatile bool useOdomCombined;
//if false use the conventional tracking (rotation+translation) otherwise use smooth tracking which based on pooling Force
volatile bool useForceTracking;
//if real demo or simulated
volatile bool realDemo;
//if the depth is not working or having problem with it
volatile bool noDepth;
//add robor and target location
double mTx, mTy, mTw, mRx,mRy,mRw,mRox,mRoy,mRoz,mRow;

//use the laser to check save path
bool checkSafepath;

typedef sync_policies::ApproximateTime<Image, CameraInfo> MySyncPolicy;


class HMI 
{
    private:
	bool no;
    public:
 	//! The node handle we'll be using
 	ros::NodeHandle nh_;
 	//! We will be publishing to the "cmd_vel" topic to issue commands
 	ros::Publisher cmd_vel_pub_;
 	//! We will be listening to TF transforms as well
 	tf::TransformListener listener_;
	
	ros::ServiceClient predictClient;
	ros::Subscriber su;
	ros::Subscriber dataSub;
	
	//message_filters::Subscriber<Image> depth_sub;
	//message_filters::Subscriber<CameraInfo> camInfo_sub;
	
	//TimeSynchronizer<Image, CameraInfo> sync;
	//message_filters::Synchronizer< MySyncPolicy > sync;
	
	int CACHE_SIZE;
	int QUEUE_SIZE;
	Cache<Image> depthCache;
	Cache<CameraInfo> camInfoCache;
      
	/**
	* @brief  Constructor
	* @return
	*/
	HMI();
	/**
	* @brief  Destructor - Cleans up
	*/
	virtual ~HMI();

	/**
	* @brief  Runs whenever a new goal is sent to the move_base
	* @param goal The goal to pursue
	* @param feedback Feedback that the action gives to a higher-level monitor, in this case, the position of the robot
	* @return The result of the execution, ie: Success, Preempted, Aborted, etc.
	*/
	  // main tracking function
	  void interaction();
	  void interactionTEST();
	  
	  void spin();
	  // main move function
	  bool moveRobot(bool isRotOrTrans, double distanceOrAngle);
	  
	  //odm based translation
	  bool driveForwardOdom(double distance, double speed=0.045);//0.045
	  //Estimated based translation
	  bool driveForwardWihoutOdom(double distance, double speed=0.045);//=0.045
	  
	  //turn function baseb on Odm
	  bool turnOdom(bool clockwise, double radians);
	  //Estimated based rotation
	  bool turnWihoutOdom(bool clockwise, double radians);
	  //go to a certain location
	  int GoToTarget(double xt, double yt, double wt, double CurrRobotOrientation=0);
	  //calculate  rotations and translations to get the new location. So return Rot, Trans, Rot values
	  tf::Point parametersToGetLocation(tf::Point thisLocation, tf::Point nextLocation);
	  //laser range
	  static sensor_msgs::LaserScan mCurr_scan;
	  
	  //Force based tracking
	  bool forceDrive();
	  //pub comd
	  void pubCmd(geometry_msgs::Twist base_cmd, bool stop);
	  //read the robot and the target position and return the target location IN the robot frame
	  tf::Point getTargetInRobot(void);
	  //return orintaion matrix based on Quaternion
	  tf::Vector3 q2R(tf::Vector3 q);//NOT VERIFIED YET
	  
	  bool isTheMovNotSafe(){
	    return isPathNotSafe;
	  }
	  
	  void rosInit();
	  void chatterCallback(const sensor_msgs::LaserScan::ConstPtr& msg);
	  void getTargetLocation();
	  
	  void syncCallback(const sensor_msgs::ImageConstPtr &depth,
                            const sensor_msgs::CameraInfoConstPtr &camInfo);
	  
	  void newDepthCallback(const sensor_msgs::ImageConstPtr &depthMsg);
	  void getTargetOrientation();
	  
	  bool testv;
	  btVector3 trans_repere(btVector3 t, btVector3 robot);
	  
	  vector<tf::Point> mPrevTarget_center;

};


}



