/**
 * Developed by dcgm-robotics@FIT group
 * Author: Khelifa baizid (baizid@fit.vutbr.cz. OR baizid.khelifa@gmail.com)
 * Date: 15.11.2012 (version 1.0)
 *
 * License: BUT OPEN SOURCE LICENSE
 *
 * Description:
 * See the redme file
 *------------------------------------------------------------------------------
 */
#include <ros/ros.h>
#include <data_bridge/definitions.h>
#include <data_bridge/DTB_Trajectory.h>
//#include <data_bridge/DTB_Odometry.h>

#include <geometry_msgs/PoseStamped.h>
#include <geometry_msgs/Pose.h>
#include <geometry_msgs/PoseArray.h>

//#include <nav_msgs/OccupancyGrid.h>
# include <nav_msgs/Path.h>

#include <vector>
#include <string>

#include <tf/transform_listener.h>

using namespace geometry_msgs;
using namespace std;
//int mPublishingpathRequestTime=0;

//new path message
//data_bridge::DTB_Trajectory messagePUB;
bool mUseArtificialPath=false;
nav_msgs::Path mPathToShow;
ros::Publisher Show_Save_Path_pub;

void convertor_trajectory_callback(data_bridge::DTB_Trajectory message)
{
  mPathToShow.poses.clear();
	int s = message.traj_points.size();
	mPathToShow.header.frame_id = "/base_link";//"/odom_combined";
	mPathToShow.poses.resize(s);
	geometry_msgs::Pose2D singlePos;
	for(int i=0;i<s;i++)
	{       singlePos = message.traj_points[i];
		mPathToShow.poses[i].header.frame_id="/base_link";
		mPathToShow.poses[i].pose.position.x = singlePos.x;
		mPathToShow.poses[i].pose.position.y = singlePos.y;
		mPathToShow.poses[i].pose.position.z = 0;
		//cout<<"x: "<<singlePos.x<<" "<<singlePos.y<<endl;
	}
	for(int i=0;i<1;i++){
	  Show_Save_Path_pub.publish(mPathToShow);
	  //sleep(0.1);
	}
	
	//cout<<"PUBLISHING NEW PATH TO BE SHOWEN IN RVIZ: "<<s<<endl;
	//mPublishingpathRequestTime++;
}

//original path 
//data_bridge::DTB_Trajectory messagePUB_in;
nav_msgs::Path mPathToShow_in;
ros::Publisher Show_Orig_Path_pub;
void convertor_trajectory_callback_in(data_bridge::DTB_Trajectory message)
{
  mPathToShow_in.poses.clear();
	int s = message.traj_points.size();
	mPathToShow_in.header.frame_id = "/base_link";//"/odom_combined";
	geometry_msgs::Pose2D singlePos;
	if(!mUseArtificialPath)
	{
	    mPathToShow_in.poses.resize(s);
	    for(int i=0;i<s;i++)
	    {       singlePos = message.traj_points[i];
		    mPathToShow_in.poses[i].header.frame_id="/base_link";
		    mPathToShow_in.poses[i].pose.position.x = singlePos.x;
		    mPathToShow_in.poses[i].pose.position.y = singlePos.y;
		    mPathToShow_in.poses[i].pose.position.z = 0;
		    //cout<<"x: "<<singlePos.x<<" "<<singlePos.y<<endl;
	    }
	}else{
/*	      //vector on x positions
	      vector<float> v;
	      singlePos.y=0;
	      while(singlePos.x<25){//25m
		  singlePos.x+=0.1;
		  v.push_back(singlePos.x);//0.2 m
	      }
	      //if(i==sizeOrigpath-1)
	      //  cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
	  
	  //TODO THIS IS STUPID I WILL DO IT PROPERLY LATER
	  s=v.size();
	  mPathToShow_in.poses.resize(s);
	  for(int i=0;i<s;i++){
	      mPathToShow_in.poses[i].pose.position.x=v[i];
	      mPathToShow_in.poses[i].pose.position.y=singlePos.y;
	      mPathToShow_in.poses[i].pose.position.z=0;
	      //cout<<i<<" : mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.y<<" mIDs Size: "<<message.object_IDs.size()<<endl;
	  }*/
	  
	}
	//for(int i=0;i<1;i++){}
	Show_Orig_Path_pub.publish(mPathToShow_in);
	  //sleep(0.1);
	
	
	//cout<<"PUBLISHING NEW PATH TO BE SHOWEN IN RVIZ: "<<s<<endl;
	//mPublishingpathRequestTime++;
}

int main( int argc, char** argv)
{
	//this only so we can get rostime
	ros::init(argc, argv, "path_show");
	ros::NodeHandle n;

	n.getParam("UseArtificialPath_sh", mUseArtificialPath);
	/**
	* map if needed.
	*/
	//ros::Subscriber submap = n.subscribe("map", 10, callbackMap);
	/**
	* path request service.
	*/
	//ros::ServiceServer servicePath = n.advertiseService("path_request", callBackPathRequest);
	/**
	* Publishing for rviz.
	*/
	
	//if ObjectLocalization is running TODO remove it later ros::Subscriber get_robot_location;
	ros::Subscriber convertor_subscriber_trajectory;
	//ros::Publisher publisher_path_request;
        convertor_subscriber_trajectory = n.subscribe<data_bridge::DTB_Trajectory>(/*EXPAND(TRAJECTORY_OUT_TOPIC_NAME)*/"/data_bridge_trajectory_out",1000,&convertor_trajectory_callback);
	/* then register publisher - only once */
	Show_Save_Path_pub = n.advertise<nav_msgs::Path>("Safe_path_to_Show", 1000);//ShowPath_pub = n.advertise<geometry_msgs::PoseStamped>("path_to_ShowPath", 1000);
	
	//for original path
	ros::Subscriber convertor_subscriber_trajectory_in;
	//ros::Publisher publisher_path_request;
        //
	//convertor_subscriber_trajectory_in = n.subscribe<data_bridge::DTB_Trajectory>(/*EXPAND(TRAJECTORY_OUT_TOPIC_NAME)*/"/data_bridge_trajectory_in",1000,&convertor_trajectory_callback_in);
	/* then register publisher - only once */
	//
	//Show_Orig_Path_pub = n.advertise<nav_msgs::Path>("Original_path_to_Show", 1000);
	
	
	/*//messagePUB_in.traj_points.resize(3);
	messagePUB_in.object_IDs.resize(1);
	for(int i=0;i<1;i++)
	    messagePUB_in.object_IDs[i]=2;
	
	geometry_msgs::Pose2D singlePos;
	float inc=0;
	for(int i=0;i<100;i++){
	    inc=i*0.1;
	    singlePos.x = inc;
	    singlePos.y = 0;
	    singlePos.theta = 90;//TODO check in abstacle avoidness the orientation of the robot
	    messagePUB_in.traj_points.push_back(singlePos);
	    
	}*/
      
	cout<<"Path_show is runing . . ."<<endl;
	ros::Rate loop_rate(5);
	
	while (ros::ok())
	{
	  ros::spinOnce();
	  loop_rate.sleep();
	}
	
	return 0;

}
