/**
 * Developed by dcgm-robotics@FIT group
 * Author: Khelifa baizid (baizid@fit.vutbr.cz. OR baizid.khelifa@gmail.com)
 * Date: 23.07.2012 (version 1.0)
 *
 * License: BUT OPEN SOURCE LICENSE
 *
 * Description:
 * Path Avoidance.
 * 
 * roslaunch truck_model_for_TB simulation_for_TB.launch
 * roslaunch gmapping tb_sim_gmapping.launch
 * ./bin/bt_path_node
 *------------------------------------------------------------------------------
 */
#include <ros/ros.h>
#include <data_bridge/definitions.h>
#include <data_bridge/DTB_Trajectory.h>
#include <data_bridge/DTB_Odometry.h>

#include <geometry_msgs/PoseStamped.h>
#include <geometry_msgs/Pose.h>
#include <geometry_msgs/PoseArray.h>

#include <vector>
#include <string>

#include <tf/transform_listener.h>
#include <ros/package.h>

bool mUseArtificialPath=false;
geometry_msgs::Pose2D mRobotPose;
bool mFirstTime=true;
using namespace geometry_msgs;
using namespace std;
int mPublishingpathRequestTime=0;

std::string FileName;
int mStart1=0;
int mStop1=0;
int mStart2=0;
int mStop2=0;

int line_num(std::string fm)
{
    FILE *f;char c;
    int lines = 0;
    f = fopen(fm.c_str(), "r");
    if(f == NULL)
    return 0;
    while((c = fgetc(f)) != EOF)
    if(c == '\n')
    lines++;
    fclose(f);
    if(c != '\n')
    lines++;
    return lines;
}


//get example of original path

void robotPseCallback(){
	tf::TransformListener listener;
	ros::Rate rate(10.0);
	bool getPoseOfRobot=false;
	while(!getPoseOfRobot)
	{
	      tf::StampedTransform transform;
	      try
	      {
		listener.lookupTransform("/base_link","/lgv_position",ros::Time(0),transform);
		mFirstTime=false;
		mRobotPose.x=transform.getOrigin().x();
		mRobotPose.y=transform.getOrigin().y();
	      } catch(tf::TransformException ex){
		//ROS_ERROR(" %s ", ex.what());
		std::cout<<"NO lgv_position yet#######################################################-------------------------- "<<std::endl;

	      }
	      getPoseOfRobot=true;
	}
	
        std::cout<<"listener.lookupTransform(+################################################################# "<<mRobotPose.x<<" "<<mRobotPose.y<<std::endl;
}

geometry_msgs::PoseArray getOriginalPath()
{
cout<<"from here 1"<<endl;
  geometry_msgs::Pose2D singlePos;
  geometry_msgs::PoseArray originalPath;
	for(int ijk=0;ijk<3;ijk++){}
	  std::string fm;
	  fm=FileName;
	  int s= line_num(fm)-1;
	  double InitpopA[s][3];
	  
	  //FileName="/home/bkhelifa/ros/stacks/ros/path_request/data/RobotoriginalPath.txt";
	  //FileName0 = PROJECT_SOURCE_DIR;
//cout<<"from here 1 "<<FileName0<<endl;
	  FILE *inpA = fopen(FileName.c_str(), "r");
	  bool endSeg=false;
	  int inc=0;double eps=0.0001;

	  originalPath.poses.resize(s);
	  for(int i=0;i<s;i++){
		  
		  for(int j=0;j<3;j++)
		  {
		    fscanf(inpA,"%lf",&InitpopA[i][j]);
		    
		    if(j==0)
		      singlePos.x=InitpopA[i][j];
		    if(j==1)
		      singlePos.y=InitpopA[i][j];
		    if(j==2&&singlePos.x>0.5&&singlePos.y>0.5){
		      singlePos.theta=InitpopA[i][j];
		      originalPath.poses[i].position.x=singlePos.x;
		      originalPath.poses[i].position.y=singlePos.y-4.8;
		      originalPath.poses[i].position.z=singlePos.theta;
		    }
		  }
		  //cout<<" ++++++++++++++++++++  "<<i<<" "<<originalPath.poses[i].position.x<<" "<<originalPath.poses[i].position.y<<endl;
	  }
	  if(mUseArtificialPath){
		  //First we get the robot position
		  //robotPseCallback();
		  if(!mFirstTime){
		    singlePos.x=mRobotPose.x;
		    singlePos.y=mRobotPose.y-0.01;
		  }else{
		    	 singlePos.x=originalPath.poses[0].position.x;
		         singlePos.y=originalPath.poses[0].position.y;
		  }
		  //mFirstTime=false;
		  //vector on x positions
		  vector<float> v;
		  singlePos.x=mRobotPose.x;
		  singlePos.y=mRobotPose.y-0.01;
		  while(singlePos.x<25){//25m
		      singlePos.x+=0.1;
		      v.push_back(singlePos.x);//0.2 m
		  }
		  //if(i==sizeOrigpath-1)
		  //  cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
		  
		  //TODO THIS IS STUPID I WILL DO IT PROPERLY LATER
		  s=v.size();
		  originalPath.poses.resize(s);
		  for(int i=0;i<s;i++){
		      originalPath.poses[i].position.x=v[i];
		      originalPath.poses[i].position.y=singlePos.y;
		      originalPath.poses[i].position.z=0;
		      //cout<<i<<" : mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.y<<" mIDs Size: "<<message.object_IDs.size()<<endl;
		  }
	  }
	  
//cout<<"from here 1"<<endl;
	return originalPath;
}



int randNumber( int max)
{ /* initialize random generator */

  //srand ( time(NULL) );
  int n=rand() % max;
  //rand();
  return n;
}

//new path message
data_bridge::DTB_Trajectory messagePUB_in;
int main( int argc, char** argv)
{
	//this only so we can get rostime
	ros::init(argc, argv, "path_request");
	ros::NodeHandle n;

	/**
	* map if needed.
	*/
	//ros::Subscriber submap = n.subscribe("map", 10, callbackMap);
	/**
	* path request service.
	*/
	//ros::ServiceServer servicePath = n.advertiseService("path_request", callBackPathRequest);
	/**
	* Publishing for rviz.
	*/
	std::string origiPaathFileName;
	n.getParam("originalFilePathname", origiPaathFileName);
	FileName = ros::package::getPath("path_request");
	
	FileName.append("/data/");
	FileName.append(origiPaathFileName);
	//cout<<FileName<<endl;
	
	n.getParam("UseArtificialPath_req", mUseArtificialPath);
	
	
	n.getParam("start1", mStart1);
	n.getParam("stop1", mStop1);
	n.getParam("start2", mStart2);
	n.getParam("stop2", mStop2);
	cout<<"start1 "<<mStart1<<endl;
	cout<<"stop1 "<<mStop1<<endl;
	cout<<"start2 "<<mStart2<<endl;
	cout<<"stop2 "<<mStop2<<endl;
	
	//if ObjectLocalization is running TODO remove it later
	ros::Subscriber get_robot_location;
	//ros::Subscriber convertor_subscriber_trajectory;
	ros::Publisher publisher_path_request;

	/* register to Omd topic to get LGV location */
	//get_robot_location = n.subscribe<data_bridge::DTB_Odometry>(EXPAND(ODOMETRY_TOPIC_NAME),1000,get_robot_location_callback); 

	/* registration as a topic publisher for data bridge  - 1000 messages stack */
	/* every time the message will come trought the topic you are registerred at the callback funtion will be called */
	publisher_path_request = n.advertise<data_bridge::DTB_Trajectory>(/*EXPAND(TRAJECTORY_IN_TOPIC_NAME)*/"/data_bridge_trajectory_in",1000);
	//cout<<"RAJECTORY_IN_TOPIC . . . 1.0 "<<endl;
	/* then register publisher - only once */
	//publisher_path_request = n.advertise<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_IN_TOPIC_NAME),1000);
	
	//messagePUB_in.traj_points.resize(3);
	srand ( time(NULL) );

	geometry_msgs::Pose2D singlePos;
//cout<<"from here 0"<<endl;
	geometry_msgs::PoseArray orp;

	  orp = getOriginalPath();
	  for(int i=0;i<orp.poses.size();i++){
	      singlePos.x = orp.poses[i].position.x;
	      singlePos.y = orp.poses[i].position.y;//5.904;//
	      singlePos.theta = orp.poses[i].position.z;//TODO check in abstacle avoidness the orientation of the robot
	      messagePUB_in.traj_points.push_back(singlePos);
	  }
	/*float inc=0;
	for(int i=0;i<200;i++){
	    inc=i*0.1;
	    singlePos.x = inc;
	    singlePos.y = 0;
	    singlePos.theta = 90;//TODO check in abstacle avoidness the orientation of the robot
	    messagePUB_in.traj_points.push_back(singlePos);
	    
	}*/
	short Freq=1;
	cout<<"STARTING SENDING REQUEST "<< Freq << "BY SECOND ... !"<<endl;
	ros::Rate loop_rate(Freq);
	messagePUB_in.object_IDs.resize(3);
	while (ros::ok())
	{
//cout<<"SENDING REQUEST ?????????????????????????????????????????????????????"<< mPublishingpathRequestTime<<endl;
	    if(mPublishingpathRequestTime<400) 
	    {
	      if(mPublishingpathRequestTime<500){
		  for(int i=0;i<3;i++)
		      messagePUB_in.object_IDs[i]=randNumber(50);
	      }
	      /*if(mPublishingpathRequestTime>80){
		  for(int i=0;i<3;i++)
		      messagePUB_in.object_IDs[i]=randNumber(50);
	      }*/
	      if(mPublishingpathRequestTime>mStart1&&mPublishingpathRequestTime<mStop1||mPublishingpathRequestTime>mStart2&&mPublishingpathRequestTime<mStop2)
	      publisher_path_request.publish(messagePUB_in);
	      
	      //cout<<"sending request number: "<<mPublishingpathRequestTime<<endl;
	      }
	      mPublishingpathRequestTime++;
	      if(mPublishingpathRequestTime>400) 
	      {
		cout<<"PLEASE LAUNCH THE NODE AGAIN IF YOU ARE STILL USSING IT ... !"<<mPublishingpathRequestTime<<endl;
	      }
	      //cout<<"NOT CALLED calling Object_localization_node . . . 1 "<<endl;

	  ros::spinOnce();
	  loop_rate.sleep();

	}
	messagePUB_in.traj_points.clear();
	return 0;

}
