/**
 * ***************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by dcgm-robotics@FIT group.
 *
 * Author: Khelifa Baizid (baizid.khelifa@gmail.com)
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 19/11/2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <but_path_node/but_path_node.h>
#include <include/but_path_node/but_path_node.h>

#define toMetre 0.001
#define toMMetre 1000


using namespace geometry_msgs;
using namespace std_msgs;
using namespace std;
using namespace ros;

but_path_node::but_path_node()
{
    mGs = new GetNewPath(40,40,0.05);
    //initialze state
    State.requestAlreadyReceived=false; State.therIsSolution=false; State.obstaclesAreFareFromRobot=false; State.avoidancePathWasCalculated=false; State.noObstaclesFromLocalizationModule=false;
    State.RequestIsNotValid=false;
    State.firstRequest=true;
    State.weHaveSafePath=false;
    State.pathScoor=0.0;
    State.robotLocationForThisPath.x=0;
    State.robotLocationForThisPath.y=0;
    State.robotLocationForThisPath.theta=0;
    
    //mGetingRobotLocation = false;//NOTE	not used

    //mWaitingForEnvirPerception=true;NOTE	 not used

    //showing the obstacles in rviz or not: this flag is defined in the launch file

    inctest=0;
	
    mMinDistanceToObstacles=3500;
    mTesting=false;
    mShowObstacles=false;
    mComeBackToOriginalPath=false;
    mMinMaxOfCorredor=4;
    mLGV_size=2;
    mPutObst=false;
    mPrevMode="NULL";
    mUseIncrementalRobPos=false;
    mIncrementalRobPos=0;
    mUseSafePathMode=true;
    mFrame = "/odom";
    mAvoidancePathLength=10;
    mOverSize=false;
    intFunc();

}

but_path_node::~but_path_node()
{
//NOTE 
}

//initialization function
void but_path_node::intFunc()
{
	ShowExtPoint_pub = n.advertise<geometry_msgs::PoseStamped>("FreePoint", 1000);//ShowPath_pub = n.advertise<geometry_msgs::PoseStamped>("path_to_ShowPath", 1000);
	
	//if ObjectLocalization is running TODO remove it later

	if(mPublishCommt)
	cout<<"STARTING PATH PLANNER NODE . . .  "<<endl;
	/* register to Omd topic to get LGV location */
	//get_robot_location = n.subscribe<data_bridge::DTB_Odometry>(EXPAND(ODOMETRY_TOPIC_NAME),1000,get_robot_location_callback); 

	/* registration as a topic publisher for data bridge  - 1000 messages stack */
	/* every time the message will come trought the topic you are registerred at the callback funtion will be called */
	convertor_subscriber_trajectory = n.subscribe<data_bridge::DTB_Trajectory>("/data_bridge_trajectory_in",1000,&but_path_node::convertor_trajectory_callback, this);

	 //convertor_subscriber_trajectory = n.subscribe<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_IN_TOPIC_NAME),1000, &but_path_node::convertor_trajectory_callback, this);

        //su = nh_.subscribe("/scan", 10, &HMI::chatterCallback, this);
	/* then register publisher - only once */
	convertor_publisher_trajectory = n.advertise<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_OUT_TOPIC_NAME),1000); 

	
	obstacles_pub = n.advertise<visualization_msgs::MarkerArray>( "ObstaclesToShow", 0 );
	
	//for showing the original path on RVIZ
	show_Orig_Path_pub = n.advertise<nav_msgs::Path>("OriginalPpathToShow", 1000);
	
	//for showing the original path on RVIZ
	show_Save_Path_pub = n.advertise<nav_msgs::Path>("SavePpathToShow", 1000);
}
//publishe obstacles as  marker array
void but_path_node::publishObstacle(VectorPointD xy, VectorPointD dim)
{
   visualization_msgs::Marker marker;
   for (int i=0;i<xy.size();i++)//for (int i=0;i<1;i++)//
   {
      marker.header.frame_id = mFrame;//marker.header.frame_id = "base_link";
      marker.header.stamp = ros::Time::now();
      marker.ns = "my_namespace";
      marker.id = i;
      marker.type = 3;//visualization_msgs::Marker::CYLINDER;//SPHERE;
      marker.action = visualization_msgs::Marker::ADD;
      marker.pose.position.x = xy[i].mX/1000;
      marker.pose.position.y = xy[i].mY/1000;
      marker.pose.position.z = 0;
      marker.pose.orientation.x = 0.0;
      marker.pose.orientation.y = 0.0;
      marker.pose.orientation.z = 0.0;
      marker.pose.orientation.w = 1.0;
      if(dim[i].mX<0.1)dim[i].mX=0.1;
      if(dim[i].mY<0.1)dim[i].mY=0.1;
      marker.scale.x = dim[i].mX;//1;//
      marker.scale.y = dim[i].mY; //1;//     
      marker.scale.z = 0.1;
      marker.color.a = 1.0;
      marker.color.r = 0.1;
      marker.color.g = 0.0;
      marker.color.b = 1.0;
      markerAr.markers.push_back(marker);
   }
   //marker.mesh_resource = "/opt/ros/electric/stacks/pr2_common/pr2_description/meshes/base_v0/base.dae";//"package://pr2_description/meshes/base_v0/base.dae";
   for(int i=0;i<2;i++)
      obstacles_pub.publish(markerAr);
   markerAr.markers.clear();
   //only if using a MESH_RESOURCE marker type:
   //obstacles_pub.publish(marker);
}

//TODO change it to use message of objectLocalization


vector<mObstacleSize> but_path_node::getObstaclesInTheWay_real_safepathMode(geometry_msgs::PoseArray originalTrj, vector<int> IDs, vector<but_object_localization::FusedObject> localized_objects)
{
      vector<mObstacleSize> out;
      but_object_localization::FusedObject singleObject;

      //first we get the closest point between the robot location and the original path
      int pathSise=0;
      pathSise = originalTrj.poses.size();
      //mOriginalTrj_real.poses[0].position.x
      int locationID=0;
      std::vector<double> distVect;
      distVect.resize(pathSise);
      for(int i=0;i<pathSise;i++)
      {
	float dx=mOriginalTrj_real.poses[i].position.x-mRobotLocationMap.x;
	float dy=mOriginalTrj_real.poses[i].position.y-mRobotLocationMap.y;
	distVect[i]= sqrt(dx*dx+dy*dy)*1000;
      }
      //get the min distance to the robot location
      double minDist =  mGs->MinArrayk(distVect);
      locationID = mGs->ThisElementArray(distVect, minDist);
      if(locationID>pathSise)locationID=pathSise-1;
      //get the losest location
      geometry_msgs::Pose2D location;
      location.x=mOriginalTrj_real.poses[locationID].position.x;
      location.y=mOriginalTrj_real.poses[locationID].position.y;
      //find the temporrary from this location and after some obstacles
      //im got new idea
      
      
      int s=localized_objects.size();
//cout<<"-------++++++++++++ 0: "<<s<<endl;
      bool obstaclesAreClose=false;
      for(int i=0;i<s;i++)
      {
	    mObstacleSize ob;
	    singleObject = localized_objects[i];
	    float dist=sqrt(singleObject.bbox.center.x*singleObject.bbox.center.x+singleObject.bbox.center.y*singleObject.bbox.center.y)*1000;
            if(dist<mMinDistanceToObstacles)//&&dist>200)
	    {
		  ob.f=Point2dDouble(singleObject.re.x*1000, singleObject.re.y*1000);
		  ob.l=Point2dDouble(singleObject.le.x*1000, singleObject.le.y*1000);
		  ob.c=Point2dDouble(singleObject.bbox.center.x*1000, singleObject.bbox.center.y*1000);
		  ob.Closer=dist;
		  ob.Size = mGs->DistanceTwoPointsk(ob.f,ob.l);
		  ob.Depth=singleObject.bbox.height;
		  if(ob.Depth<singleObject.bbox.width) ob.Depth=singleObject.bbox.width;
	
		  ob.maxp.mX=ob.c.mX+(ob.Depth+mMinDistanceToObstacles/1000)*1000;
		  ob.maxp.mY=ob.c.mY;

		    //cout<<"ob "<<i<<endl;
		    //if(dist<nearObj){
			//  nearObj=dist;
			//  nearObj_ID=i;    
		    //}
		  }
		   //pting some obstacles in front of the LGV
		  if(mPutObst){
		      ob.f=Point2dDouble(3*1000, 0.5*1000);
		      ob.l=Point2dDouble(3*1000, -0.5*1000);
		      ob.c=Point2dDouble(3*1000, 0.0001*1000);
		      ob.Closer=3*1000;
		      ob.Size = mGs->DistanceTwoPointsk(ob.f,ob.l);
		      ob.Depth=0.5*1000;
		      ob.maxp.mX=ob.c.mX+(ob.Depth+mMinDistanceToObstacles);
		      ob.maxp.mY=ob.c.mY;
		  }
		  //END test 
		  //ob.Size = sqrt((singleObject.l.x-singleObject.f.x)*(singleObject.l.x-singleObject.f.x)+(singleObject.l.y-singleObject.f.y)*(singleObject.l.y-singleObject.f.y));
		  //except big objects
		  if(ob.Size>10){
		    out.push_back(ob);
		    obstaclesAreClose=true;
	    }
      }
      State.obstaclesAreFareFromRobot=!obstaclesAreClose;
  return out;
}

vector<mObstacleSize> but_path_node::getObstaclesInTheWay_real(geometry_msgs::PoseArray originalTrj, vector<int> IDs, vector<but_object_localization::FusedObject> localized_objects)
{
      vector<mObstacleSize> out;
      but_object_localization::FusedObject singleObject;
      //map all IDs and get the size which include all objects;
      //BEcause we don't have IDs so we check those near to the robot
      //get the center and araduse of all those objects which are very c,ose to the robot
      //out.resize(IDsClose.size());
      //float nearObj=1000000;
      //int nearObj_ID=0;

      int s=localized_objects.size();
//cout<<"-------++++++++++++ 0: "<<s<<endl;
      bool obstaclesAreClose=false;

      //cout<<"---++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++----++++++++..............++++ 0: "<<inctest<<endl;
//
      for(int i=0;i<s;i++)
      {
	    mObstacleSize ob;
	    singleObject = localized_objects[i];
	    float dist=sqrt(singleObject.bbox.center.x*singleObject.bbox.center.x+singleObject.bbox.center.y*singleObject.bbox.center.y)*1000;
            if(dist<mMinDistanceToObstacles&&dist>200)
	    {
		  //Point2dDouble f, l, c;//float Size;//int Closer; 
		  ob.f=Point2dDouble(singleObject.re.x*1000, singleObject.re.y*1000);
		  ob.l=Point2dDouble(singleObject.le.x*1000, singleObject.le.y*1000);
		  ob.c=Point2dDouble(singleObject.bbox.center.x*1000, singleObject.bbox.center.y*1000);
		  ob.Closer=dist;
		  ob.Size = mGs->DistanceTwoPointsk(ob.f,ob.l);
		  ob.Depth=singleObject.bbox.height;
		  if(ob.Depth<singleObject.bbox.width) ob.Depth=singleObject.bbox.width;
	
		  ob.maxp.mX=ob.c.mX+(ob.Depth+mMinDistanceToObstacles/1000)*1000;
		  ob.maxp.mY=ob.c.mY;

		    //cout<<"ob "<<i<<endl;
    
		    //if(dist<nearObj){//  nearObj=dist;//  nearObj_ID=i; //}
	    }
	    //pting some obstacles in front of the LGV 

	    if(mPutObst/*||inctest>44&&inctest<158*/){
		ob.f=Point2dDouble(3*1000, 0.5*1000);
		ob.l=Point2dDouble(3*1000, -0.5*1000);
		ob.c=Point2dDouble(3*1000, 0.0001*1000);
		ob.Closer=3*1000;
		ob.Size = mGs->DistanceTwoPointsk(ob.f,ob.l);
		ob.Depth=0.5*1000;

		ob.maxp.mX=ob.c.mX+(ob.Depth+mMinDistanceToObstacles);
		ob.maxp.mY=ob.c.mY;
	    }
	    //END test 
	    //ob.Size = sqrt((singleObject.l.x-singleObject.f.x)*(singleObject.l.x-singleObject.f.x)+(singleObject.l.y-singleObject.f.y)*(singleObject.l.y-singleObject.f.y));
	    //except big objects
	    if(ob.Size>10){
	      out.push_back(ob);
	      obstaclesAreClose=true;
	    }
      }
      State.obstaclesAreFareFromRobot=!obstaclesAreClose;
  return out;
}

void but_path_node::poseCallback(geometry_msgs::Pose2D msg){
     static tf::TransformBroadcaster br;
     tf::Transform transform;
     transform.setOrigin( tf::Vector3(msg.x, msg.y, 0.0) );
     transform.setRotation( tf::Quaternion(/*msg.theta*/0, 0, 0) );
     br.sendTransform(tf::StampedTransform(transform, ros::Time::now(), mFrame, "lgv_position"));
     // br.sendTransform(tf::StampedTransform(transform, ros::Time::now(), "base_link", "lgv_position"));

   /*  
     //TESTING
     	tf::TransformListener listener;
	ros::Rate rate(10.0);
	bool getPoseOfRobot=false;
	float x = 0;
	float y = 0;
	tf::StampedTransform transformN;
	try
	{
	  bool cycle=listener.waitForTransform("lgv_position", "base_link", ros::Time(0), ros::Duration(1000.0), ros::Duration(0.01), NULL);//"odom_combined"// ros::Time(0), ros::Duration(1.0));

	  std::cout<<"lgv_position yet#######################################################-----------------SEND: "<<cycle<<std::endl;
	  listener.lookupTransform("lgv_position","base_link",ros::Time(0),transformN);
	  
	  x=transformN.getOrigin().x();
	  y=transformN.getOrigin().y();
	} catch(tf::TransformException ex){
	  //ROS_ERROR(" %s ", ex.what());
	  std::cout<<"lgv_position yet#######################################################-----------------HEAR "<<x<<" "<<y<<std::endl;

	}*/
}
//int ik=0;



void but_path_node::publish_original_path()
{
	nav_msgs::Path mPathToShow_in;
	geometry_msgs::Pose2D singlePos;
	if(mShowObstacles)
	{
	    if(State.weHaveSafePath)
	    {
	        int s = mOriginalTrj_real.poses.size();
	      	//cout<<s<<" : 0 PUBLISHING ORIGINAL PATHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHNEW PATH TO BE SHOWEN IN RVIZ: "<<endl;

		mPathToShow_in.poses.resize(s);
		for(int i=0;i<s;i++)
		{       
			mPathToShow_in.poses[i].header.frame_id=mFrame;
			mPathToShow_in.poses[i].pose.position.x = mOriginalTrj_real.poses[i].position.x/1000;
			mPathToShow_in.poses[i].pose.position.y = (mOriginalTrj_real.poses[i].position.y)/1000+0.05;
			mPathToShow_in.poses[i].pose.position.z = 0;
			//cout<<"x: "<<singlePos.x<<" "<<singlePos.y<<endl;
		}
		//Publish now
		show_Orig_Path_pub.publish(mPathToShow_in);
	    }else{
	        int s = mFirstOriginalTraj.poses.size();
	      	//cout<<s<<" :first PUBLISHING ORIGINAL PATHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHNEW PATH TO BE SHOWEN IN RVIZ: "<<endl;
	
		mPathToShow_in.poses.resize(s);
		for(int i=0;i<s;i++)
		{       
			mPathToShow_in.poses[i].header.frame_id=mFrame;
			mPathToShow_in.poses[i].pose.position.x = mFirstOriginalTraj.poses[i].position.x/1000;
			mPathToShow_in.poses[i].pose.position.y = (mFirstOriginalTraj.poses[i].position.y)/1000+0.05;
			mPathToShow_in.poses[i].pose.position.z = 0;
			//cout<<"x: "<<singlePos.x<<" "<<singlePos.y<<endl;
		}
		//Publish now
		show_Orig_Path_pub.publish(mPathToShow_in);
	    }
	    

	    //calculate the safe path for publishing it
	    mPathToShow_in.poses.clear();
	    int ss = messagePUB.traj_points.size();
	    mPathToShow_in.poses.resize(ss);
	    geometry_msgs::Pose2D singlePost;
	    if(ss){
	      	for(int i=0;i<ss;i++){
		  mPathToShow_in.header.frame_id = mFrame;
		  singlePost=messagePUB.traj_points[i];//.push_back(singlePost);
		  mPathToShow_in.poses[i].pose.position.x = singlePost.x;
		  mPathToShow_in.poses[i].pose.position.y = singlePost.y;
		  mPathToShow_in.poses[i].pose.position.z = 0;
		} 
	    //Publish now
	    show_Save_Path_pub.publish(mPathToShow_in);
	    }
	    //cout<<ss<<" :safe PATHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHNEW PATH TO BE SHOWEN IN RVIZ: "<<endl;

	}
	
	//TEST_COM_WITH_OBJECT_LOCALZ	        int s = mFirstOriginalTraj.poses.size();
	int s = mFirstOriginalTraj.poses.size();
	
	mPathToShow_in.poses.resize(s);
	for(int i=0;i<s;i++)
	{       
		mPathToShow_in.poses[i].header.frame_id=mFrame;
		mPathToShow_in.poses[i].pose.position.x = mFirstOriginalTraj.poses[i].position.x/1000;
		mPathToShow_in.poses[i].pose.position.y = (mFirstOriginalTraj.poses[i].position.y)/1000+0.05;
		mPathToShow_in.poses[i].pose.position.z = 0;
		//cout<<"x: "<<singlePos.x<<" "<<singlePos.y<<endl;
	}
	//Publish now
	show_Orig_Path_pub.publish(mPathToShow_in);
	//for(int i=0;i<1;i++){}
	//sleep(0.1);
	
	//mPublishingpathRequestTime++;
}

void but_path_node::outputingOriginalPath()
{
	geometry_msgs::Pose2D singlePost;
        messagePUB.traj_points.clear();
	int sizeNewpath = mOriginalTrj_real.poses.size();
	messagePUB.traj_points.resize(sizeNewpath);
	float dir=0;
	for(int i=0;i<sizeNewpath;i++){
	    if(i>0)
	      dir=atan2(mOriginalTrj_real.poses[i].position.y-mOriginalTrj_real.poses[i-1].position.y, mOriginalTrj_real.poses[i].position.x-mOriginalTrj_real.poses[i-1].position.x);
	    singlePost.x = mOriginalTrj_real.poses[i].position.x/1000;
	    singlePost.y = mOriginalTrj_real.poses[i].position.y/1000;
	    singlePost.theta = dir;//mOriginalTrj_real.poses[i].position.z;
	    messagePUB.traj_points[i]=singlePost;//.push_back(singlePos);
	}
}

void but_path_node::Out_put_safe_path(string mode)
{
    if(mode=="a"){
      messagePUB.mode=1;
      //cout<<"-------**********-------[[ OUT PUTING NEW PATH ]]-------**********-------: "<<inctest<<" "<<endl;
    }
    if(mode=="f"){
	messagePUB.mode=2;
	//if(!mShowObstacles){}
	messagePUB.traj_points.clear();messagePUB.object_IDs.clear();
	
      //cout<<"-------**********-------[[ OUT PUTING EMPTY PATH ]]-------**********-------: "<<inctest<<" "<<endl;
    }
    if(mode=="p"){messagePUB.mode=2;
      //cout<<"-------**********-------[[ OUT PUTING PREVIOUS PATH ]]-------**********-------: "<<inctest<<" "<<endl;
    }

    if(mode=="o"){messagePUB.mode=2;
      //cout<<"-------**********-------[[ OUT PUTING ORIGINAL PATH ]]-------**********-------: "<<inctest<<" "<<endl;
    }
    if(messagePUB.mode==2){//if(mShowObstacles&&messagePUB.mode==2)
      outputingOriginalPath();
    }
    if(mode=="a"||mode=="p"||mode=="o")
      mPrevMode="a";
    else{
      mPrevMode="f";
    }
    if(mode=="connectToorigPath"){
      	messagePUB.mode=1;
    }
    //Publishing the message
    convertor_publisher_trajectory.publish(messagePUB);
}

/*this method is not used but we keep it
geometry_msgs::PoseArray but_path_node::recalculateNewOriginalpath(geometry_msgs::PoseArray  mOriginalTrj_real, geometry_msgs::Pose2D robotPose)
{
      //fine the ID of the path
      geometry_msgs::PoseArray pathOut;
      pathOut.header=mOriginalTrj_real.header;
      pathOut.header.frame_id=mOriginalTrj_real.header.frame_id;
      int sizeOrigpath = mOriginalTrj_real.poses.size();
      //mOriginalTrj_real.poses.clear();
      float dx = 0;
      float dy = 0;
      float x;
      bool IDfound=false;
      for(int i=0;i<sizeOrigpath;i++)
      {
	dx=mOriginalTrj_real.poses[i].position.x-robotPose.x*1000;
	dy=mOriginalTrj_real.poses[i].position.y-robotPose.y*1000;
	x=sqrt(dx*dx+dy*dy);
	//cout<<" +++++++++++++++++++++++++++++************************++++++++++++++++++++++++: "<<x<<" . . . "<<dx<<" : "<<dy<<" robot pose "<<robotPose.x<<endl;
	if(x<100&&!IDfound)//10 cm
	{IDfound=true;}
	if(IDfound){
	  //pathOut.poses.resize(sizeOrigpath-i);
	  //for(int j=0;j<sizeOrigpath;j++)
	  //{
	    pathOut.poses.push_back(mOriginalTrj_real.poses[i]);
	  //}
	}

      }
//   	int sizeOrigpath = message.traj_points.size();
//       mOriginalTrj_real.poses.resize(sizeOrigpath);
//       for(int i=0;i<sizeOrigpath;i++){
// 	  singlePos = message.traj_points[i];
// 	  mOriginalTrj_real.poses[i].position.x=singlePos.x*1000;
// 	  mOriginalTrj_real.poses[i].position.y=singlePos.y*1000;
// 	  mOriginalTrj_real.poses[i].position.z=singlePos.theta;
      if(mPublishCommt)
      cout<<" +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"<<mOriginalTrj_real.poses.size()<<" : "<<pathOut.poses.size()<<endl;
      return pathOut;
}*/

/*void outputingNewPath() 
{
	geometry_msgs::Pose2D singlePost;
        messagePUB.traj_points.clear();
	int sizeNewpath = mOriginalTrj_real.poses.size();
	messagePUB.traj_points.resize(sizeNewpath);
	for(int i=0;i<sizeNewpath;i++){
	    singlePost.x = mOriginalTrj_real.poses[i].position.x/1000;
	    singlePost.y = mOriginalTrj_real.poses[i].position.y/1000;
	    singlePost.theta = mOriginalTrj_real.poses[i].position.z;
	    messagePUB.traj_points[i]=singlePost;//.push_back(singlePost);
	}  
}*/

vector<geometry_msgs::Pose2D> but_path_node::calculateOriginalPath(geometry_msgs::PoseArray pathIn)
{
      geometry_msgs::Pose2D singlePos;
      geometry_msgs::PoseArray pathOut;
      pathOut.poses.resize(5000);
      int s=pathIn.poses.size();
     

      int incpath_y=0;
      int inc=0;
      for(int i=0;i<s-1;i++)
      {
	//cout<<" calculateOriginalPath "<<s<<endl;
	  singlePos.x=pathIn.poses[i].position.x;
	  singlePos.y=pathIn.poses[i].position.y;
	  singlePos.theta=pathIn.poses[i].position.z;
	  //each segment
	  
	  bool nextPointReached=false;
	  double dx=pathIn.poses[i+1].position.x-singlePos.x;
	  double dy=pathIn.poses[i+1].position.y-singlePos.y;
	  double dir = mGs->AngleDistanceTwoPointsk(dy, dx);
	  double d = mGs->DistanceTwoPointsk(dx, dy);
	  int si=(int)d/0.1;
	  pathOut.poses[0]=pathIn.poses[0];
	  if(si>=1)
	  {
	    //cout<<" inc s "<<si<<" inc "<<" : "<<inc<<endl;
	    double distBetweenPOints=0.1;
            geometry_msgs::PoseArray Temp;
	    Temp.poses.resize(si);
	    geometry_msgs::PoseStamped prev;
	    prev.pose.position.x = singlePos.x;
	    prev.pose.position.y = singlePos.y;
	    //prev.pose.position.z = singlePos.theta;
	    for(int j=0;j<si;j++){//while(!nextPointReached){//25m

		if(j<si-1){
		   geometry_msgs::PoseStamped p;
		   
		   p.pose.position.x =distBetweenPOints*cos(dir)+prev.pose.position.x;
		   p.pose.position.y =distBetweenPOints*sin(dir)+prev.pose.position.y;
		   p.pose.position.z=dir;
		   prev=p;
		   //Temp.poses[j]=p;
		   pathOut.poses[inc].position=p.pose.position;
		   inc++;
		}else{
		   geometry_msgs::PoseStamped p;
		   p.pose.position.x=pathIn.poses[i+1].position.x;
		   p.pose.position.y=pathIn.poses[i+1].position.y;
		   p.pose.position.z=dir;
		   //Temp.poses[j]=p;
		   pathOut.poses[inc].position=p.pose.position;
		   inc++;
		}
		double dd = mGs->DistanceTwoPointsk(dx, dy);
		if(dd>=0.1)nextPointReached=true;
		//if(i==sizeOrigpath-1)cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
	    }
	}
	else
	{
	  pathOut.poses[inc]=pathIn.poses[i];
	  
	  inc++;
	}
      }
      
      vector<geometry_msgs::Pose2D> pathOutOut;
      pathOutOut.resize(inc);
      //float dir=0;
      for(int j=0;j<inc;j++){
	  //if(j>0)
	    //float dir=atan2(pathOut.poses[j].position.y-pathOut.poses[j-1].position.y, pathOut.poses[j].position.x-pathOut.poses[j-1].position.x);
	  pathOutOut[j].x=pathOut.poses[j].position.x;
	  pathOutOut[j].y=pathOut.poses[j].position.y;
	  pathOutOut[j].theta=pathOut.poses[j].position.z;
	//cout<<"x: "<<pathOutOut[j].x<<" y: "<<pathOutOut[j].y<<endl;
      }
      //cout<<" calculateOriginalPath........ s "<<inc<<endl;
      //TODO THIS IS STUPID I WILL DO IT PROPERLY LATER
      /*s=v.size();
      mOriginalTrj_real.poses.resize(s);
      if(State.firstRequest)
	mFirstOriginalTraj.poses.resize(s);
      for(int i=0;i<s;i++){
	  mOriginalTrj_real.poses[i].position.x=v[i]*1000;// singlePos.x*1000;
	  mOriginalTrj_real.poses[i].position.y=singlePos.y*1000;//singlePos.y*1000;
	  mOriginalTrj_real.poses[i].position.z=0;//singlePos.theta;
	  //NOW if the first request save the first irugunal path, this path can be used later
	  mFirstOriginalTraj.poses[i]=mOriginalTrj_real.poses[i];
	  //cout<<i<<" : mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.y<<" mIDs Size: "<<message.object_IDs.size()<<endl;
      }*/
      return pathOutOut;
}
//bool TESTING_WITH_ORIGINAL_PATH_ONLY_ONES=false;
vector<but_object_localization::FusedObject> but_path_node::getAndvisulizeObstacles()
{
  //wait a momment plz
  sleep(0.5);
      vector<but_object_localization::FusedObject> actual_localized_objects_all;
      //but_object_localization::GetFusedObjects::Request req;
      //but_object_localization::GetFusedObjects::Response res;
      
      //call the servise with this ID HOWEVER WE WILL GET ALL TYPES
      ros::NodeHandle nh_;//TODO CHANE IT LATER TP n
      //create service client
      ros::ServiceClient service_client_objLc = nh_.serviceClient<but_object_localization::GetFusedObjects>(but_object_localization::BUT_OBJDET_GetFusedObjects_SRV);
      //map all objects in the following vector
      
      //bool thereIsObjects=false;thereIsObjects=true;
      
      for(int ids=0;ids<1;ids++)//for(int ids=0;ids<IDsSize;ids++)//TODO because i am geting al objects so I need to call it only ones
      {
	    //create request
	    but_object_localization::GetFusedObjects srv;
	    //only avoidable objects
	    srv.request.class_id = -1;//mIDs[ids];//2;LGV=2 //specify class id
	    srv.request.f_time = ros::Time::now(); //specify time TODO ask radim About message.f_time;//
	    srv.request.f_dur = ros::Duration(1.0); //specify duration
	    srv.request.robot_frame = 1; //specify coordinate frame 1=>robot frame 1 => in the global frame
	    State.noObstaclesFromLocalizationModule = true;
	    short callingtimes=0;
	    //while(callingtimes<2&&State.noObstaclesFromLocalizationModule){}
		    callingtimes++;
		    if(mPublishCommt)
			  cout<<"Waiting for calling Object_localization_node . . .: "<<endl;
		    if (service_client_objLc.call(srv)){
			  //map all objects 
			  int ObjectsS=0;
			  ObjectsS = srv.response.objects.objects.size();


			  if(ObjectsS>0)
			  {
			      actual_localized_objects_all.resize(ObjectsS);
			      for(int i=0;i<ObjectsS;i++)
			      {
				  //but_object_localization::FusedObject ob;ob = srv.response.objects.objects[i];
				  actual_localized_objects_all[i]=srv.response.objects.objects[i];//.push_back(ob);//actual_localized_objects_all.push_back(actual_localized_objects);
				  
				  State.noObstaclesFromLocalizationModule = false;
			      }
			  }
			  //save the location of the robot_frame
			  but_object_localization::RobotPosition pr;
			  pr = srv.response.position;
			  
			  if(!mUseIncrementalRobPos){
			    mRobotLocationMap.x=pr.position.x;
			    mRobotLocationMap.y=pr.position.y;
			    mRobotLocationMap.theta=pr.rotation;
			  }else{
			    mRobotLocationMap.x= mFirstOriginalTraj.poses[mIncrementalRobPos].position.x/1000;
			    mRobotLocationMap.y= mFirstOriginalTraj.poses[mIncrementalRobPos].position.y/1000;
			    mRobotLocationMap.theta=mFirstOriginalTraj.poses[mIncrementalRobPos].position.z;
			    mIncrementalRobPos+=2;
			  }
			  //publishung he robot trnsform
			  if(mShowObstacles)
			    poseCallback(mRobotLocationMap);

			  if(mPublishCommt)
			   cout<</*callingtimes<<*/" :......mRobotLocationMap . . . : "<<mRobotLocationMap.x<<" : "<<mRobotLocationMap.y<<" : "<<180/3.14159*mRobotLocationMap.theta<<endl;
			  
			  //cout<<mRobotLocationMap.x<<" "<<mRobotLocationMap.y<<" "<<mRobotLocationMap.theta<<endl;
			  //for(int i=0;i<actual_localized_objects_all.size();i++){
			  //    but_object_localization::FusedObject ob;ob = actual_localized_objects_all[i];
			  //    cout<<"calling Object_localization_node . . . re: "<<ob.re.x <<" "<<ob.re.y<<" le: "<<ob.le.x <<" "<<ob.le.y<<endl;
			  //}
			  //ros::Duration(500).sleep();
		    }else{
		      State.noObstaclesFromLocalizationModule = true;
		      sleep(0.1);
		      //cout<<"NOT CALLED calling Object_localization_node . . . 2 "<<endl;
		    }
	    
	    //we recalculate the original path as start from the current position of the robot
	    //find te ID of the path where is the robot_frame
	    
	    //THIS FUNCTION SHOULD BE CALLED ONLY ONE
	    //if(!State.noObstaclesFromLocalizationModule&&!TESTING_WITH_ORIGINAL_PATH_ONLY_ONES){//TODO CHECK WHY ONES
	    //mOriginalTrj_real = recalculateNewOriginalpath(mOriginalTrj_real, mRobotLocationMap);
	    //TESTING_WITH_ORIGINAL_PATH_ONLY_ONES=true;
	    //}
	  //if(i==sizeOrigpath-1)
	  //  cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
      }
      if(mShowObstacles&&!State.noObstaclesFromLocalizationModule){
	    float nearObj=1000000;
	    //int nearObj_ID=0;
	    vector<int> nearObj_ID_vect;
	    int s=actual_localized_objects_all.size();

	    VectorPointD xy; 
	    VectorPointD dim;

	    xy.resize(s);//x.resize(1);//
	    dim.resize(s);//dim.resize(1);//
	    for(int i=0;i<s;i++)
	    {
		int idd=i;//nearObj_ID_vect[i];
		xy[i].mX=actual_localized_objects_all[idd].bbox.center.x*1000;//localized_objects[nearObj_ID].bbox.center.x;//
		xy[i].mY=actual_localized_objects_all[idd].bbox.center.y*1000;//localized_objects[nearObj_ID].bbox.center.y;//
		dim[i].mX=actual_localized_objects_all[idd].bbox.width;
		dim[i].mY=actual_localized_objects_all[idd].bbox.height;
	    }
	    //transfpr obstacles to the global frame
	    xy = mGs->TransformPathPointsToGlobalFrame(xy, mRobotLocationMap);
	    publishObstacle(xy, dim);
	    //if(mPublishCommt)
	    //cout<<"+++++ near obstacles number is : "<<s<<" "<<nearObj/1000<<endl;
      }
      //cout<<nearObj_ID<<" :-------near oject is on-------: "<<x<<" "<<y<<" "<<nearObj/1000<<endl;
      //cout<<"-------near oject is on-------: "<<localized_objects[nearObj_ID].re.x<<" "<<localized_objects[nearObj_ID].re.y<<" "<<endl;
      //cout<<"-------near oject is on-------: "<<localized_objects[nearObj_ID].le.x<<" "<<localized_objects[nearObj_ID].le.y<<" "<<endl;
      
      return actual_localized_objects_all;
}
//check if the request is different from the previous ones


void but_path_node::convertor_trajectory_callback(data_bridge::DTB_Trajectory message)
{
  //cout<< mRobotLocationMap.x<<" : "<<mRobotLocationMap.y<<" : mIncrementalRobPosmIncrementalRobPosmIncrementalRobPosmIncrementalRobPosmIncrementalRobPosmIncrementalRobPos: "<<mIncrementalRobPos<<endl;
  //if(mPublishCommt){
  //  cout<<"State.RequestIsNotValid "<<State.RequestIsNotValid<<endl;
  //  cout<<"State.requestAlreadyReceived "<<State.requestAlreadyReceived<<endl;
  //  cout<<"State.therIsSolution "<<State.therIsSolution<<endl;
  //  cout<<"State.avoidancePathWasCalculated "<<State.avoidancePathWasCalculated<<endl;
  //  cout<<"State.noObstaclesFromLocalizationModule "<<State.noObstaclesFromLocalizationModule<<endl;
  //  cout<<"State.obstaclesAreFareFromRobot "<<State.obstaclesAreFareFromRobot<<endl;
  //  cout<<"State.firstRequest "<<State.firstRequest<<endl;
  //  cout<<"  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - "<<endl;
  //}
  inctest++;

      messagePUB.header=message.header;
      geometry_msgs::Pose2D singlePos;//used everywhere
      
      int IDsSize=0;
      int sizeOrigpath = message.traj_points.size();
      
      //if mShowObstacles and path publish the original path
      if(mTesting){
	      //calculate the original path as a simple path toward the X 
	      //bool TEST=false;
	      if(!State.weHaveSafePath){
		    mOriginalTrj_real.poses.clear();
		    int s=0;//message.traj_points.size();
		    int incpath_y=0;
		    singlePos.x=mRobotLocationMap.x;
		    singlePos.y=mRobotLocationMap.y;
		    singlePos.theta=mRobotLocationMap.theta;
		    vector<float> v;
		    while(singlePos.x<35){//25m
			singlePos.x+=0.1;
			v.push_back(singlePos.x);//0.2 m
			//if(i==sizeOrigpath-1)cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
		    }
		    //TODO THIS IS STUPID I WILL DO IT PROPERLY LATER
		    s=v.size();
		    mOriginalTrj_real.poses.resize(s);
		    if(State.firstRequest)
		      mFirstOriginalTraj.poses.resize(s);
		    
		    for(int i=0;i<s;i++){
			mOriginalTrj_real.poses[i].position.x=v[i]*1000;// singlePos.x*1000;
			mOriginalTrj_real.poses[i].position.y=singlePos.y*1000;//singlePos.y*1000;
			mOriginalTrj_real.poses[i].position.z=0;//singlePos.theta;
			//NOW if the first request save the first irugunal path, this path can be used later
			if(State.firstRequest){
			  mFirstOriginalTraj.poses[i]=mOriginalTrj_real.poses[i];
			}
			//cout<<i<<" : mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.y<<" mIDs Size: "<<message.object_IDs.size()<<endl;
		    }
	      }else{
		    int sizeOfPrevSafePath=mFirstSafeTraj.poses.size();
		    mOriginalTrj_real.poses.clear();
		    mOriginalTrj_real.poses.resize(sizeOfPrevSafePath);
		    for(int i=0;i<sizeOfPrevSafePath;i++){
		      mOriginalTrj_real.poses[i].position.x=mFirstSafeTraj.poses[i].position.x*1000;
		      mOriginalTrj_real.poses[i].position.y=mFirstSafeTraj.poses[i].position.y*1000;
		    }
		    //cout<<mOriginalTrj_real.poses[sizeOfPrevSafePath-1].position.x<<" : "<<mOriginalTrj_real.poses[sizeOfPrevSafePath-1].position.y<<" : +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ "<<endl;
	      }
	      //we claculate and publish the original path for RVIZ
	      if(mShowObstacles)
		publish_original_path();
	      //This is to consider the current tobot position, so the original path start from the current robot position
	      /*mOriginalTrj_real.poses.clear();
	  mOriginalTrj_real.poses.resize(sizeOrigpath);
	  for(int i=0;i<sizeOrigpath;i++){
	      singlePos = message.traj_points[i];
	      mOriginalTrj_real.poses[i].position.x=singlePos.x*1000;
	      mOriginalTrj_real.poses[i].position.y=mRobotLocationMap.y*1000;// singlePos.y*1000;
	      mOriginalTrj_real.poses[i].position.z=singlePos.theta;
	      //if(i==sizeOrigpath-1)
	      //  cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
	  }*/
      }else{
	      //if mShowObstacles=false so we need to save the original path because we need it for path calulation
	      //if(!mTesting){
	      //get the original path
	      geometry_msgs::PoseArray pathTemp;
	      pathTemp.poses.resize(sizeOrigpath);
	      //cout<<" s "<<sizeOrigpath<<endl;
	      for(int i=0;i<sizeOrigpath;i++){
		  singlePos = message.traj_points[i];
		  pathTemp.poses[i].position.x=singlePos.x;
		  pathTemp.poses[i].position.y=singlePos.y;
		  pathTemp.poses[i].position.z=singlePos.theta;
		  //cout<<" s0000 "<<singlePos.x<<endl;
	      }
	      if(!State.weHaveSafePath){
		    std::vector<geometry_msgs::Pose2D> pathTempTemp;
		    
		    pathTempTemp = calculateOriginalPath(pathTemp);

		    sizeOrigpath =  pathTempTemp.size();
		    //cout<<" s1111 "<<sizeOrigpath<<endl;
		    mOriginalTrj_real.poses.clear();
		    mOriginalTrj_real.poses.resize(sizeOrigpath);
		    if(State.firstRequest)
		      mFirstOriginalTraj.poses.resize(sizeOrigpath);
		    for(int i=0;i<sizeOrigpath;i++){
			//singlePos = message.traj_points[i];
			mOriginalTrj_real.poses[i].position.x=pathTempTemp[i].x*1000;
			mOriginalTrj_real.poses[i].position.y=pathTempTemp[i].y*1000;
			mOriginalTrj_real.poses[i].position.z=pathTempTemp[i].theta;
			//NOW if the first request save the first irugunal path, this path can be used later
			if(State.firstRequest){
			  mFirstOriginalTraj.poses[i]=mOriginalTrj_real.poses[i];
			}
			//if(i==sizeOrigpath-1)cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
		    }
	      }else{
		    int sizeOfPrevSafePath=mFirstSafeTraj.poses.size();
		    mOriginalTrj_real.poses.clear();
		    mOriginalTrj_real.poses.resize(sizeOfPrevSafePath);
		    for(int i=0;i<sizeOfPrevSafePath;i++){
			      mOriginalTrj_real.poses[i].position.x=mFirstSafeTraj.poses[i].position.x*1000;
			      mOriginalTrj_real.poses[i].position.y=mFirstSafeTraj.poses[i].position.y*1000;
		    }
	      }
	      //we claculate and publish the original path for RVIZ
	      if(mShowObstacles)
		publish_original_path();
	      //}
      }
      vector<but_object_localization::FusedObject> actual_localized_objects_all;
      
      actual_localized_objects_all =  getAndvisulizeObstacles();
      //if above failed try again
      if(State.noObstaclesFromLocalizationModule){
	actual_localized_objects_all =  getAndvisulizeObstacles();
      }
      
      //check if is the request from the LGV is NEW otherwise return
      IDsSize = message.object_IDs.size();
      //State.firstRequest;State.RequestIsNotValid; State.requestAlreadyReceived=true;State.therIsSolution=false; State.obstaclesAreFareFromRobot=false; State.avoidancePathWasCalculated=false; State.noObstaclesFromLocalizationModule=false;
      if(State.firstRequest){
	    //save mindistance to consider obstacles
	    mGs->mSecurityDis=mMinDistanceToObstacles;
	    mGs->mBackToOriginalPath=mComeBackToOriginalPath;
	    if(IDsSize==0||sizeOrigpath==0)
	    {
		State.RequestIsNotValid=true;//mIsNewPathRequest=false;
	    }else{
		mIDs.resize(IDsSize);
		for(int i=0;i<IDsSize;i++)
		    mIDs[i]=message.object_IDs[i];
	    }
      }else{
	  //Check if those IDS whre aleady in the old path or are new (the seciìond case means the request is new)
	  if(IDsSize==0||sizeOrigpath==0)
	  {
	      State.RequestIsNotValid=true;
	  }
	  else
	  {
	      bool notExist=true;
	      for(int i=0;i<IDsSize;i++){
		bool xb=mGs->found(mIDs, message.object_IDs[i]);//bool found(vector<int> ve, int thisV);
		notExist=notExist*xb;
		//if(mPublishCommt)
		    //cout<<"RECIEVING IDS: "<<xb<<" new "<<message.object_IDs[i]<<" old ids : "<<mIDs[i]<<endl;
	      }
	      if(!notExist){
		State.requestAlreadyReceived=false;
  
	      }else{
		//check if the robot position and orientation are still closer
		float dx=State.robotLocationForThisPath.x-mRobotLocationMap.x;
		float dy=State.robotLocationForThisPath.y-mRobotLocationMap.y;
		float dtheta=abs(State.robotLocationForThisPath.theta-mRobotLocationMap.theta);
		float dist = sqrt(dx*dx+dy*dy);
		float threshold_dis = 0.4;//metre
		float threshold_orin = (10*3.14159/180);//10°
		//if(mPublishCommt)
		    //cout<<"disthreshold: "<<dist<<" : "<<(dtheta*180/3.14159)<<endl;
		if(dist<threshold_dis&&dtheta<threshold_orin){
		  State.requestAlreadyReceived=true;
		}else{
		  State.requestAlreadyReceived=false;
		}
	      }
	  }
      }
      if(mPublishCommt)
	  cout<<"==>> NEW REQUEST RECEIVED at: "<<ros::Time::now()<<" ==========================================[ N° "<<inctest<<" ]===="<<endl;
      //============================================================================================================ IF THE REQUEST IS NOT VALID ======> OUT PUT EMPTY PATH WITH mode=2
      if(State.RequestIsNotValid){
	  if(mPublishCommt){
	      cout<<"REQUEST IS NOT VALIDE THE OBSTACLES IDs AND/OR THE PATH ARE EMPTY ...!!! .=>PLEASE CHECK LGV REQUEST IF IT IS WORKING PROPERLY (size of IDs and Path are as follow:  "<<IDsSize<<" "<<sizeOrigpath<<endl;
	      /*for(int i=0;i<message.object_IDs.size();i++){
		  mIDs[i]=message.object_IDs[i];
		  cout<<"ids are : "<<message.object_IDs[i]<<endl;
	      }*/
	  }
	  //out put an empty path with mode=2
	  Out_put_safe_path("f");
	  return;
      }

      //============================================================================================================ IF NO OBSTACLE OR FAILED TO CONNECT TO OBJECT LOCALIZATION ======> OUT PUT EMPTY PATH WITH mode=2
      if(State.noObstaclesFromLocalizationModule){
	  if(mPublishCommt)
	      cout<<" NO OBJECTS FROM 'but_object_localization' NODE ...!!! =>PLEASE CHECK IF IT IS WORKING PROPERLY"<<endl;
	  //out put an empty path with mode=2
	  ConnectRobotPoseToOriginalPath();
	  Out_put_safe_path("connectToorigPath");
	  sleep(0.05);
	  return;
      }
      //============================================================================================================ IF OBSTACLES ARE FARE FROM THE ROBOT ======> OUT PUT EMPTY PATH WITH mode=2
      //Now we find the obstacles which are in the way of the robot
      vector<mObstacleSize> Obst_real; 
      if(!State.noObstaclesFromLocalizationModule){
	if(mUseSafePathMode){
	  Obst_real = getObstaclesInTheWay_real(/*mOriginalTrj_real*/mFirstOriginalTraj, mIDs, actual_localized_objects_all);
	}else{
	  Obst_real = getObstaclesInTheWay_real_safepathMode(mFirstOriginalTraj, mIDs, actual_localized_objects_all);
	}
	
      }
      //cout<<" Segmentation fault 3"<<endl;

      if(State.obstaclesAreFareFromRobot){
	  if(mPublishCommt)
	      cout<<"OBSTACLES ARE FARE FROM THE ROBOT ...!!!"<<endl;
	  //out put an empty path with mode=2
	  ConnectRobotPoseToOriginalPath();
	  Out_put_safe_path("connectToorigPath");
	  sleep(0.05);
	  return;
      }else{
	/*if(mPublishCommt)
	    cout<<" Nuber of Obstacles: "<<Obst_real.size()<<endl;*/
      }
      //============================================================================================================ IF THE REQUEST IS THE SAME AND THE PATH WAS CALCULATED ======> OUT PUT THE PREVIOUS PATH with mode=1
      if(State.requestAlreadyReceived&&State.avoidancePathWasCalculated){
	  if(mPublishCommt)
	      cout<<"RECEIVING THE SAME OBSTACLES IDS ...!!! === [ REPORTING THE PREVIOUS PATH ] ===>"<<endl;
	  State.requestAlreadyReceived=false;
	  Out_put_safe_path("a");
	  sleep(0.05);
	  return;
      }else{
	  if(mPublishCommt)
	      cout<<"RECIEVING NEW IDs === [ THE PATH AVOIDANCE CALCULATION IS IN PROGRESS ] ===> "<<mOriginalTrj_real.poses.size()<<endl;
      }
      //if mShowObstacles=false so we need to save the original path because we need it for path calulation
      //NOTE THIS PART WAS MODEV UP
      /*if(!mTesting){
	  //get the original path
	  mOriginalTrj_real.poses.clear();
	  mOriginalTrj_real.poses.resize(sizeOrigpath);
	  for(int i=0;i<sizeOrigpath;i++){
	      singlePos = message.traj_points[i];
	      mOriginalTrj_real.poses[i].position.x=singlePos.x*1000;
	      mOriginalTrj_real.poses[i].position.y=singlePos.y*1000;
	      mOriginalTrj_real.poses[i].position.z=singlePos.theta;
	      //if(i==sizeOrigpath-1)cout<<" mOriginalTrj_real.poses[i].position.x: "<<mOriginalTrj_real.poses[i].position.x<<" mIDs Size: "<<message.object_IDs.size()<<endl;
	  }
	  //we claculate and publish the original path for RVIZ
	  if(mShowObstacles)
	    publish_original_path();
      }*/
      mIDs.resize(IDsSize);
      for(int i=0;i<IDsSize;i++)
	  mIDs[i]=message.object_IDs[i];
      
      geometry_msgs::PoseArray outpath_real;
      geometry_msgs::PoseArray outpath_safe_real;
      if(!State.noObstaclesFromLocalizationModule){
	  outpath_real = mGs->GetAvoidancePath(mOriginalTrj_real, mRobotLocationMap, Obst_real);
      }
      int sizeNewpath = 0;
      if(mGs->mThereIsAvoidPath)
	sizeNewpath = outpath_real.poses.size();
      if(sizeNewpath!=0&&mGs->mThereIsAvoidPath){
	  State.avoidancePathWasCalculated=true;
	  State.robotLocationForThisPath = mRobotLocationMap;
	  
	  /*messagePUB.traj_points.clear();
	  messagePUB.traj_points.resize(sizeNewpath);
	  for(int i=0;i<sizeNewpath;i++){
	      singlePos.x = outpath_real.poses[i].position.x/1000;singlePos.y = outpath_real.poses[i].position.y/1000;
	      singlePos.theta = 0.1;//TODO check in abstacle avoidness the orientation of the robot
	      messagePUB.traj_points[i] = singlePos;//messagePUB.traj_points.push_back(singlePos);
	  }*/
      }else{
	State.avoidancePathWasCalculated=false;
      }
      if(State.avoidancePathWasCalculated){
	  
	  State.requestAlreadyReceived=false;
	  State.firstRequest=false;
	  /*
	  bool succeed=true;

	  //check if the path is outside mMinMaxOfCorredor
	  float dist=mGs->AngleDistanceTwoPointsk(mGs->mPointExtreme.mX, mGs->mPointExtreme.mY);
	  //map the path over the same dist and get the last point
	  bool lastPointAchieved=false;
	  int inc_path=1;
	  Point2dDouble p(mOriginalTrj_real.poses[0].position.x, mOriginalTrj_real.poses[0].position.y);
	  Point2dDouble this_Point(mOriginalTrj_real.poses[0].position.x, mOriginalTrj_real.poses[0].position.y);
	  //find a point in the original path which is in the same distance from the extrame point
	  while(!lastPointAchieved){
	    Point2dDouble pnext=Point2dDouble(mOriginalTrj_real.poses[inc_path].position.x, mOriginalTrj_real.poses[inc_path].position.y);
	    float dist_from_origine=mGs->DistanceTwoPointsk(p, pnext);
	    if(dist_from_origine>dist||inc_path>=mOriginalTrj_real.poses.size()){
	      this_Point = pnext;
	      lastPointAchieved=true;
	    }
	    inc_path++;//cout<<" inc: "<<inc_path<<" : "<<this_Point.mY<<endl;
	  }
	  //calculate the point perpendicular to the original path_to_ShowPath
	  //cout<<" 0: "<<this_Point.mX<<" : "<<this_Point.mY<<endl;
	  //cout<<" 0: "<<p.mX<<" : "<<p.mY<<endl;
	  this_Point =  mGs->DistanceToLinek(p, mGs->mPointExtreme, this_Point);
	  float distanceSave=mGs->DistanceTwoPointsk(mGs->mPointExtreme, this_Point)/1000;
	  //cout<<" 0: "<<this_Point.mX<<" : "<<this_Point.mY<<endl;
	  if(distanceSave> mMinMaxOfCorredor-mLGV_size/2){//mLGV_size
	    if(mPublishCommt)
	        //cout<<distanceSave<<" : "<<endl;
		cout<<"THE PATH IS OUTSIDE THE Corredor: "<<distanceSave<<" ...! === [ PLEASE TRY AGAIN ] ===> "<<endl;
		succeed=false;
	  }
	  */
	  bool succeed = pathCkech();
	  Point2dDouble pExtreme;
	  if(mPublishCommt||succeed){
	      if(succeed)
		 cout<<"PATH CALCULATION SUCCEEDED, CHECKING PROCESS NOW...! === [???] ===> "<<sizeNewpath<<" : "<<succeed<<endl;
	      else
		 cout<<"PATH CALCULATION FAILED, THE PATH IS OUTSIDE THE CORREDOR:"<<endl;
	      
	      geometry_msgs::Pose2D prev;
	      if(succeed){
		mFirstSafeTraj.poses.clear();
		mFirstSafeTraj.poses.resize(sizeNewpath);
	      }
	      
	      for(int i=0;i<sizeNewpath;i++){
		  singlePos.x = outpath_real.poses[i].position.x/1000;singlePos.y = outpath_real.poses[i].position.y/1000;singlePos.theta = 0.0;
		  if(i>1){
		      float dx=singlePos.x-prev.x;float dy=singlePos.y-prev.y;float dir = atan2(dy, dx);singlePos.theta = dir;
		  }
		  //if(mPublishCommt&&i>sizeNewpath-3)
		  //  cout<<singlePos.x<<" "<<singlePos.y<<" "<<singlePos.theta<<endl;
		  prev=singlePos;
		  if(succeed){
		    mFirstSafeTraj.poses[i].position.x=singlePos.x;
		    mFirstSafeTraj.poses[i].position.y=singlePos.y;
		    mFirstSafeTraj.poses[i].position.z=singlePos.theta;
		  }
	      }
	      //save the output path
	      
	  /*messagePUB.traj_points.clear();
	  messagePUB.traj_points.resize(sizeNewpath);
	  for(int i=0;i<sizeNewpath;i++){
	      singlePos.x = outpath_real.poses[i].position.x/1000;singlePos.y = outpath_real.poses[i].position.y/1000;
	      singlePos.theta = 0.1;//TODO check in abstacle avoidness the orientation of the robot
	      messagePUB.traj_points[i] = singlePos;//messagePUB.traj_points.push_back(singlePos);
	  }*/
	  //now we calculate the safe portion of the path
	  pExtreme=safePortionOfThePath(outpath_real, Obst_real);
		  
	  }
	  //if Show Obstacles
	  if(mShowObstacles){
	      mGs->mThereIsAvoidPath=false;
	      mAvoidPoseToShow_pose.header.frame_id = mFrame;
	      
	      //pExtreme = mGs->mPointExtreme;//testing
	      //pExtreme = mGs->mPointFare;//testing
	      //pExtreme = this_Point;//testing
	      //pExtreme = mGs->mClosestObsPointToRobot;
	      //cout<<" mGs->mPointExtreme mGs->mPointExtreme mGs->mPointExtreme ...! === [ mGs->mPointFare ] ===>"<<mGs->mPointExtreme.mX<<" : "<<mGs->mPointExtreme.mY<<endl;
	      
	      mAvoidPoseToShow_pose.pose.position.x = pExtreme.mX/1000;
	      mAvoidPoseToShow_pose.pose.position.y = pExtreme.mY/1000;
	      mAvoidPoseToShow_pose.pose.orientation.w = 1;
	      ShowExtPoint_pub.publish(mAvoidPoseToShow_pose);
	  }
	  
	  if(succeed&&!mOverSize){
	    cout<<"PATH CALCULATION SUCCEEDED, PLEASE SEE IT ABOVE...! === [ REPORTING THE A NEW PATH ] ===> "<<" : "<<succeed<<endl;
	    Out_put_safe_path("a");
	    State.weHaveSafePath=true;
	  }else{
	    if(mOverSize)
	      cout<<"PATH CALCULATION FAILED, THE PATH LENGTH IS BIG: PLEASE CHECK Those Parameter ===> "<<endl;	    
	    Out_put_safe_path("f");
	  }
	  sleep(0.05);
	  return;
      }else{
	  if(mPublishCommt)
	      cout<<"OBSTACLES ARE FARE OR ARE NOT IN THE WAY OF THE ROBOT ...! === [ PLEASE TRY AGAIN ] ===>"<<endl;
	  ConnectRobotPoseToOriginalPath();
	  Out_put_safe_path("connectToorigPath");//out put the originalpath
	  sleep(0.05);
	  return;
      }
      return;
}

/*geometry_msgs::PoseArray*/
Point2dDouble but_path_node::safePortionOfThePath(geometry_msgs::PoseArray thisPath, vector<mObstacleSize> curr_obst_real)
{
//cout<<" starting safePortionOfThePath "<<endl;
      //cout<<thisPath.poses.size()<<" p "<<dx<<" "<<dy<<endl;
      //cout<<mRobotLocationMap.x<<" r "<<mRobotLocationMap.y<<" r"<<endl;
      //cout<<thisPath.poses[3].position.x<<" in "<<thisPath.poses[3].position.y<<endl;
      
 
  messagePUB.traj_points.clear();messagePUB.object_IDs.clear();
//cout<<" starting safePortionOfThePath 0"<<endl;
      geometry_msgs::PoseArray  outPath;
      //here the code
      float dx=mGs->mClosestObsPointToRobot.mX-mRobotLocationMap.x;
      float dy=mGs->mClosestObsPointToRobot.mY-mRobotLocationMap.y;
//cout<<" starting safePortionOfThePath 1"<<endl;

      float dir = atan2(dy, dx);
//cout<<" starting safePortionOfThePath 2"<<endl;
      dx= cos(dir)*10+mRobotLocationMap.x;
      dy= sin(dir)*10+mRobotLocationMap.y;
      Point2dDouble fromThisP(mRobotLocationMap.x+0.8*cos(mRobotLocationMap.theta), mRobotLocationMap.y+0.8*sin(mRobotLocationMap.theta));
      bool isntersect=false;
      bool out=false;
      int i=0;
      //cout<<thisPath.poses.size()<<" p "<<dx<<" "<<dy<<endl;
      //cout<<mRobotLocationMap.x<<" r "<<mRobotLocationMap.y<<" r"<<endl;
      //cout<<thisPath.poses[3].position.x<<" in "<<thisPath.poses[3].position.y<<endl;
      bool allPathMapped=false;
      while(!isntersect&&i<thisPath.poses.size()-3)
      {
	 isntersect = intersection(Point2dDouble (thisPath.poses[i].position.x/1000, thisPath.poses[i].position.y/1000), 
				    Point2dDouble (thisPath.poses[i+3].position.x/1000, thisPath.poses[i+3].position.y/1000), 
				    fromThisP, 
				    Point2dDouble (dx, dy));
	 i+=3;
	 if(i>=thisPath.poses.size()-4) allPathMapped=true;
      }
      i+=-3;
      
//cout<<" starting safePortionOfThePath 3: "<<i<<endl;
      //cout<<" in "<<i<<endl;
      //now we calculate the id of this point
      outPath.poses.resize(i);
      messagePUB.traj_points.clear();
      messagePUB.traj_points.resize(i);
      messagePUB.header.frame_id=mFrame;
      geometry_msgs::Pose2D singlePost;
      dir=0;
      double pathLength=0;
      int obsSize=0;
      if(!State.noObstaclesFromLocalizationModule)
      obsSize = curr_obst_real.size();
      bool safe=true;
      int incSafe=0;
      for(int j=0;j<i;j++){
	    if(j>0){
		float dy = thisPath.poses[j].position.y-thisPath.poses[j-1].position.y;
		float dx = thisPath.poses[j].position.x-thisPath.poses[j-1].position.x;
		dir=atan2(dy,dx);
		pathLength+=sqrt(dx*dx+dy*dy)/1000;
	    }
	    singlePost.x = thisPath.poses[j].position.x/1000;
	    singlePost.y = thisPath.poses[j].position.y/1000;
	    singlePost.theta = dir;//thisPath.poses[j].position.z;
	    //Now we check if the payj is safe=> fare from the obstacles and stop if the path go close to any obstacles 
	    if(safe&&!State.noObstaclesFromLocalizationModule)
	    for(int o=0;o<obsSize;o++){
		float dy = curr_obst_real[o].f.mY-singlePost.y;float dx = curr_obst_real[o].f.mX-singlePost.x;
		float d=sqrt(dy*dy+dx*dx);
		if(d<1)
		  safe=false;
		dy = curr_obst_real[o].l.mY-singlePost.y; dx = curr_obst_real[o].l.mX-singlePost.x;
		d=sqrt(dy*dy+dx*dx);
		if(d<1)
		  safe=false;
	    }
	    if(safe){
	      messagePUB.traj_points[incSafe]=singlePost;//.push_back(singlePos);
	      incSafe++;
	    }
      }

      /*return outPath;*/
      //return Point2dDouble (singlePost.x*1000, singlePost.y*1000);
      //cout<<" pathLength: "<<pathLength<<endl;
      if(pathLength>mAvoidancePathLength&&!allPathMapped)
	mOverSize=true;
      else
	for(int j=0;j<incSafe;j++)
	  cout<<messagePUB.traj_points[j].x<<" "<<messagePUB.traj_points[j].y<<" "<<messagePUB.traj_points[j].theta<<endl;
	  
      return Point2dDouble (fromThisP.mX*1000, fromThisP.mY*1000);
      
}

void but_path_node::ConnectRobotPoseToOriginalPath()
{     //cout<<" starting ConnectRobotPoseToOriginalPath "<<endl;

      //first we find the nearest point to the original path
      int s=mFirstOriginalTraj.poses.size();
      //cout<<" starting ConnectRobotPoseToOriginalPath+++++++++++++++++++++++++++++++++++++++ "<<s<<endl;
      vector<double> dists;
      dists.resize(s);
      double dis=0;
      for(int j=0;j<s;j++){
	  dists[j] = mGs->DistanceTwoPointsk(mRobotLocationMap.x-mFirstOriginalTraj.poses[j].position.x/1000, 
					      mRobotLocationMap.y-mFirstOriginalTraj.poses[j].position.y/1000);
	  //cout<<" mFirstOriginalTraj.poses[j].position.x "<<mFirstOriginalTraj.poses[j].position.x<<endl;
	  //cout<<" dists[j] "<<dists[j]<<endl;
      }
      double thisV= mGs->MinArrayk(dists);
      int thisID= mGs->ThisElementArray(dists, thisV);
      //now we continue add the rest of the path
      geometry_msgs::Pose2D singlePost;
      //cout<<" starting ConnectRobotPoseToOriginalPath thisID "<<thisID<<endl;
      messagePUB.traj_points.clear();
      
      
      //int inc=1;
      bool fromThisId=false;
      dists.clear();
      short beforEndPath=3;
      if(thisV>2)thisV=2;//2m
      VectorPointD pathTobeSmouthed;
      
      for(int j=thisID;j<s;j++){
	    if(!fromThisId&&j<s)
	    {   
		//walk toward the end of the path by the valye of thisV, at lwast 2m
		if(j>s-beforEndPath||mGs->DistanceTwoPointsk(mFirstOriginalTraj.poses[j].position.x-mFirstOriginalTraj.poses[thisID].position.x, 
				      mFirstOriginalTraj.poses[j].position.y-mFirstOriginalTraj.poses[thisID].position.y)/1000>=thisV){
		  fromThisId=true;
		}
		if(fromThisId){
		    //create a set of points to the original path
		    double d=mGs->DistanceTwoPointsk(mRobotLocationMap.x*1000-mFirstOriginalTraj.poses[j].position.x, 
						      mRobotLocationMap.y*1000-mFirstOriginalTraj.poses[j].position.y);

		    //float dx=mFirstOriginalTraj.poses[j].position.x-mRobotLocationMap.x*1000;
		    //float dy=mFirstOriginalTraj.poses[j].position.y-mRobotLocationMap.y*1000;
		    //float dir=atan2(dy, dx);
//cout<<" starting ConnectRobotPoseToOriginalPath d "<<d<<endl;
		    //go forward from teh robot position to ansure a smout path
		    float xp=mRobotLocationMap.x*1000;
		    float yp=mRobotLocationMap.y*1000;
		    if(d>500)
		    for(int i=0;i<5;i++){
			  xp =i*100*cos(mRobotLocationMap.theta)+mRobotLocationMap.x*1000;
			  yp =i*100*sin(mRobotLocationMap.theta)+mRobotLocationMap.y*1000;
			  pathTobeSmouthed.push_back(Point2dDouble(xp, yp));
		    }

		    //find the direction
		    float dx=mFirstOriginalTraj.poses[j].position.x-xp;
		    float dy=mFirstOriginalTraj.poses[j].position.y-yp;
		    //fine the distance between the last point of the traj and the connection point of the traj
		    d=mGs->DistanceTwoPointsk(dx, dy);		    
		    float dir=atan2(dy, dx);
		    if(d>500)
		    for(int i=0;i<(int)(d/100);i++){
			  float xpp =i*10*cos(dir)+xp;
			  float ypp =i*10*sin(dir)+yp;
			  pathTobeSmouthed.push_back(Point2dDouble(xpp, ypp));
		    }
//cout<<" starting ConnectRobotPoseToOriginalPath inc inc "<<inc<<endl;
		    //inc=pathTobeSmouthed.size();
		    //pathTobeSmouthed.resize(s-j+inc);
		    //pathTobeSmouthed[0]=Point2dDouble(mRobotLocationMap.x, mRobotLocationMap.y);
		}
	    }else{
	      pathTobeSmouthed.push_back(Point2dDouble(mFirstOriginalTraj.poses[j].position.x,mFirstOriginalTraj.poses[j].position.y));
	      //pathTobeSmouthed[inc]=(Point2dDouble(mFirstOriginalTraj.poses[j].position.x,mFirstOriginalTraj.poses[j].position.y));
	      //inc++;
	    }
      }
      //cout<<" starting ConnectRobotPoseToOriginalPath inc "<<inc<<endl;

      VectorPointD SmouthedPath0 = mGs->GenerateSmouthPathSecond(pathTobeSmouthed);
      VectorPointD SmouthedPath1;
      mGs->DecimateLinek(SmouthedPath0, SmouthedPath1, 300, 200);
      int n=SmouthedPath1.size();
      //cout<<" starting ConnectRobotPoseToOriginalPath n "<<n<<endl;
      messagePUB.traj_points.resize(n);
      messagePUB.header.frame_id=mFrame;
      //messagePUB.traj_points[0]=mRobotLocationMap;
      float dir=0;
      //bool sec=true;
      for(int j=0;j<n;j++){
	      if(j>0)
		float dir=atan2(SmouthedPath1[j].mY-SmouthedPath1[j-1].mY, SmouthedPath1[j].mX-SmouthedPath1[j-1].mX);
	      singlePost.x = SmouthedPath1[j].mX/1000;
	      singlePost.y = SmouthedPath1[j].mY/1000-0.1;
	      singlePost.theta = dir;//TODO CALCULATE DIRECTION mFirstOriginalTraj.poses[j].position.z;
	      messagePUB.traj_points[j]=singlePost;
	      
      }
      //cout<<" starting ConnectRobotPoseToOriginalPath inc "<<inc<<endl;

      /*return outPath;*/
      //return Point2dDouble (singlePost.x*1000, singlePost.y*1000);
      //return Point2dDouble (mFirstOriginalTraj.poses[thisID].position.x, mFirstOriginalTraj.poses[thisID].position.y);
      
      //return sec;
}

bool but_path_node::intersection(Point2dDouble p1, Point2dDouble p2, Point2dDouble p3, Point2dDouble p4)
{

  // Return the point of intersection
  Point2dDouble outPutPoint(0,0);
  float epsilon=0.001;
  // Store the values for fast access and easy
  // equations-to-code conversion
  float x1 = p1.mX, x2 = p2.mX, x3 = p3.mX, x4 = p4.mX;
  float y1 = p1.mY, y2 = p2.mY, y3 = p3.mY, y4 = p4.mY;

  float d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
  // If d is zero, there is no intersection
  if (d == 0) return false;//NULL;


  // Get the x and y
  float pre = (x1*y2 - y1*x2), post = (x3*y4 - y3*x4);
  float x = ( pre * (x3 - x4) - (x1 - x2) * post ) / d;
  float y = ( pre * (y3 - y4) - (y1 - y2) * post ) / d;

  //+++++++++++++++++++++++++AN OTHER METHOD+++++++++++++++++++++++++
  if (x < (min(x1, x2) - epsilon) ||
      x > (max(x1, x2) + epsilon) ||
      x < (min(x3, x4) - epsilon) ||
      x > (max(x3, x4) + epsilon))
        return false;
  if (y < (min(y1, y2) - epsilon) ||
      y > (max(y1, y2) + epsilon) ||
      y < (min(y3, y4) - epsilon) ||
      y > (max(y3, y4) + epsilon))
        return false;

  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  return true;//outPutPoint
}
bool but_path_node::pathCkech()
{
      bool succeed=true;

      //check if the path is outside mMinMaxOfCorredor
      float dist=mGs->AngleDistanceTwoPointsk(mGs->mPointExtreme.mX, mGs->mPointExtreme.mY);
      //map the path over the same dist and get the last point
      bool lastPointAchieved=false;
      int inc_path=1;
      Point2dDouble p(mFirstOriginalTraj.poses[0].position.x, mFirstOriginalTraj.poses[0].position.y);//Point2dDouble p(mOriginalTrj_real.poses[0].position.x, mOriginalTrj_real.poses[0].position.y);
      Point2dDouble this_Point(mFirstOriginalTraj.poses[0].position.x, mFirstOriginalTraj.poses[0].position.y);//Point2dDouble this_Point(mOriginalTrj_real.poses[0].position.x, mOriginalTrj_real.poses[0].position.y);
      //find a point in the original path which is in the same distance from the extrame point
      while(!lastPointAchieved){
	Point2dDouble pnext=Point2dDouble(mFirstOriginalTraj.poses[inc_path].position.x, mFirstOriginalTraj.poses[inc_path].position.y);//oint2dDouble pnext=Point2dDouble(mOriginalTrj_real.poses[inc_path].position.x, mOriginalTrj_real.poses[inc_path].position.y);
	float dist_from_origine=mGs->DistanceTwoPointsk(p, pnext);
	if(dist_from_origine>dist||inc_path>=mFirstOriginalTraj.poses.size()){//if(dist_from_origine>dist||inc_path>=mFirstOriginalTraj.poses.size()){
	  this_Point = pnext;
	  lastPointAchieved=true;
	}
	inc_path++;//cout<<" inc: "<<inc_path<<" : "<<this_Point.mY<<endl;
      }
      //calculate the point perpendicular to the original path_to_ShowPath
      //cout<<" 0: "<<this_Point.mX<<" : "<<this_Point.mY<<endl;
      //cout<<" 0: "<<p.mX<<" : "<<p.mY<<endl;
      this_Point =  mGs->DistanceToLinek(p, mGs->mPointExtreme, this_Point);
      float distanceSave=mGs->DistanceTwoPointsk(mGs->mPointExtreme, this_Point)/1000;
      //cout<<" 0: "<<this_Point.mX<<" : "<<this_Point.mY<<endl;
      if(distanceSave> mMinMaxOfCorredor-mLGV_size/2){//mLGV_size
	if(mPublishCommt)
	    //cout<<distanceSave<<" : "<<endl;
	    cout<<"THE PATH IS OUTSIDE THE Corredor: "<<distanceSave<<" ...! === [ PLEASE TRY AGAIN ] ===> "<<endl;
	    succeed=false;
      }
      return succeed;
}

void but_path_node::get_robot_location_callback(data_bridge::DTB_Odometry msgOdm)
{
    /*if(!mGetingRobotLocation){
      mGetingRobotLocation=true;
      mRobotLocationMap=msgOdm.abs_position;
      if(mRobotLocationMap.x>=13.7578852193 &&mRobotLocationMap.y>=5.901) {TEST_COM_WITH_OBJECT_LOCALZ=true;
	cout<<mRobotLocationMap.x<<" :-------#####################[[[[[[[[[[ robot is in ]]]]]]]]]]]]]####################--------: "<<mRobotLocationMap.y<<endl;
      }
      mThereIsRobotLocation=true;
      sleep(0.1);//ros::Duration(200).sleep();
      mGetingRobotLocation=false;
    }*/
    //cout<<"-------**********-------[[ get_robot_location_callback ]]-------**********-------: "<<msgOdm.abs_position.x <<" "<<msgOdm.abs_position.y<<endl;
}

int main( int argc, char** argv)
{
	//this only so we can get rostime
	ros::init(argc, argv, "but_path_node");
	//ros::NodeHandle n;


	but_path_node *node = new but_path_node();
	//bool ShowObstacles=false;
	//bool PublishComments=false;

	node->n.getParam("TestingONLY", node->mTesting);
	node->n.getParam("ShowObstaclesAndPaths", node->mShowObstacles);
	node->n.getParam("ShowNodeStatue", node->mPublishCommt);
	node->n.getParam("MinDistanceToObstacles", node->mMinDistanceToObstacles);
        node->mMinDistanceToObstacles=node->mMinDistanceToObstacles*1000;
	
	node->n.getParam("ComeBackToOriginalPath", node->mComeBackToOriginalPath);
	
	node->n.getParam("MinMaxCorredor", node->mMinMaxOfCorredor);
	node->n.getParam("LGV_size", node->mLGV_size);
	
	node->n.getParam("PutObst", node->mPutObst);
	
	
	node->n.getParam("UseIncrementalRobotPosition", node->mUseIncrementalRobPos);
	
	node->n.getParam("FrameForOutPut", node->mFrame);
	
	node->n.getParam("AvoidancePathLength", node->mAvoidancePathLength);
	//node->ShowExtPoint_pub = n.advertise<geometry_msgs::PoseStamped>("FreePoint", 1000);//ShowPath_pub = n.advertise<geometry_msgs::PoseStamped>("path_to_ShowPath", 1000);
	
	//if ObjectLocalization is running TODO remove it later
        cout<<"but_path_node is running . . .  "<<node->mShowObstacles<<" : "<<node->mPublishCommt<<endl;
	//if(node->mPublishCommt)
	//cout<<"STARTING PATH PLANNER NODE . . .  "<<endl;
	/* register to Omd topic to get LGV location */
	//get_robot_location = n.subscribe<data_bridge::DTB_Odometry>(EXPAND(ODOMETRY_TOPIC_NAME),1000,get_robot_location_callback); 

	/* registration as a topic publisher for data bridge  - 1000 messages stack */
	/* every time the message will come trought the topic you are registerred at the callback funtion will be called */
	//convertor_subscriber_trajectory = n.subscribe<data_bridge::DTB_Trajectory>(/*EXPAND(TRAJECTORY_IN_TOPIC_NAME)*/"data_bridge_trajectory_in",1000,convertor_trajectory_callback);
	//node->convertor_subscriber_trajectory = n.subscribe<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_IN_TOPIC_NAME),1000, node->convertor_trajectory_callback);
	//cout<<"RAJECTORY_IN_TOPIC . . . 1.0 "<<endl;
	/* then register publisher - only once */
	//node->convertor_publisher_trajectory = n.advertise<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_OUT_TOPIC_NAME),1000); 
	
	//node->obstacles_pub = n.advertise<visualization_msgs::MarkerArray>( "obstacle_marker", 0 );

	/**
	* GetNewPath inst.
	*/

	//cout<<"NOT CALLED calling Object_localization_node . . . 0 "<<endl;
        ros::Rate loop_rate(10);
	while (ros::ok())
	{
	    ros::spinOnce();//ros::spin();//
	    //loop_rate.sleep();//TODO incomment this line

	}
	
	delete node;
	return 0;
	//delete mGs;
}


