/**
 * ***************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by dcgm-robotics@FIT group.
 *
 * Author: Khelifa Baizid (baizid.khelifa@gmail.com)
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 19/11/2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PRIMITIVES_H
#define PRIMITIVES_H

#include <vector>
#include <math.h>

#ifndef M_PI
#define	M_PI	3.14159265359
#endif

#define DISTANCE_LASER_MAX 10000

struct Point2dDouble
{
	double mX;
	double mY;
	
	Point2dDouble(){};
	
	Point2dDouble(double x, double y)
	{
		mX = x;
		mY = y;
	}
	
	bool operator==(const Point2dDouble &rhs) const
	{ return !(mX != rhs.mX || mY != rhs.mY); }

    /// overloaded operator
	bool operator!=(const Point2dDouble &rhs) const
	{ return mX != rhs.mX || mY != rhs.mY; }

    /// overloaded operator
	Point2dDouble operator+(const Point2dDouble &rhs) const
	{ return Point2dDouble(mX + rhs.mX, mY + rhs.mY); }

    /// overloaded operator
	Point2dDouble operator-(const Point2dDouble &rhs) const
	{ return Point2dDouble(mX - rhs.mX, mY - rhs.mY); }

};

typedef std::vector<Point2dDouble> VectorPointD;

struct Point2d
{
	int mX;
	int mY;
	
	Point2d(){};
	
	Point2d(int x, int y)
	{
		mX = x;
		mY = y;
	}
	
	bool operator==(const Point2d &rhs) const
	{ return !(mX != rhs.mX || mY != rhs.mY); }

    /// overloaded operator
	bool operator!=(const Point2d &rhs) const
	{ return mX != rhs.mX || mY != rhs.mY; }

    /// overloaded operator
	Point2d operator+(const Point2d &rhs) const
	{ return Point2d(mX + rhs.mX, mY + rhs.mY); }

    /// overloaded operator
	Point2d operator-(const Point2d &rhs) const
	{ return Point2d(mX - rhs.mX, mY - rhs.mY); }

};

typedef std::vector<Point2d> VectorPoint;

#endif // PRIMITIVES_H