function [results] = repeatabilityFP2D( folderPath1, folderPath2, detectors, eps, formats, oldResults )
%repeatabilityFP2D 
	
	%% process input arguments
	slashPos = strfind(folderPath1, filesep);
	slashPos = slashPos(end);
	folderName1 =  folderPath1(slashPos+1 : end);
	
	slashPos = strfind(folderPath2, filesep);
	slashPos = slashPos(end);
	folderName2 =  folderPath2(slashPos+1 : end);
	
	%% load homography from file (previously computed based on manual marks)
	parentFolderPath = folderPath1(1:end-size(folderName1,1)-2);
	if(folderName1 == folderName2)
		H12 = eye(3); % identity matrix for homography of image with itself
	else
		H12 = load([parentFolderPath filesep 'H.' folderName1 '.' folderName2 '.txt'], '-ascii');
	end

	%% Compute repeatability rate for each detector and image format
	
	results = cell(1 + size(formats, 1), 1 + 2*size(detectors, 1));
	
	if exist('oldResults') == 1
		% old results do exist, copy them into new results
		results(1:size(oldResults,1), 1:size(oldResults,2)) = oldResults;
	end
	
	% write header row and column
	results(1,1) = {eps};
	for d = 1:size(detectors, 1)
		results(1, 1+d) = {[detectors{d} '-ref']};
		results(1, 2+d) = detectors(d);
	end
	results(2:end,1) = formats;
	
	for d = 1:size(detectors, 2)
		detector = char(detectors(d));
		
		% Process FP for each image format
		for f = 1:size(formats, 1)
			format = char(formats(f));
			% evaluate only missing combinations of FP detectors and image formats
			fps1Path = [folderPath1 filesep folderName1 '.' detector '.' format '.txt'];
			fps2Path = [folderPath2 filesep folderName2 '.' detector '.' format '.txt'];
			if (...
				(isempty(results{f+1, 2*(d-1)+2}) || isempty(results{f+1, 2*(d-1)+2}))...
					&&...
				((exist(fps1Path) == 2) && exist(fps2Path) == 2)...
			)
				
				fps1 = load(fps1Path, '-ascii');
				fps2 = load(fps2Path, '-ascii');
				results(f+1, 2*(d-1)+2) = {size(fps1,1)};
				results(f+1, 2*(d-1)+3) = {matchFP2D(fps1, fps2, H12, eps)};
			end
		end
		
	end
	
	return
end

function [positivesNr] = matchFP2D(fps1, fps2, H, eps)
%MATCHFP2D 

	pos = 0;
	neg = 0;
	
	% go through all FP from first image
	for i = 1:size(fps1,1)
		
		% position of FP in img1
		fp1 = fps1(i, 1:2);
		% expected position of FP in img2
		fpExpect = H * [fp1 1]'; fpExpect = fpExpect / fpExpect(3);

		% Compute distance of expected position to every actual FP position in fp2
		distances = sqrt((fpExpect(1)-fps2(:,1)).^2 + (fpExpect(2)-fps2(:,2)).^2);
		% Where is the distance < eps?
		isNeighbor = distances < eps;

		if (sum(isNeighbor) > 0)
			pos = pos + 1;
		else
			neg = neg + 1;
		end
		
	end
	positivesNr = pos;
end
