function ROI = markImgROI( folderPath, imgName, imgExt )
%MARKIMGROI Saves ROI to image specified in parameter.
%   Opens image, shows it to the user, lets him mark the ROI and saves the
%   ROI to the same folder as imgName.ROI.txt
	
	img = imread([folderPath imgName imgExt]);
	h = figure();
	[~, xi, yi] = roipoly(img);
	close(h); % close current figure window
	
	poly = [xi yi];
	poly = poly(1:end-1, :);
	
	save([folderPath imgName '.ROI.txt'], 'poly', '-ascii', '-double', '-tabs');
	ROI = poly;
	
	return;
end

