function imgSetFromHDR(iHDRpath, iLDRpath, iGTMpath, iLTMpath)
% Creates LDR (8 f-stops) and tone-mapped HDR jpegs from HDR image.
	% open HDR image
	iHDR = hdrread(iHDRpath);
	
	% create single-exposure LDR image
	[iLDR, minLum, maxLum] = clipDR(iHDR, 8.0, 100);
	iLDRuint8 = uint8(round(   255 * (log2(iLDR)-log2(minLum)) / (log2(maxLum)-log2(minLum))   ));
	clear('iLDR');
	imwrite(iLDRuint8, iLDRpath, 'Quality', 90);
	clear('iLDRuint8');
	
	% create globally tone-mapped image
	iGTM = globalToneMap(iHDR);
	imwrite(iGTM, iGTMpath, 'Quality', 90);
	clear('iGTM');
	
	% create locally tone-mapped image
	iLTM = tonemap(iHDR);
	clear('iHDR');
	imwrite(iLTM, iLTMpath, 'Quality', 90);
	clear('iLTM');
end

