function iOut = globalToneMap( iIn )
%GLOBALTONEMAP converts HDR into uint8 image by log2 transform and linear
%stretch to 0..255
	im = log2(iIn);
	
	mini = min(im(:));
	maxi = max(im(:));
	
	% rescale to 0..1
	im = (im - mini) ./ (maxi - mini);
	
	% rescale to 0..255
	im = 255 * im;
	
	% cast
	iOut = uint8(im);
end

