
function [ locF ] = filterLoc( loc, poly )
%FILTERLOC Returns only those x-y locations which are inside the polygon.

	% get index vector of FP locations which are inside the polygon
	locsX = double(loc(:,1));
	locsY = double(loc(:,2));
	polyX = poly(:,1);
	polyY = poly(:,2);
	IN = inpolygon(locsX, locsY, polyX, polyY);
	
	locF = zeros(sum(IN), size(loc,2));
	f = 1;
	for i = 1:size(loc,1)
		if (IN(i))
			locF(f,:) = loc(i,:);
			f = f+1;
		end;
	end;
end
