function [imgOut, min, max] = cutMinMaxNoise(imgIn, minRatio, maxRatio)
% Clips values of pixels with minimal and maximal values in gray-scale image (effectively decreasing dynamic range of the image)
	%% input arg checks
	[r, c, chnl] = size(imgIn);
	if(chnl ~= 1)
		error('The input image is not a one channel image!');
	end
	
	if(minRatio < 0)
		error('minRatio must be non-negative!');
	end
	
	if(maxRatio < 0)
		error('maxRatio must be non-negative!');
	end
	
	%% number of pixels to ommit (consider as noisy)
	minCount = uint32(minRatio * r * c);
	if(minCount == 0)
		minCount = 1;
	end
	
	maxCount = uint32(maxRatio * r * c);
	
	%% new min and max
	sPixels = sort(imgIn(:)); % order pixel values in whole image
	
	min = inf;
	max = 0;
	
	if(sPixels(minCount) < min)
		min = sPixels(minCount);
	end
	
	if(sPixels(end-maxCount) > max)
		max = sPixels(end-maxCount);
	end
	
	if (min == 0)
		 min = eps;  % eps is Matlab constant (smallest number representable with type 'single')
	end
	
	%% clip the noisy pixels
	imgOut = imgIn;
	imgOut(imgOut < min) = min;
	imgOut(imgOut > max) = max;
end

