function [ ca ] = csv2cellArray( csvText )
%CSV2CELLARRAY Converts a CSV string into a 2D cell array.

	% find new line characters
	nlPos = strfind(csvText, char(10)); % char(10) == LF character
	
	% get first line
	headLine = csvText(1:nlPos(1));
	% determine number of fields in the line
	commaPos = strfind(headLine, ',');
	
	% allocate the cell array
	ca = cell(size(nlPos,2)-1, size(commaPos,2)+1);
	
	% fill the head line
	commaPos = [commaPos size(headLine,2)+1];
	ca{1,1} = headLine(1:commaPos(1)-1);
	for c = 2:size(commaPos,2)
		ca{1,c} = headLine(commaPos(c-1)+1 : commaPos(c)-1);
	end
	
	% fill it with values
	for l = 2:size(nlPos,2)-1
		line = csvText(nlPos(l-1)+1 : nlPos(l)-1);
		commaPos = [strfind(line, ',') size(line,2)+1];
		ca{l,1} = line(1:commaPos(1)-1);
		for c = 2:size(commaPos,2)
			ca{l,c} = line(commaPos(c-1)+1 : commaPos(c)-1);
		end
	end
	
	return;
end
