function [ csv ] = cellArray2csv( ca )
%CELLARRAY2CSV Converts 2D cell array to CSV string.
	
	[r, c] = size(ca);
	
	csv = '';
	for i = 1:r
		csv = [csv cell2value(ca{i,1})];
		for j = 2:c
			csv = [csv ',' cell2value(ca{i,j})];
		end
		csv = [csv '\n'];
	end
	
	csv = [csv '\n'];
end

function out = cell2value ( cell )
	if(isnumeric(cell))
		out = num2str(cell);
	else
		out = char(cell);
	end
end
