/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  zpracovany_packet.h
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   hlavickovy soubor obsahujici strukturu zachyceneho paketu a definice potrebnych konstant
 */

#ifndef _ZPRACOVANY_PACKET_
#define _ZPRACOVANY_PACKET_

#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>

#define NEURCENO 0
#define XMPP_odchozi 1
#define XMPP_prichozi 2
#define IRC_odchozi 3
#define IRC_prichozi 4
#define OSCAR_odchozi 5
#define OSCAR_prichozi 6

#define odchozi 0
#define prichozi 1

#define IPverze4 4
#define IPverze6 6

// typy podle kterych se urci typ ukazatele na strukturu protokolu
enum TYP
{
	XMPP,
	IRC,
	OSCAR,
	NEZNAME
};

// typ transportniho protokolu
enum TRANSPORTNI
{
	NEUVEDENO,
	TCP,
	UDP
};

// struktura obsahuje informace o zachycene komunikaci a vlastni data v podobe
// ukazatele na u_char ktery je potreba pretypovat podle potreby
struct data_packetu
{
	int velikost_dat;
	int typ;
	int smer;
	int transportni_protokol;
	int verze_ip;
	struct in_addr ip_zdroje;
	struct in_addr ip_cile;
	int port_zdroje;
	int port_cile;
	struct timeval cas_zachyceni;
	char *data;
};

#endif

