/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  xmpp.c
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   soubor obsahujici funkce zpracovavajici protokol XMPP
 */

#include "xmpp.h"

enum STAV
{
	NEPRIPOJEN,
	UVODNI_STREAM,
	POTVRZEN_UVODNI_STREAM,
	PRIJATY_MOZNOSTI,
	SASL,
	SASL_CHALLENGE,
	SASL_RESPONSE,
	SASL_SUCCESS,
	SASL_FAILURE,
	SASL_ABORT,
	BIND,
	PRIHLASEN
};

/*
 * zpracovani zpravy protokolu xmpp
 */
void zpracuj_xmpp(struct data_packetu *zprava, struct sezeni *Sezeni, struct seznam_sledovani *Sledovani)
{
	//nastaveni promennych zavisejicich na sezeni
	char **potreba_dokoncit_prichozi = &(Sezeni->potreba_dokoncit_prichozi);
	int *ocekavat_dalsi_prichozi = &(Sezeni->ocekavat_dalsi_prichozi);

	char **potreba_dokoncit_odchozi = &(Sezeni->potreba_dokoncit_odchozi);
	int *ocekavat_dalsi_odchozi = &(Sezeni->ocekavat_dalsi_odchozi);

	char *data = zprava->data;
	// pro vysledny retezec (po spojeni vice nebo ziskany primo z daneho packetu)
	char *stanza = NULL;
	// pokud byl vysledny retezec ziskan spojovanim z predchozim je treba jej pote uvolnit
	int uvolnit = 0;

	// kontrola zacatku zpravy pro pripad ztraty paketu
	if(zprava->data[0] == '<' && (*ocekavat_dalsi_prichozi || *ocekavat_dalsi_odchozi))
	{
		if(*ocekavat_dalsi_prichozi && zprava->smer == prichozi)
		{
			*ocekavat_dalsi_prichozi = 0;
			free(*potreba_dokoncit_prichozi);
		}
		else if(*ocekavat_dalsi_odchozi && zprava->smer == odchozi)
		{
			*ocekavat_dalsi_odchozi = 0;
			free(*potreba_dokoncit_odchozi);
		}
	}

	// kontrola jestli je potreba dokoncit retezec z minula
	if(*ocekavat_dalsi_prichozi && zprava->smer == prichozi)
	{
		kopie_retezce(data, &stanza, delka_retezce(data));
		stanza = spoj_retezce(potreba_dokoncit_prichozi, delka_retezce(*potreba_dokoncit_prichozi), &stanza, delka_retezce(stanza));
		*ocekavat_dalsi_prichozi = 0;
		uvolnit = 1;
	}
	else if(*ocekavat_dalsi_odchozi && zprava->smer == odchozi)
	{
		kopie_retezce(data, &stanza, delka_retezce(data));
		stanza = spoj_retezce(potreba_dokoncit_odchozi, delka_retezce(*potreba_dokoncit_odchozi), &stanza, delka_retezce(stanza) );
		*ocekavat_dalsi_odchozi = 0;
		uvolnit = 1;
	}
	else
	{
		stanza = zprava->data;
	}

	// kontrola jestli bude potreba pripojit dalsi cast retezce.
	// kontrola pouze podle posledniho znaku prijateho retezce
	if(stanza[delka_retezce(stanza)-1] != '>' && stanza[delka_retezce(stanza)-1] != '\n')
	{
		if(zprava->smer == prichozi)
		{
			kopie_retezce(stanza, potreba_dokoncit_prichozi, delka_retezce(stanza));
			*ocekavat_dalsi_prichozi = 1;
		}
		else
		{
			kopie_retezce(stanza, potreba_dokoncit_odchozi, delka_retezce(stanza));
			*ocekavat_dalsi_odchozi = 1;
		}
		if(uvolnit)
		{
			free(stanza);
		}
	}
	// neni potreba cekat na dokonceni zpravy a muzeme ji rovnou zpracovat
	if(!*ocekavat_dalsi_odchozi && !*ocekavat_dalsi_prichozi)
	{
		struct xml *zpracovane_xml = analyza_stanzy(stanza);

		if(uvolnit)
		{
			free(stanza);
		}

		identifikuj_zpravu(zpracovane_xml, Sezeni, Sledovani, zprava->smer, &(zprava->cas_zachyceni));

		// xml jsme jiz zpracovali a neni treba jej dale ukladat
		uvolneni_xml(zpracovane_xml);
		free(zpracovane_xml);
	}
}

/*
 * identifikace zpravy a pripadne upraveni stavu a vytvoreni zprav IRI
 */
void identifikuj_zpravu(struct xml *zpracovane_xml, struct sezeni *Sezeni, struct seznam_sledovani *Sledovani, int smer, struct timeval *cas_zachyceni)
{
	int *aktualni_stav = &(Sezeni->aktualni_stav);

	// kontrola jestli jsme ve stavu prihlaseni, ale jeste nebyla vytvorena zprava begin (pridani pozadavku na odposlech az pozdeji)
	if(*aktualni_stav == PRIHLASEN)
	{
		if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
		{
			Sezeni->aktivni = 1;
			*aktualni_stav = PRIHLASEN;
			char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
			odesli_iri(vytvorena_iri);
			free(vytvorena_iri);
		}
	}

	for(int i = 0; i < zpracovane_xml->pocet_potomku; i++)
	{
		// v pripade ze jeste nebyl identifikovan cil, zkusime najit id v atributu prijateho elementu
		if(!Sezeni->cil_identifikovan || Sezeni->ID_uzivatele == NULL)
		{
			for(int atr = 0; atr < zpracovane_xml->potomci[i]->pocet_atributu; atr++)
			{
				if(porovnani_typu_atributu(zpracovane_xml->potomci[i]->atributy[atr], "from") && smer == odchozi)
				{
					if(Sezeni->ID_uzivatele == NULL)
					{
						char *id = ziskej_hodnotu_atributu(zpracovane_xml->potomci[i]->atributy[atr]);
						if(je_fullJID(id))
						{
							Sezeni->ID_uzivatele = id;
						}
						else
						{
							free(id);
						}
					}

					if(!Sezeni->cil_identifikovan)
					{
						int smazat = 1;
						char *JID = bareJID(Sezeni->ID_uzivatele);
						if(JID == NULL)
						{
							JID = Sezeni->ID_uzivatele;
							smazat = 0;
						}

						if(sledovani_ID(Sledovani, JID, XMPP))
						{
							Sezeni->cil_identifikovan = 1;
						}

						if(smazat)
						{
							free(JID);
						}
					}
				}
				else if(porovnani_typu_atributu(zpracovane_xml->potomci[i]->atributy[atr], "to") && smer == prichozi)
				{
					if(Sezeni->ID_uzivatele == NULL)
					{
						char *id = ziskej_hodnotu_atributu(zpracovane_xml->potomci[i]->atributy[atr]);
						if(je_fullJID(id))
						{
							Sezeni->ID_uzivatele = id;
						}
						else
						{
							free(id);
						}
					}

					if(!Sezeni->cil_identifikovan)
					{
						int smazat = 1;
						char *JID = bareJID(Sezeni->ID_uzivatele);
						if(JID == NULL)
						{
							JID = Sezeni->ID_uzivatele;
							smazat = 0;
						}

						if(sledovani_ID(Sledovani, JID, XMPP))
						{
							Sezeni->cil_identifikovan = 1;
						}

						if(smazat)
						{
							free(JID);
						}
					}
				}
			}
		}

		// urcime o jakou zpravu se jedna
		if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "stream:stream") && smer == odchozi)
		{
			if(*aktualni_stav == NEPRIPOJEN)
			{
				*aktualni_stav = UVODNI_STREAM;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "stream:stream") && smer == prichozi)
		{
			if(*aktualni_stav == UVODNI_STREAM)
			{
				*aktualni_stav = POTVRZEN_UVODNI_STREAM;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "stream:error"))
		{

		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "stream:features"))
		{
			if(*aktualni_stav == POTVRZEN_UVODNI_STREAM)
			{
				*aktualni_stav = PRIJATY_MOZNOSTI;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "auth"))
		{
			if(*aktualni_stav == PRIJATY_MOZNOSTI)
			{
				*aktualni_stav = SASL;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "challenge"))
		{
			if(*aktualni_stav == SASL)
			{
				*aktualni_stav = SASL_CHALLENGE;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "response"))
		{
			if(*aktualni_stav == SASL_CHALLENGE)
			{
				*aktualni_stav = SASL_RESPONSE;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "success"))
		{
			if(*aktualni_stav == SASL_RESPONSE)
			{
				*aktualni_stav = SASL_SUCCESS;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "failure"))
		{
			if(*aktualni_stav == SASL_RESPONSE || *aktualni_stav == SASL_ABORT)
			{
				*aktualni_stav = NEPRIPOJEN;

				if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL))
				{
					char *vytvorena_iri = vytvor_iri(IRI_REPORT, XMPP, Sezeni, TYP_AUTENTIZACE, NEUSPESNE, cas_zachyceni);
					odesli_iri(vytvorena_iri);
					free(vytvorena_iri);
				}
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "abort"))
		{
			if(*aktualni_stav == SASL || *aktualni_stav == SASL_CHALLENGE || *aktualni_stav == SASL_RESPONSE)
			{
				*aktualni_stav = SASL_ABORT;
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "iq"))
		{
			for(int atr = 0; atr < zpracovane_xml->potomci[i]->pocet_atributu; atr++)
			{
				if(porovnani_typu_atributu(zpracovane_xml->potomci[i]->atributy[atr], "type") && porovnani_hodnoty_atributu(zpracovane_xml->potomci[i]->atributy[atr], "set"))
				{
					for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_potomku; j++)
					{
						if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->element, "bind"))
						{
							if(*aktualni_stav == SASL_SUCCESS)
							{
								*aktualni_stav = BIND;
							}
						}
					}
				}
				else if(porovnani_typu_atributu(zpracovane_xml->potomci[i]->atributy[atr], "type") && porovnani_hodnoty_atributu(zpracovane_xml->potomci[i]->atributy[atr], "result"))
				{
					for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_potomku; j++)
					{
						if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->element, "bind"))
						{
							for(int k = 0; k < zpracovane_xml->potomci[i]->potomci[j]->pocet_potomku; k++)
							{
								if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->potomci[k]->element, "jid"))
								{
									// jeste neni prirazeno ID nebo jeste neni potvrzeno ze jde o sledovany cil
									if(!Sezeni->cil_identifikovan ||  Sezeni->ID_uzivatele == NULL)
									{
										if(Sezeni->ID_uzivatele == NULL)
										{
											kopie_retezce(zpracovane_xml->potomci[i]->potomci[j]->potomci[k]->obsah, &(Sezeni->ID_uzivatele), delka_retezce(zpracovane_xml->potomci[i]->potomci[j]->potomci[k]->obsah));
										}
										if(!Sezeni->cil_identifikovan)
										{
											int smazat = 1;
											char *JID = bareJID(Sezeni->ID_uzivatele);
											if(JID == NULL)
											{
												JID = Sezeni->ID_uzivatele;
												smazat = 0;
											}

											if(sledovani_ID(Sledovani, JID, XMPP))
											{
												Sezeni->cil_identifikovan = 1;
											}

											if(smazat)
											{
												free(JID);
											}
										}
									}

									if(*aktualni_stav == BIND)
									{
										*aktualni_stav = PRIHLASEN;
										if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
										{
											Sezeni->aktivni = 1;
											char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
											odesli_iri(vytvorena_iri);
											free(vytvorena_iri);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "message") && smer == prichozi)
		{
			for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_potomku; j++)
			{
				if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->element, "body"))
				{
					if(*aktualni_stav == PRIHLASEN)
					{
						if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && Sezeni->aktivni)
						{
							char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_PRIJATA_ZPRAVA, USPESNE, cas_zachyceni);
							odesli_iri(vytvorena_iri);
							free(vytvorena_iri);
						}
					}

					if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
					{
						Sezeni->aktivni = 1;
						*aktualni_stav = PRIHLASEN;
						char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
						vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_PRIJATA_ZPRAVA, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
					}
				}
				else // nejde primo o obsah zpravy -> lze pouzit pro identifikaci pripojeni uzivatele
				{
					if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
					{
						Sezeni->aktivni = 1;
						*aktualni_stav = PRIHLASEN;
						char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
					}
				}
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "message") && smer == odchozi)
		{
			for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_potomku; j++)
			{
				if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->element, "body"))
				{
					if(*aktualni_stav == PRIHLASEN)
					{
						if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && Sezeni->aktivni)
						{
							char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_ODESLANA_ZPRAVA, USPESNE, cas_zachyceni);
							odesli_iri(vytvorena_iri);
							free(vytvorena_iri);
						}
					}

					if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
					{
						Sezeni->aktivni = 1;
						*aktualni_stav = PRIHLASEN;
						char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
						vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_ODESLANA_ZPRAVA, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
					}

				}
				else // nejde primo o obsah zpravy -> lze pouzit pro identifikaci pripojeni uzivatele
				{
					if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
					{
						Sezeni->aktivni = 1;
						*aktualni_stav = PRIHLASEN;
						char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
					}
				}
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "presence") && smer == prichozi)
		{
			if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
			{
				for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_atributu; j++)
				{
					if(porovnani_typu_atributu(zpracovane_xml->potomci[i]->atributy[j], "from")
					&& porovnani_hodnoty_atributu(zpracovane_xml->potomci[i]->atributy[j], Sezeni->ID_uzivatele))
					{
						Sezeni->aktivni = 1;
						*aktualni_stav = PRIHLASEN;
						char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
					}
				}
			}
		}
		else if(porovnani_retezce(zpracovane_xml->potomci[i]->element, "presence") && smer == odchozi)
		{
			if(*aktualni_stav == PRIHLASEN)
			{
				for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_atributu; j++)
				{
					if(porovnani_typu_atributu(zpracovane_xml->potomci[i]->atributy[j], "type")
					&& porovnani_hodnoty_atributu(zpracovane_xml->potomci[i]->atributy[j], "unavailable"))
					{
						if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && Sezeni->aktivni)
						{
							char *vytvorena_iri = vytvor_iri(IRI_END, XMPP, Sezeni, TYP_ODHLASEN, USPESNE, cas_zachyceni);
							odesli_iri(vytvorena_iri);
							free(vytvorena_iri);
						}

						*aktualni_stav = NEPRIPOJEN;
						Sezeni->aktivni = 0;
						Sezeni->ukonceno = 1;
						return;
					}
				}
			}

			if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && !Sezeni->aktivni)
			{
				Sezeni->aktivni = 1;
				*aktualni_stav = PRIHLASEN;
				char *vytvorena_iri = vytvor_iri(IRI_BEGIN, XMPP, Sezeni, TYP_PRIHLASEN, USPESNE, cas_zachyceni);
				odesli_iri(vytvorena_iri);
				free(vytvorena_iri);
			}

			if(*aktualni_stav == PRIHLASEN)
			{
				int show_element_nalezen = 0;
				for(int j = 0; j < zpracovane_xml->potomci[i]->pocet_potomku; j++)
				{
					if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->element, "show"))
					{
						show_element_nalezen = 1;
						if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL))
						{
							if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->obsah, "away") && Sezeni->aktivni)
							{
								char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_AWAY, USPESNE, cas_zachyceni);
								odesli_iri(vytvorena_iri);
								free(vytvorena_iri);
							}
							else if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->obsah, "chat") && Sezeni->aktivni)
							{
								char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_CHAT, USPESNE, cas_zachyceni);
								odesli_iri(vytvorena_iri);
								free(vytvorena_iri);
							}
							else if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->obsah, "dnd") && Sezeni->aktivni)
							{
								char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_DND, USPESNE, cas_zachyceni);
								odesli_iri(vytvorena_iri);
								free(vytvorena_iri);
							}
							else if(porovnani_retezce(zpracovane_xml->potomci[i]->potomci[j]->obsah, "xa") && Sezeni->aktivni)
							{
								char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_NA, USPESNE, cas_zachyceni);
								odesli_iri(vytvorena_iri);
								free(vytvorena_iri);
							}
						}
					}
				}
				// show nenalezen a v pripade unavailable by sme se sem ani nedostali takze jde o stav online
				if(!show_element_nalezen)
				{
					if(Sezeni->cil_identifikovan && (Sezeni->ID_uzivatele != NULL) && Sezeni->aktivni)
					{
						char *vytvorena_iri = vytvor_iri(IRI_CONTINUE, XMPP, Sezeni, TYP_ONLINE, USPESNE, cas_zachyceni);
						odesli_iri(vytvorena_iri);
						free(vytvorena_iri);
					}
				}
			}
		}
	}
}

/*
 * ze zadaneho ID ziska bare JID
 * pokud jiz je na vstupu bare JID, vraci se NULL, aby nebylo treba alokovat dalsi pamet
 */
char *bareJID(char *ID)
{
	char *pomocny = NULL;
	int i, delka = delka_retezce(ID);

	for(i = 0; i < delka ; i++)
	{
		if(ID[i] == '/')
		{
			break;
		}
	}

	if(i < delka)
	{
		kopie_retezce(ID, &pomocny, i);
	}

	return pomocny;
}

/*
 * vraci 1 pokud se jedna u full JID jinak vraci 0
 */
int je_fullJID(char *ID)
{
	for(int i = 0 ; i < delka_retezce(ID) ; i++)
	{
		if(ID[i] == '/' && i < (delka_retezce(ID) - 1))
		{
			return 1;
		}
	}

	return 0;
}

