/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  sprava.h
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   hlavickovy soubor pro funkce pro spravu sezeni a spravu pozadavku na odposlechy
 */

#ifndef _SPRAVA_
#define _SPRAVA_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h> 

#include "my_string.h"
#include "zpracovany_packet.h"

int socket_sprava;

struct sledovany_cil
{
	int protokol;
	char *ID;
	int typ_ip;
	struct in_addr IPv4;
	struct in6_addr IPv6;
	int maska;
};

struct sledovany_cil_ptr 
{
	struct sledovany_cil_ptr *dalsi;
	struct sledovany_cil data;
};

struct seznam_sledovani
{
	struct sledovany_cil_ptr *Aktivni;
	struct sledovany_cil_ptr *Prvni;
};

struct sezeni
{
	int aktivni;
	// cil_identifikovan urcuje zda byl u daneho sezeni urcen cil
	// pouziti pri detekci cile podle ID. v pripade ze neni identifikovan prohleda se zachycena zprava
	// kdyz neni hleda ID podporovano nenbo neni nalezeno. sezeni se smaze
	int cil_identifikovan;
	unsigned int cin; // identifikator
	int transportni_protokol;
	int typ_ip;
	struct in_addr ipv4_adresa;
	struct in_addr ipv4_adresa_2;
	struct in6_addr ipv6_adresa;
	struct in6_addr ipv6_adresa_2;
	int port;
	int port_2;
	int protokol;
	char *ID_uzivatele;
	int aktualni_stav;
	char *potreba_dokoncit_prichozi;
	int ocekavat_dalsi_prichozi;
	char *potreba_dokoncit_odchozi;
	int ocekavat_dalsi_odchozi;
	int ukonceno;
};

struct sezeni_ptr 
{
	struct sezeni_ptr *dalsi;
	struct sezeni data;
};

struct seznam_sezeni
{
	struct sezeni_ptr *Aktivni;
	struct sezeni_ptr *Prvni;
};

int otevri_spojeni_pro_spravu_sledovani(char *host, char *port);
void uzavri_spojeni_pro_spravu_sledovani(void);

void inicializace_seznamu_sledovani(struct seznam_sledovani *Seznam);
void zpracuj_novy_pozadavek_na_sledovani(char *pozadavek, struct seznam_sledovani *Seznam, struct seznam_sezeni *Sezeni);
void smazani_seznamu_sledovani(struct seznam_sledovani *Seznam);
void vloz_sledovani_IPv4(struct seznam_sledovani *Seznam, struct in_addr IP, int protokol);
void vloz_sledovani_IPv4_rozsah(struct seznam_sledovani *Seznam, struct in_addr IP, int maska, int protokol);
void vloz_sledovani_ID(struct seznam_sledovani *Seznam, char *ID, int protokol);
void zrus_sledovani_IPv4(struct seznam_sledovani *Seznam, struct in_addr IP, int protokol);
void zrus_sledovani_IPv4_rozsah(struct seznam_sledovani *Seznam, struct in_addr IP, int maska, int protokol);
void zrus_sledovani_ID(struct seznam_sledovani *Seznam, char *ID, int protokol);

int sledovani_IPv4(struct seznam_sledovani *Seznam, struct in_addr IP, int protokol);
int sledovani_IPv4_rozsah(struct seznam_sledovani *Seznam, struct in_addr IP, int maska, int protokol);
int sledovani_ID(struct seznam_sledovani *Seznam, char *ID, int protokol);

void deaktivuj_sezeni_IPv4(struct seznam_sledovani *Seznam, struct in_addr IP, int maska, int protokol, struct seznam_sezeni *Sezeni);
void deaktivuj_sezeni_ID(struct seznam_sledovani *Seznam, char *ID, int protokol, struct seznam_sezeni *Sezeni);

void inicializace_seznamu_sezeni(struct seznam_sezeni *Seznam);
void smazani_seznamu_sezeni(struct seznam_sezeni *Seznam);
void vloz_prvni_sezeni(struct seznam_sezeni *Seznam);
void odeber_sezeni(struct seznam_sezeni *Seznam, struct sezeni *Sezeni);

void inicializace_sezeni(struct sezeni *Sezeni);
void smazani_sezeni(struct sezeni *Sezeni);

struct sezeni *zapocate_sezeni_IPv4(struct seznam_sezeni *Seznam, int port, struct in_addr ip);
struct sezeni *sezeni_podle_IPv4(struct seznam_sezeni *Seznam, struct in_addr IP);
struct sezeni *sezeni_podle_ID(struct seznam_sezeni *Seznam, char *ID);

#endif
