from django.conf.urls.defaults import *

# prvni argument je zkratka k views, aby se nemusela opakovat v kazdem callbacku
urlpatterns = patterns('its.itsapp.views',
	url(r'^$', 'index', name='index'),

######## GALLERY URLS	
	url(r'^gallery/$', 'galleries', name='galleries'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)$', 'gallery_detail', name='gallery_detail'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/page/(?P<page>\d+)$', 'gallery_detail_page', name='gallery_detail_page'),
	
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/addphoto$', 'add_photo', name='add_photo'),

	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/edit$', 'gallery_edit_photos', name='gallery_edit_photos'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/edit/page/(?P<page>\d+)$', 'gallery_edit_page', name='gallery_edit_page'),

	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/permissions$', 'gallery_permissions', name='gallery_permissions'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/permissions/(?P<permission_id>[a-zA-Z0-9]+)/remove$', 'gallery_permissions_remove', name='gallery_permissions_remove'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/remove$', 'gallery_remove', name='gallery_remove'),

	url(r'^gallery/create_empty_gallery/$', 'create_empty_gallery',name='create_empty_gallery'),
	url(r'^gallery/upload/(?P<gallery_id>[a-zA-Z0-9._-]+)$', 'upload_finish',name='upload_finish'),
	url(r'^gallery/upload_post_processing/(?P<gallery_id>[a-zA-Z0-9._-]+)$', 'upload_post_processing',name='upload_post_processing'),
#############################3
	url(r'^user/(?P<user_id>\d+)/$', 'user_info', name='user_info'),	
######## TAGS URLS
	#vraci tagy pro aktualni fotku
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/get_tags$', 'get_tags', name='get_tags'),
	#vraci seznam vsech tagu v DB pro potreby napovidani
	url(r'^get_all_tag_names$', 'get_all_tag_names', name='get_all_tag_names'),
	#url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/add_tag/(?P<tag_id>\d+)/(?P<tag_type>-?\d)$', 'add_tag', name='add_tag'),
	#pridavani tagu 
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/add_tags/(?P<tags>(-?\d+,)*)$', 'add_tags', name='add_tags'),
	#odstraneni tagu
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/remove_tag/(?P<tag_id>\d+)$', 'remove_tag', name='remove_tag'),
	#vytvoreni noveho tagu
	url(r'^new_tag/(?P<tag_name>\w+)$', 'new_tag', name='new_tag'),
	#vraci seznam navrhovanych tagu
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/get_suggestion/(?P<current_suggestion>(?:\d+,)*)/(?P<suggestions_count>\d+)$', 'get_suggestion', name='get_sugestion'),
	#vraci seznam tagu v kolnich fotkach galerie
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/get_local_tags$', 'get_local_tags', name='get_local_tags'),

######## PHOTO URLS
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\w+)/show$', 'show_photo', name='show_photo'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/delete$', 'photo_delete', name='photo_delete'),
	url(r'^gallery/(?P<gallery_id>[a-zA-Z0-9._-]+)/(?P<photo_id>\d+)/edit$', 'photo_edit', name='photo_edit'),


######## BINARY IMAGE DATA URLS
	url(r'^getimagedata/(?P<photo_id>\d+)$', 'get_image_data', name='get_image_data'),
	url(r'^getthumb2/(?P<photo_id>-?\d+)/(?P<width>\d+)$', 'get_thumb_data2', name='get_thumb_data2'),
	url(r'^getthumb/(?P<path>[a-zA-Z0-9._-]+)/(?P<width>\d+)$', 'get_thumb_data', name='get_thumb_data'),
	# what = "user" or "group" , what_id = user.id or clan.id
	url(r'^getavatar/(?P<what>\w+)/(?P<what_id>-?\d+)$', 'get_avatar_data', name='get_avatar_data'),

######## AUTH
	url(r'^login/$', 'login_user', name='login_user'),
	url(r'^logout/$', 'logout_user', name='logout_user'),
	url(r'^registration/$', 'registrate_user', name='registrate_user'),

######## GROUPS
	url(r'^group/$', 'group', name='group'),
	url(r'^group/new/$', 'group_new', name='group_new'),
	url(r'^group/(?P<clan_id>\d+)/$', 'group_detail', name='group_detail'),
	url(r'^group/(?P<clan_id>\d+)/edit/$', 'group_edit', name='group_edit'),
	url(r'^group/(?P<clan_id>\d+)/delete/$', 'group_delete', name='group_delete'),
	url(r'^group/(?P<clan_id>\d+)/invite/$', 'group_invite', name='group_invite'),
	url(r'^group/(?P<clan_id>\d+)/invite/(?P<user_id>[a-zA-Z0-9\._-]+)/delete/$', 'group_invite_delete', name='group_invite_delete'),

######## SETTINGS URLS
	url(r'^settings/$', 'settings_user', name='settings_user'),

######## SPECIAL ADMIN URLS
	url(r'^admin_page/$', 'admin_page', name='admin_page'),
	url(r'^admin_page/syncwithvt/$', 'syncwithvt', name='syncwithvt'),
	url(r'^admin_page/import_annotation/$', 'import_annotation', name='import_annotation'),
	url(r'^admin_page/importTrecvidClass/$', 'importTrecvidClass', name='importTrecvidClass'),
	url(r'^admin_page/get_all_gall_ids$', 'get_all_gall_ids', name='get_all_gall_ids'),

######## JSON URLS
	url(r'^get_data_left_side_panel/$', 'get_data_left_side_panel', name='get_data_left_side_panel'),
######## SEARCH URLS
	url(r'^search/(?P<term>[\w ]+)$', 'search', name='search'),

######## USER URLS
	url(r'^user/(?P<user_id>\d+)$', 'user_page', name='user_page'),
	url(r'^user/None$', 'user_page', name='user_page'),



	


)
