from its.itsapp.models import Gallery, Permission, Clan, ClanMembership
from django.contrib.auth.models import User
from debug import *
import ITSconf

class PermissionUtil:
	"""
	Prava:
	11 - RW
	10 - R
	01 - W
	00 - 0
	"""

	READ_MASK = 0b10
	WRITE_MASK = 0b01
	READ_SHIFT = 1
	WRITE_SHIFT = 0

	PERMISSIONS_CHOICES = (
		(0, 'No permissions'),
		(1, 'Write only'),
		(2, 'Read only'),
		(3, 'Read and write'),
	)



	"""
		Konstruktor
		current_user: objekt uzivatele
		gallery_identificator: identifikator galerie
	"""
	def __init__(self, current_user, gallery_identificator):
		self.current_user = current_user
		try:
			self.gallery = Gallery.objects.get(identificator=gallery_identificator)
		except:
			self.gallery = None



	def checkReadPermission(self):
		if(self.__checkPublicPermission(self.READ_MASK, self.READ_SHIFT)):
			return True
		else:
			return self.__checkPermission(self.READ_MASK, self.READ_SHIFT)



	def checkWritePermission(self):
		return self.__checkPermission(self.WRITE_MASK, self.WRITE_SHIFT)



	def __checkPublicPermission(self, mask, shift):
		try:
			public_clan = Clan.objects.get(name=ITSconf.PUBLIC_CLAN)
			permission = Permission.objects.get(gallery=self.gallery,clan=public_clan)
			and_operation = permission.permission & mask
			shift_operation = and_operation >> shift
			if(shift_operation==1):
				return True
			else:
				return False
		except:
			return False


	def __checkPermission(self, mask, shift):
		user_admin=User.objects.get(username="admin")

		# owner galerie ma pravo cist
		if(self.gallery!=None and self.gallery.owner.id==self.current_user.id):
			return True
		# admin ma pravo cist
		elif (self.current_user==user_admin):
			return True
		# zkontroluj skupiny
		else:
			# projiti vsech skupin u kterych je uzivatel vlastnik
			my_clans = Clan.objects.filter(owner=self.current_user)
			for clan in my_clans:
				# kontrola, zda pro dany clan a galerii existuje pravo cist
				try:
					# ziskani objektu prava
					permission = Permission.objects.get(gallery=self.gallery,clan=clan)
					# overeni nastaveni prava read na 1
					and_operation = permission.permission & mask
					shift_operation = and_operation >> shift
					if(shift_operation==1):
						return True
					else:
						continue
				except:
					# pro dany clan a galerii neexistuje zadne pravo
					continue

			# projiti vsech clanovych clenstvi ve kterych je uzivatel clen
			memberships = ClanMembership.objects.filter(user=self.current_user)
			for membership in memberships:
				# kontrola, zda pro dany clan a galerii existuje pravo cist
				try:
					# ziskani objektu prava
					permission = Permission.objects.get(gallery=self.gallery,clan=membership.clan)
					# overeni nastaveni prava read na 1
					and_operation = permission.permission & mask
					shift_operation = and_operation >> shift
					if(shift_operation==1):
						return True
					else:
						continue
				except:
					# pro dany clan a galerii neexistuje zadne pravo
					continue

			return False

































#	"""
#		Kontroluje opravneni uzivatele k cteni/zapisu do galerie
#		current_user: objekt uzivatele
#	"""
#	def checkUserPermission(self, current_user):
#		"""
#		if(self.gallery!=None):
#			debugWrite("-----------------------------")
#			debugWrite("GALLERY NAME:" + str(self.gallery.name))
#			debugWrite("GALLERY OWNER:" + str(self.gallery.owner.username))
#			debugWrite("CURRENT USER:" + current_user.username)
#		else:
#			debugWrite("-----------------------------")
#
#				debugWrite("checkReadPermission user: NONE")"""
#		user_admin=User.objects.get(username="admin")
#
#		if(self.gallery!=None and self.gallery.owner.id==current_user.id):
#			return True
#		elif (current_user==user_admin):
#			return True
#		else:
#			return False
#
#
#
	"""
		Kontroluje opravneni skupiny k cteni galerie
		currnet_clan: objekt skupiny
	"""
	def checkClanReadPermission(self, current_clan):
		try:
			permission = Permission.objects.get(clan=current_clan, gallery=self.gallery)
			#permission = Permission.objects.filter(clan__exact=current_clan.id, gallery__exact=self.gallery.id)[0]
		except:
			permission = None

		"""
		if(permission!=None):
			debugWrite("-----------------------------")
			debugWrite("GALLERY NAME:" + str(self.gallery.name))
			debugWrite("GALLERY OWNER:" + str(self.gallery.owner))
			debugWrite("CURRENT CLAN:" + str(current_clan.name))
			debugWrite("PERMISSION:" + str(permission.permission))
		else:
			debugWrite("-----------------------------")
			debugWrite("checkReadPermission clan: NONE")"""

		if(permission!=None):
			and_operation = permission.permission & self.READ_MASK
			shift_operation = and_operation >> self.READ_SHIFT
			if(shift_operation==1):
				return True
			else:
				return False

		else:
			return False


	"""
		Kontroluje opravneni skupiny k zapisu do galerie
		current_clan: objekt skupiny
	"""
	def checkClanWritePermission(self, current_clan):
		try:
			#permission = Permission.objects.get(clan=current_clan.id)
			permission = Permission.objects.filter(clan__exact=current_clan.id, gallery__exact=self.gallery.id).get()[0]
		except:
			permission = None

		if(permission!=None):
			and_operation = permission.permission & self.WRITE_MASK
			shift_operation = and_operation >> self.WRITE_SHIFT
			if(shift_operation==1):
				return True
			else:
				return False

		else:
			return False


