#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <boost/algorithm/string.hpp>
#include "../vtapi/include/vtapi_settings.h"
#include "../vtapi/include/vtapi.h"

using namespace std;

int main (int argc, char** argv)
{

	VTApi * vtapi = new VTApi(argc, argv);

	Dataset* dataset = vtapi->newDataset();
	dataset->next();

	Sequence* seq = dataset->newSequence("iacc.1.tv11.devel.kf");	
	seq->next();	

        string STRING;
	ifstream infile;
	infile.open ("/home/ilanik/matylda/iacc.1.tv11.devel.ann");

	//pomocne pole s anotacemi
	int *annot=new int[500];

	if(infile.is_open()){
		while(!infile.eof()) // To get you all the lines.
       		{
		        getline(infile,STRING); // Saves the line in STRING.
		        //cout<<STRING; // Prints our STRING.
			std::vector<std::string> strs;
			boost::split(strs, STRING, boost::is_any_of(" "));
	
			std::vector<std::string> path;
			boost::split(path, strs[0], boost::is_any_of("/"));
			string filename=path[path.size()-1];
			cout<<"filename:"<<filename<<endl;
			
			Image *img=seq->newImage(filename);
			if(img->next()){

				for(int i=3;i<strs.size();i++){
					//cout<<(i-2)<<":"<<strs[i]<<endl;
					annot[i-3]=atoi(strs[i].c_str());			
				}
				img->setIntA("tags",annot,500);		
				img->next();
				delete img;
				
			}else{
				cout<<filename<<" is not in DB"<<endl;
			}
			
	       	}
		infile.close();
	}

	delete[] annot;
	delete seq;
	delete vtapi;
	
	return 0;
}
