----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all; 
use IEEE.NUMERIC_STD.ALL;
use work.data_types.all;		-- my data types
use work.configure.all;		-- my data types
library UNISIM;
use UNISIM.VComponents.all;

entity output_buffer is
	port(
		CLK 	: in std_logic;
		RESET : in std_logic;
		OVERLOAD : out std_logic;
		
		----- input
		X_A	: in std_logic_vector(9 downto 0);
		Y_A	: in std_logic_vector(9 downto 0);
		S_A	: in std_logic_vector(3 downto 0);
		SUM_A	: in std_logic_vector(17 downto 0);
		ENA_A	: in std_logic;
		
		X_B	: in std_logic_vector(9 downto 0);
		Y_B	: in std_logic_vector(9 downto 0);
		S_B	: in std_logic_vector(3 downto 0);
		SUM_B	: in std_logic_vector(17 downto 0);
		ENA_B	: in std_logic;
		
		----- output
		OUT_DATA	: out std_logic_vector(31 downto 0);
		OUT_ENA	: out std_logic;
		OUT_BUSSY: out std_logic;
		OUT_READY: in std_logic;
		OUT_ADDR	: out std_logic_vector(31 downto 0);

		OUT_COUNT : out std_logic_vector(31 downto 0)		
		);
end output_buffer;

architecture Behavioral of output_buffer is

component chipsicon
  PORT (
    CONTROL0 : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0));

end component;

component chipskopeC
  PORT (
    CONTROL : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0);
    CLK : IN STD_LOGIC;
    TRIG0 : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
    TRIG1 : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
    TRIG2 : IN STD_LOGIC_VECTOR(1 DOWNTO 0));

end component;

signal control : STD_LOGIC_VECTOR(35 DOWNTO 0);
signal debug	: std_logic_vector(7 downto 0);

type array_4x32 is array(3 downto 0) of std_logic_vector(31 downto 0);
signal buf_0_A, buf_0_B : array_4x32;
signal buf_1_A, buf_1_B : array_4x32;
signal next_buf_0_A, next_buf_0_B : array_4x32;
signal next_buf_1_A, next_buf_1_B : array_4x32;


signal suma, next_suma : std_logic_vector(31 downto 0):=(others => '0');
signal suma_hold : std_logic_vector(31 downto 0);
signal in_A, out_A	  : std_logic_vector( 1 downto 0);
signal next_in_A, next_out_A : std_logic_vector(1 downto 0);
signal in_B, out_B	  : std_logic_vector( 1 downto 0);
signal next_in_B, next_out_B : std_logic_vector(1 downto 0);

signal next_out_data : std_logic_vector(31 downto 0);
signal next_out_ena : std_logic;
signal next_out_bussy : std_logic;

signal addres : std_logic_vector(31 downto 0);
signal next_addres : std_logic_vector(31 downto 0);



begin

SYNC_PROC: process(CLK, RESET)
begin
if (CLK'event and CLK = '1') then
         if (RESET = '1') then
				suma <= (others => '0');
				in_A <= (others => '0');
				out_A <= (others => '0');
				in_B <= (others => '0');
				out_B <= (others => '0');
				OUT_ADDR <= DETECT_ADDRES;
				addres   <= DETECT_ADDRES;
				OUT_BUSSY <= '0';
				OUT_ENA <= '0';
				suma_hold <= suma;
         else
				suma <= next_suma;
				addres   <= next_addres;
				OUT_ADDR <= addres;
				in_A <= next_in_A;
				out_A <= next_out_A;
				in_B <= next_in_B;
				out_B <= next_out_B;
				buf_0_A <= next_buf_0_A;
				buf_0_B <= next_buf_0_B;
				
				OUT_ENA <= next_out_ena;
				OUT_DATA <= next_out_data;
				OUT_BUSSY <= next_out_bussy;
				
         end if;			
			OUT_COUNT <= suma_hold;
      end if;
end process;

A_PROC: process (ENA_A, X_A, Y_A, S_A, SUM_A, in_A, buf_0_A, buf_1_A)
begin

	next_in_A <= in_A;
	next_buf_0_A <= buf_0_A;
	next_buf_1_A <= buf_1_A;
	
	if ENA_A = '1' then
		next_buf_0_A(conv_integer(in_A)) <= S_A&"00"&Y_A&"000000"&X_A;
		next_buf_1_A(conv_integer(in_A)) <= "00000000000000"&SUM_A;
		next_in_A <= in_A + 1;
	end if;
		
end process;

B_PROC: process (ENA_B, X_B, Y_B, S_B, SUM_B, in_B, buf_0_B, buf_1_B)
begin

	next_in_B <= in_B;
	next_buf_0_B <= buf_0_B;
	next_buf_1_B <= buf_1_B;
	
	if ENA_B = '1' then
		next_buf_0_B(conv_integer(in_B)) <= S_B&"00"&Y_B&"000000"&X_B;
		next_buf_1_B(conv_integer(in_B)) <= "00000000000000"&SUM_B;
		next_in_B <= in_B + 1;
	end if;
		
end process;

OUT_PROC: process (ENA_B, X_B, Y_B, suma, in_B, in_A, out_A, out_B, buf_0_A, buf_0_B, OUT_READY, addres)
begin
	next_suma <= suma;
	next_out_ena <= '0';
	next_out_bussy <= '1';
	next_out_data <= (others => '0');
	next_out_A <= out_A;
	next_out_B <= out_B;
	next_addres   <= addres;
	if OUT_READY = '1' then
		if in_B /= out_B then
			next_out_B <= out_B + 1;
			next_suma <= suma + 1;
			next_out_ena <= '1';
			next_out_data <= buf_0_B(conv_integer(out_B));
			next_addres   <= addres + 4;
		elsif in_A /= out_A then
			next_out_A <= out_A + 1;
			next_suma <= suma + 1;
			next_out_ena <= '1';
			next_out_data <= buf_0_A(conv_integer(out_A));
			next_addres   <= addres + 4;
		end if;
	end if;
	if in_A /= out_A or in_B /= out_B then
		next_out_bussy <= '1';
	end if;	
end process;

--ch_icon : chipsicon
--  port map ( CONTROL0 => control);
--  
--your_instance_name : chipskopeC
--  port map (
--    CONTROL => control,
--    CLK => CLK,
--    TRIG0 => debug,
--    TRIG1 => in_B,
--    TRIG2 => out_B);

debug(0) <= OUT_READY;
debug(1) <= next_out_ena;
debug(2) <= next_out_bussy;
debug(7) <= ENA_B;
end Behavioral;

