----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use work.data_types.all;		-- my data types
use IEEE.NUMERIC_STD.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity lrd_table is
	port(
		CLK	: in std_logic;
		
		TABLE_A	: in std_logic_vector(9 downto 0);
		INDEX_A	: in std_logic_vector(4 downto 0);
		OUT_A		: out std_logic_vector(8 downto 0);
		
		TABLE_B	: in std_logic_vector(9 downto 0);
		INDEX_B	: in std_logic_vector(4 downto 0);
		OUT_B		: out std_logic_vector(8 downto 0)
	);
end lrd_table;

architecture Behavioral of lrd_table is

signal adress_A : std_logic_vector(12 downto 0);
signal adress_B : std_logic_vector(12 downto 0);

signal next_A, next_B	: std_logic_vector(1 downto 0);

signal zero0, zero1	: std_logic_vector(26 downto 0); -- warning

signal out_a_0, out_a_1, out_a_2, out_a_3	: std_logic_vector(8 downto 0);
signal out_b_0, out_b_1, out_b_2, out_b_3	: std_logic_vector(8 downto 0);

begin

SYN_PROC: process (CLK)
	begin
		if( CLK'event and CLK = '1') then			
			next_A <= adress_A(12 downto 11);
			next_B <= adress_B(12 downto 11);
		end if;
end process;



adress_A <= TABLE_A(8 downto 0)&"0000"+ TABLE_A(8 downto 0) + INDEX_A; 	-- table * 17 + index
adress_B <= TABLE_B(8 downto 0)&"0000"+ TABLE_B(8 downto 0) + INDEX_B; 	


WITH next_A  SELECT
    OUT_A <=	out_a_0 WHEN "00",
					out_a_1 WHEN "01",
					out_a_2 WHEN "10",
					out_a_3 WHEN "11",
					out_a_0 WHEN OTHERS;

WITH next_B  SELECT
    OUT_B <=	out_b_0 WHEN "00",
					out_b_1 WHEN "01",
					out_b_2 WHEN "10",
					out_b_3 WHEN "11",
					out_b_0 WHEN OTHERS;


bram_0: RAMB16BWER
		generic map (
			DATA_WIDTH_A => 9, 
			DATA_WIDTH_B => 9, 
			WRITE_MODE_A => "NO_CHANGE",
			WRITE_MODE_B => "NO_CHANGE",
			SIM_COLLISION_CHECK => "WARNING_ONLY",
			--INIT_FILE => "table_memory_data_0.mif",
			INIT_00 => X"1d0bf8e5d8cab2afa1948d7c858dacb4a4979aa2aab1bda4daec0218272f4a5a",
			INIT_01 => X"a8adadaea2d6f20618242c1cfe3324170a01f4ece2b8c0b19d8c8480849d4832",
			INIT_02 => X"f6eec1dad6ccc7bebfc2c8d0d0cacececed4d2bbd4e2eafa18264229e1c5b8b2",
			INIT_03 => X"c1dfeae8f501122e4ae6edf4f0e6dfd6ccbacfd8eaf9122f3319353024150afa",
			INIT_04 => X"eacec6bec8dae0d8bebac6d8e50723e70df6dacec2c0c8dddbcecbd1d6d8dedf",
			INIT_05 => X"0910243246d0d3ceced0d4ced4bde2e6f7061015221ee1cec9cad3e0fc15e500",
			INIT_06 => X"cedceadfc9bfcee2ec051feb0dfbe6dacecad0e3e4dfdae3e2e4dadfc2e2ecfb",
			INIT_07 => X"e0f0dac6c6cde5f904e8200df2e0d3ccdae1eee1dbdeedee021ae2fbe6ccccc9",
			INIT_08 => X"d6d1d5e8f50317ec1b08f0e4dad9dae7ceccc7cadaecfc12e91a08f4e3d8e0db",
			INIT_09 => X"ced2d4d8d9c7f4fe020f1b1a0bf6ded2c8c9d6ed0914f307fde0d6ced0d4f4d5",
			INIT_0a => X"dcee00e21612100705f7e4e3322c2c1d0efaf0e4c4e1e8edeafafc020fead5ca",
			INIT_0b => X"15fe0bf5e0dddaccd8eaebd8c8d3ddee0418f70effe6d7d4d0cce6e1ccd8cece",
			INIT_0c => X"0e04f8ece4e0e0eae3d4d0d7dce4f009e41a06f9f2e6f1e6e2e6cac0d8e2f308",
			INIT_0d => X"161c262e3213f9020800fef4ece0c3eafc0b1728221b0dd3bdcbc7d7ed0212e4",
			INIT_0e => X"c2c1d6e6eed1ccdce7f80916fe0efaebded4ced7ec120a06fffaf2ebe6d3f808",
			INIT_0f => X"cce6e6f3f500090c0c12ec05f2ecded6c6cec6e8cdd6e3f1021008e204f9ded4",
			INIT_10 => X"d1ccc8d1ecfe0a15f3120801fbf7eae2cee0e4d9eaf3f80d19dc1208f1e6e3d2",
			INIT_11 => X"d3e4e5f7ff13f51606020402fef4e6f2ebe2eff3ff0c1bdb06f2e2e4dce0ebf3",
			INIT_12 => X"f3000816f81508faf4e6e0dce6eee1d6dee3f60b15ed1806f4e6ded7dbe6cbd6",
			INIT_13 => X"f001ee1005f8e5d1cee0efeae1f1f2fa060b1702160a00f3e5dccad5dbd4e0ed",
			INIT_14 => X"e1eae8eaf8020a1a20c6cbd0e7f4fa0d15f80d0803f8faeddfcee2d7dcd4dee7",
			INIT_15 => X"fa020b13181c1aedd9dae6ecfa0c18e81004f6eedcdedcea08fcf8f5f0eee6eb",
			INIT_16 => X"05131c2314fe16120d0e0efeeed9e7fb0a161e1e20fc2c1d180602faf8ebccf4",
			INIT_17 => X"edf0f6eae6ebf2f705050dec170901ece0dfecf5f8fb0a0400f5f2e4e5e8e7fa",
			INIT_18 => X"f4ded8e3eaecf60511ec180e06f9f8f1e2e02121201d180afcf7e4fdebe8e8f2",
			INIT_19 => X"cae8f1020b0911ee07fcf2f1e9eee9ddf2d8cfdae5fa0b12f405feebddd9d6e2",
			INIT_1a => X"f6f7eaeef2eefb0006fd0e0d05102720100901fbe9e1e6ecebedf9fe08ff10c5",
			INIT_1b => X"050815ff12fff8ede2dad4dcf6e4dceadcf10105020c08f2e5d3d0ebe231180d",
			INIT_1c => X"ffe1060e0e0801f8e7ead5d8e2f0f6011010f91008fef0f6f6d6e8efe8ecf4ff",
			INIT_1d => X"1408f6eae3e0e4f6f6cec8dbeefafe05f80d0d0706fff8f4e2e3d2ddeae3ebf4",
			INIT_1e => X"fdfce9e8dee20d151504fff3efeed6f7fc080e191b1606fef0e2ebecee010ce6",
			INIT_1f => X"0c18272ce9e7d6dfe8ebfa0cfc0df9def2d8e4f2f2f2dedbdaf3f8fc04f6100a",
			INIT_20 => X"ddeee8e5dfedf7ff0c15031603f1e6e8ebf3f9f4f4f4f2f2fbf8f5efeef8f5fc",
			INIT_21 => X"efe0d2d6daf00604ff040702f0dcd3d6e2f3f0eeeef6010a08f606f0e0d0d7d0",
			INIT_22 => X"f8f7ff0a1014f20a06fafae9e9e0cbf0e4e1ebe6f6020fe81203f2eeeee4e6ed",
			INIT_23 => X"ebf4ff05f00e0c0c04f8f1e0e0e7e7faf4fc050e14060ef8faeaefdce8e7f6ee",
			INIT_24 => X"080bfd0c0700f9f9f2e8e1e1d2deedfa0c110cf00002f8f9f1f1f2e6e2e2eedd",
			INIT_25 => X"d4eff5fc0b1014131cf6dcdfd7e3e7fc0afc0cfcf6f2e3e5e0e8ccdceaf1fe01",
			INIT_26 => X"0805f9eae0e3ec1f231a0c08fefaece4ee020a101826210b0f10121203f8f2ed",
			INIT_27 => X"eee0d8d6dce0e1f8f1fafc0b0efa0c0600f8e6e4e4e2e3dcd9e0e7fe0705f510",
			INIT_28 => X"0d1714e2c8d2e1f8ff0c0af20a06f6eae9eadaebe0e0f5fa000c0a0bfc0afef8",
			INIT_29 => X"10eae6eee2f0edfa08f41407f4fcf4eef0ecf2f2f4f5f7fcf4ede2eff4f2f202",
			INIT_2a => X"d5cecee8fe030604060200f9ecdfe1ed261e191004fcfcede4f3000e1b1c101e",
			INIT_2b => X"0cfdfbf9eff6fefff9140b0e00f4d6e5d8eaf5fb0515fd0efffc00f9f2ede3e9",
			INIT_2c => X"02f9f3dcf500fb0a080d150e260b0a06f9fcf1eed6fe0804070405121a19270c",
			INIT_2d => X"efebf0ff040a0917150ff4e5f2ece7f700fdf60f0df4f5e5dbeff3101818120b",
			INIT_2e => X"0e06f9ecf2dcecef1014160c0b02f8f0e1f2fd000a1618121222170c02fef4f5",
			INIT_2f => X"fd02fa080efbe9f8e8e8fe020c0e060e02f5f7eff1e4e2f7f0e2d9e4ed020903",
			INIT_30 => X"e5e0e8e0f2f0e5dad8ebf807020cfefcf1eceee7f30b122a1601fcf2f6e2fefc",
			INIT_31 => X"2020f8ecede3edfe050d0c02f2eadee1dee7eceae9ecf6fb0b0a0dfa04fafbf1",
			INIT_32 => X"e4e6e0d8ebfcf801080e100c09f9f8e8f3221d160c0cfdfbf2daf4f0f7001116",
			INIT_33 => X"060507060c05f806faf1e3e7cfe5d1f7f0dee7def5fa00f40cfef8e4dcec0206",
			INIT_34 => X"f4030610fe03fcf5f3e5dddcd201f6e5e4edfafc02fe0c0a02f2eee3f8f0eefc",
			INIT_35 => X"f6fee0f4fefa061a20222b030e0e140a01fef8e4eaf0f8050318281d0903f8fd",
			INIT_36 => X"ef0e0bfef4f0e2d8ec04ebeae9e8f90006061406fcf6ebf5f8e6181b0f100200",
			INIT_37 => X"ee0601030c0a19000d0c01fafcf5efe1f102050a1616130ff2e0f0ecf4f9f906",
			INIT_38 => X"ff041216170e1e121206fceefbedfbf7f804130e21080a1b0c0dfb00ecf6f0f2",
			INIT_39 => X"d9e1cdd0ecf4fb02060b0cf20c03f4f6ebf2f4cc1d1311fcf4f3eff6f1f8f2f6",
			INIT_3a => X"0adfd9d8f9f500080df90606fcf9f5e4ecf9050609090b09fefbe3f6f5f9f6e2",
			INIT_3b => X"0aec0602f906fffe000401f0fdf211055604d8080000fcfffaf6fde704fadb1c",
			INIT_3c => X"f3e9fa060ff71206f4ecf0e6eff506fe0a0405ff00fc0308030e0c02d1f4f674",
			INIT_3d => X"f80603020a09f8e4ecd8dcecf1ea01dff1f20607070802eee4dddde0f4fae8ee",
			INIT_3e => X"0afb08070df8efe9f2e6d7dde3f0f9fb1011f20505f3fdfbfe090afcfff5f6f7",
			INIT_3f => X"03fc080804f3f5f7241e0e0ffef3fcf0ecf9ff0b14181a270cdde1e2fef20209",
			INITP_00 => X"00b000c000680000f8007c0500068000078003fe000000f001f7c003c000003f",
			INITP_01 => X"07d000e800340701fdc07e06c0016001a000d0002f8f801800f80d0006c00160",
			INITP_02 => X"00ee0380fbe0fbe07e06c0800781b8005800fe0076001b0005f00680037001b0",
			INITP_03 => X"f014000b03c07e06c00178003e01d800e8003e0701bfe00a1e80034001b83f00",
			INITP_04 => X"001b800dc1f07ff80f80a001dc00ec0017803e001d8006c0037003a000f80000",
			INITP_05 => X"581f8007c0fc1ff80fc0981f85ff03ff80780d2007e0f83f80b00001e06c00f4",
			INITP_06 => X"7fe07f016041f03f03ff81fc74040b80fd00028301f87c07c0f000e8001c07c0",
			INITP_07 => X"b8f01f83b800d8607c023e001b02ebf0b4e35c0983b03f0001ec0e007fc07fd0",
			SIM_DEVICE => "SPARTAN6"
		)
		port map (	
		DIPA => (others => '0'),
		DIA  => (others => '0'),		
		ADDRA(13 downto 3) => adress_A(10 downto 0),
		ADDRA( 2 downto 0) => (others => '0'),
		WEA	=> (others => '0'),
		ENA	=> '1',
		RSTA	=> '0',
		REGCEA=> '0',
		CLKA	=> clk, 
		
		DIB   => (others => '0'),
		DIPB  => (others => '0'),
		ADDRB(13 downto 3) => adress_B(10 downto 0),
		ADDRB( 2 downto 0) => (others => '0'),
		WEB	=> (others => '0'),
		ENB	=> '1',
		RSTB	=> '0',
		REGCEB=> '0',
		CLKB	=> clk,
		
		DOA( 7 downto 0) => out_a_0(7 downto 0),
		DOA(31 downto 8) => zero0(23 downto 0),
		DOPA(0) 			  => out_a_0(8),
		DOPA(3 downto 1) => zero0(26 downto 24),
		
		DOB( 7 downto 0) => out_b_0(7 downto 0),
		DOB(31 downto 8) => zero1(23 downto 0),
		DOPB(0) 			  => out_b_0(8),
		DOPB(3 downto 1) => zero1(26 downto 24)
		
	);

bram_1: RAMB16BWER
		generic map (
			DATA_WIDTH_A => 9, 
			DATA_WIDTH_B => 9, 
			WRITE_MODE_A => "NO_CHANGE",
			WRITE_MODE_B => "NO_CHANGE",
			SIM_COLLISION_CHECK => "WARNING_ONLY",
			--INIT_FILE => "table_memory_data_1.mif",
			INIT_00 => X"f4faf4e2e1e827210efcf4f6f4f7fafaf903ff0606ff02d7d4f1fe04060e07fe",
			INIT_01 => X"f0dffcf6f6e4ebe3e5f10504fe020bfa00fbd9eae2d8efebfa02fe0514050f00",
			INIT_02 => X"d3e1ebe7e8fe06fb0c05dcf2edfae0ede2ee0beedfd2e8f5f3000a0b07f6f8f4",
			INIT_03 => X"06f5f20107120a061d130a0afef5eff604f105faf6fe04fb0604060c0400ece8",
			INIT_04 => X"e2ebfd07020ef20404fd00faf6f0e2fcf0f5eef7ff0910eb0a080afbeef4f3ec",
			INIT_05 => X"def2f8040c08faebf3f9f4f8faf2eee7e5fbf6020c0306fbf8ecdde1f0ded6e3",
			INIT_06 => X"0afdf2f5fdfdfc01ff1c26270d08fff8f2f5f6e2faff0404fe161220f9e8d9fd",
			INIT_07 => X"e8f3ecf2f9fa01000e0b0f160b0d02fbede7fbf6090c121217000c1b28201312",
			INIT_08 => X"05fff6e9dfe3f806ffebf1f7000c12ff09060400edede5d4201b1dfe0701fafa",
			INIT_09 => X"f70a100202e6cedaecf2f4fa00000f0a0800fc03feecfbf203f0f600020d010e",
			INIT_0a => X"dcd8e712060af4f0f2f800e3fef8fffe0c12161a010d0a0a08f8f5f3d1eef2f8",
			INIT_0b => X"f41014000a0900f4f9e4f2fbf8021512160f09f2f600fe080211f007fceef2ec",
			INIT_0c => X"08040808040002e7faeff0f4fdf70d21fffef9efe1f8fc07fa14090002f6f0f6",
			INIT_0d => X"f9fffa00fbeaf2f8f502f60b111cf5010409feeff5ece7f6fefc040916261d10",
			INIT_0e => X"01040ef808070901fdfef5fff3f6fef0f000061406100cfcf7f0f1e8e31d1c10",
			INIT_0f => X"02ec04040d00f8f8fbeee2dcebf800080806070208fe00f2e6e3fedfe3e8f7fe",
			INIT_10 => X"0e10070306f8f6041e16181204fefdfee6f7f4fef4faff0a24ecded9f0f10007",
			INIT_11 => X"f2f3e4f4e6f208170c0907faf7fae4f8fefa04101b120a00e4e9e7efefed04f5",
			INIT_12 => X"eedcf3f8e5e8dff601080a09f10602fffcf2fedce2121604f6f6fe00070a0efa",
			INIT_13 => X"0c1816291e060e02ff01e4f8f2fbf606020110fae8e0ed08fafe0afd0900efe7",
			INIT_14 => X"eaecea04000004040805fe0b05f4f6dadc17100cfdfffaf8f3f0eef900fc0a01",
			INIT_15 => X"0c0602f8fcfcf4eaf7faf2f6070d0ce6f0f80107090c080406060d04fef9f9e5",
			INIT_16 => X"02fd0008eb1105f8f1edeee6fa250e10fefafbfcfef3f1f6fafd00101c0e1016",
			INIT_17 => X"fe08f50a0c0602ebf101fa0a0b0afe0103f5f2f2f3f6f5f5020710121a00f8f8",
			INIT_18 => X"06080808f7f6ece6f4210e060e02f4f8f4f404fe050e0e0d160408f3f7edeaeb",
			INIT_19 => X"eefc0a060a140c2d13121000fcf8f6fdfa040d0c07fef2fcf0f1ecf3f6020609",
			INIT_1a => X"0c12100708d6d6f20206080400fd040a00ffeafcf0e60f070cfcfdfafcf600f3",
			INIT_1b => X"1a192ef1f7f2f1f7010a090504fcf0eae6e0e6fe19081203f6ecf4f0fc050006",
			INIT_1c => X"effce4def3f5fffa02fc0b0a0a08fcfae0eb01100804fc02fcf4fcf3f8fc0112",
			INIT_1d => X"f40a0404020702f4fcf6fafeeeef0decf0daf2f3fc03040afd0a04f6f4f9ecde",
			INIT_1e => X"0801fbf9f6fcf2f6f2f8fe020a1100ecf6ff02fe0c0ef9090705f9f8faf5ecce",
			INIT_1f => X"0408fef0fbfaf0ebedf9fdfae2f1e6f2fc080e0a0703ff08f4e8f3fdf715010c",
			INIT_20 => X"0c0a0904fcfdeeeae3eff1eef8fa0409fe0beb0604fe01e6e8e9e300f7080d0b",
			INIT_21 => X"04f4fef6f7e0f100160a0202eeebff05f6f802f8020c160efee8e0eef5f7fc0a",
			INIT_22 => X"0902eff2dbf320120afefff9eef3f2fafefbfa0a04fe05faf6e8e20202050df7",
			INIT_23 => X"00f4f9eaebf5eff80a0b0a12f80a06fafefcfde2f7e6f6e6f506040108f80801",
			INIT_24 => X"fcf218150c1102fbf6f2f4f5f7fe080c101cfde2e4dee9fbf70002020c07ff00",
			INIT_25 => X"f5f2deebfa01060b0409fcf2f9f2f606f2f800eefafa020a100e0bf6f6f601f8",
			INIT_26 => X"000afefdf6e8edf1f5fc0a0d051ef80c0f09130207fefe07fdfcf0f7fa05080a",
			INIT_27 => X"fcfa040a0b03faf1feecf9f2fbeeeeeee8f2040d04e6fe04f9f8eafae8f00b08",
			INIT_28 => X"f800f204080f02fe04f2e51c17100403f3fdf0e0fc00fefb0c0b1206f0e0eafc",
			INIT_29 => X"f405fffdf2ffece00f18120008f8fef4f1f3f9fe01040b0502100604f203f3f6",
			INIT_2a => X"09fcfee8ebdee8f4d6e4eef1fa0807fb0c04f8faeaece30f161602f9f4020007",
			INIT_2b => X"fc0602fcfbe3f3f8020401060bea0a08060200f2ffeaf6f6f9fcfaff000c0208",
			INIT_2c => X"00f7edfbe6f3f404090c0e010200f7f2eaf4eee8f8ececfafe020a0cf0f9effa",
			INIT_2d => X"08eae8e1f1f9e6fdf00e08040008040205f8dcdcfaf801050709f000f90600fc",
			INIT_2e => X"14090501fefbf3f1fe04ff09120804ff04f8f0f604080e04f5f7fae7f9010610",
			INIT_2f => X"03fefafdf4f2ff04fbf408000015e8d2f8fafe060806fc06fcf607fa06f1e41d",
			INIT_30 => X"e60107f90402feeafe000202fbf4faf8fe04050d0507fe06f8eaecdfe610250d",
			INIT_31 => X"000e04090303ffe2ecdfe6f4e5edf303060603080408f8f4fdf1fa0de9ddf0f0",
			INIT_32 => X"0805faf9f5eff2e7011a140c05fafbf3f5f4fa000909171a0a04120401fafe00",
			INIT_33 => X"0002f8f5eaecf4eaf8eafbf602080c09fbf7ecf0e6f1f6e6d6e4f80003000802",
			INIT_34 => X"eeeef4f9e80112f80500fafbe6fa031019202005ffe6f1f8f9fc06020af4100c",
			INIT_35 => X"f50ee9f20004ecf302fef0040a0606fffadcd8efd8ebfbfff40208f309060001",
			INIT_36 => X"e4f2f2fe0b060c09ff0200fefdf5feeeeb120ef4efebeffe0608060602fcfa00",
			INIT_37 => X"fcdceafaf2fe07020e0401f9fc01f2f2e7fcf6ecfb000bf9040402f4f6eef2f6",
			INIT_38 => X"fcfe0705f9070508fcf8f6e5e40c1910f8ff0a06f6f6f1fefafc020c0b1c0cef",
			INIT_39 => X"f5f4fbf4fc070c0d1a08fee7f6f0f302010408ed070608fff50afc02e7f6ebf1",
			INIT_3a => X"f4f9f0f9010e0e0f18fbfef5e60202ff08020104ecfae6e61502021a07080af8",
			INIT_3b => X"fc020505160d0901dc0d0c0000f8eefaf5fe020a100e0210f90e1d0bf603030a",
			INIT_3c => X"faf0f8f0ea18fff0f8fffefa03f406ff10040a06dbfb2a1b150cfaf600f8f2fb",
			INIT_3d => X"180f0c060c08fdfcf8f1f6e202020b080011fcf2eae902f80410fe0610fcfe0a",
			INIT_3e => X"f0e8e2dcfdedf4f80c0c040404fcf3faf6eafc18120e0504fafbeaf8fef6000c",
			INIT_3f => X"02f4f4f8ee030af90902fdf2e7e8fafcf2e4d6f8fa060506040607f4f3f0e6dd",
			INITP_00 => X"03fe0fff817c03701c001e001da006e09ff0a2fc02c020780036805f03805a1e",
			INITP_01 => X"bc03fa00ef007e07105dc03ffe0301787e07e5d01c20ff80780fd09f810ef0ec",
			INITP_02 => X"5e5d80fcb607003fe00e3ff01fd8700bff41e12c00f6071e03e03f02f9f80183",
			INITP_03 => X"c0007d07c01e2dc07e02076000bc3d03e0f80f07f8fb83823ff07807f07c2fe0",
			INITP_04 => X"3c003903c03df90707c123e23e03c07d80f6007bc3801a1e81f12f01f0035a17",
			INITP_05 => X"813c1d29f05e8f07807f83d681fc007060fbe00f8006c1e740f80ff45e9f04f0",
			INITP_06 => X"03e406e00f6060f94c9e006f06c3f03bc00f001fc0f81ff9fc01fc106c707d07",
			INITP_07 => X"86c007e000f81f03fc0fc2d9040af3c87f783f770f86f0fe07c1ee503707303e",
			SIM_DEVICE => "SPARTAN6"
		)
		port map (	
		DIPA => (others => '0'),
		DIA  => (others => '0'),		
		ADDRA(13 downto 3) => adress_A(10 downto 0),
		ADDRA( 2 downto 0) => (others => '0'),
		WEA	=> (others => '0'),
		ENA	=> '1',
		RSTA	=> '0',
		REGCEA=> '0',
		CLKA	=> clk, 
		
		DIB   => (others => '0'),
		DIPB  => (others => '0'),
		ADDRB(13 downto 3) => adress_B(10 downto 0),
		ADDRB( 2 downto 0) => (others => '0'),
		WEB	=> (others => '0'),
		ENB	=> '1',
		RSTB	=> '0',
		REGCEB=> '0',
		CLKB	=> clk,
		
		DOA( 7 downto 0) => out_a_1(7 downto 0),
		DOA(31 downto 8) => zero0(23 downto 0),
		DOPA(0) 			  => out_a_1(8),
		DOPA(3 downto 1) => zero0(26 downto 24),
		
		DOB( 7 downto 0) => out_b_1(7 downto 0),
		DOB(31 downto 8) => zero1(23 downto 0),
		DOPB(0) 			  => out_b_1(8),
		DOPB(3 downto 1) => zero1(26 downto 24)
		
	);
	
bram_2: RAMB16BWER
		generic map (
			DATA_WIDTH_A => 9, 
			DATA_WIDTH_B => 9, 
			WRITE_MODE_A => "NO_CHANGE",
			WRITE_MODE_B => "NO_CHANGE",
			SIM_COLLISION_CHECK => "WARNING_ONLY",
			--INIT_FILE => "table_memory_data_2.mif",
			INIT_00 => X"fb09090d05070100edf2edfef5faf4fffd0f090004f80d040308f6f6f0def2e6",
			INIT_01 => X"f80601f914060601fbf7f0e1ff1c0c13fbf6fbfae9fb0301050f0d10faf8e9fe",
			INIT_02 => X"0cfd0204f4f1f4ee06f203060702010d02ffe0f0f1f8f8080a0615df01f9f8fb",
			INIT_03 => X"0afffff7e8f2e2f6feecf2f0f9fc050cf4030805f5f0ecebece9edd9f6fc0006",
			INIT_04 => X"00050e04ecfcf1fb07080f07faeb07f8f8fd050d0c05e0f7f1f1e8fa000704f5",
			INIT_05 => X"f9f7e1fd0bfceff50006050802fb060103f5dbe4f1e90b101304fdfff301f6fb",
			INIT_06 => X"05e4f1f2e5e7e7f6f902e9090506030204e5e81604f1f5f4ff080f060905fdf6",
			INIT_07 => X"f2edf0f4f9fc0c10fd0e07fefcf6f4e3eefd030b090501f9f2fbf8f9fe050b10",
			INIT_08 => X"fc01030f0603d8fcfdff02f4f8f2fbf7fc0c0d09fdfcf4f9faf9090c07081918",
			INIT_09 => X"fe0a0905060afcf5efe9e3f9011e17150a09fffbffeff4f9fc0e090c0b0cf0dd",
			INIT_0a => X"f502fc0000ff0b11121c0ceef0f3f602060a0a000204fff6f0f7e8e7f9efecf7",
			INIT_0b => X"f102fcfaf9f1f900fe03010b040b02ffffec0109060bfaf5e6e3fc1c1508ffee",
			INIT_0c => X"fef8f4dfdeeef806fc06000807f4f10cf3f6fb0303081221ecfdf9010b091003",
			INIT_0d => X"0d0a0f0808f5f9eff7f908020600110401f5eaf6fff0fa01ecedf7f6070c0303",
			INIT_0e => X"0b10071411fbf8f203fe060904fefef8f0f20b0514030302fafdf0f8ebf6fb01",
			INIT_0f => X"edfbf1ebeaf2f5050afb04fe06fe0becdbf6db01fe01ff0804070d05fef8f205",
			INIT_10 => X"050aff03f8fafafcf0eef90902131c17f7fcf8000b0a080de8040e0102f7edf8",
			INIT_11 => X"0b03fbf500eafcfdfc020f231b00f6ecfcf6fa060903ff0b0901fae4f80aff0f",
			INIT_12 => X"ff07080406f8fcfee3f2e2f50a1c1f0c04f702f8effa020f050909f61c0e020c",
			INIT_13 => X"fa03f7fffefc0a0509102c0e0a000500f6f9f9fdf6fdfdef00fd0cf7e3e8f0f9",
			INIT_14 => X"0afef6fcfd07f4e5f9f5f1f5f503020cfcff02fee8fc040308110b0b03fefced",
			INIT_15 => X"020513130f18f31d1a110905f9f303fffd060104021809fdf6efee0005060fee",
			INIT_16 => X"fbf30f11ebf9f7e7f800030a00050900fce5dceae7070c150909faf0fcf905fc",
			INIT_17 => X"dae40cf3f6fe07fd05f905070d0c01fceef1eee5e4fbff0a09080600f7fdfbfd",
			INIT_18 => X"1108fdfbf6f2f7f7f2f508020c100e200cf1eaeffe09fff8fb0300070ffff9ed",
			INIT_19 => X"eeeef707070910090103f3fafde9e8ebeeedfcfcf80f06f906ff00f1efe9ebf9",
			INIT_1a => X"080601faf9f9fbf2fa01ff050503fc0e110303fdf1f602f5fd0d0e10f7f9e4f9",
			INIT_1b => X"fc01f702faf303fbfdfe0ffe170c0d02fcfbffeaf7fa03f80512210624191310",
			INIT_1c => X"eefff5fd051307120f0201e6edfdf4fa00ff090c0402f6ebf0e3231f0303fdff",
			INIT_1d => X"03fffc060a0b29edf9feeb0004010af308ff03fbeffff5ea021c050b05f9f9f9",
			INIT_1e => X"f6fffb0015e3eef6f805120e02fcf9fcfe01effaf9ed120204faf2fbf0fffc06",
			INIT_1f => X"f6f1e6fd04fff2f5fa080b090afffd09ecf0e9f4080e07050af4f3fa06fdf2f9",
			INIT_20 => X"f5e9e7dbfa0102030e0203f8fdf3f1e601ecf2ed07f0f8f9f6f9fe0809090afb",
			INIT_21 => X"ebf9f7f6071008f400090a04f902fffefeff101104faf5f301f9f7fc0c110218",
			INIT_22 => X"f5f5fb03071107fff9e7e9e3fbf6151e0e020bfe08f8f2f8f901030b041a06f1",
			INIT_23 => X"f10105100701fb0200f5f209fdfceb02fc090a0604fefdf2ee0102ff15f2f0f8",
			INIT_24 => X"f4e4f6fdfe0d0c030800e6deece80507060cfd04fe03fbfdf7edfbf3f9f4e5f9",
			INIT_25 => X"020109070202f9f81c1612060701fafce4fbfb04040a160401fe04140604fb08",
			INIT_26 => X"fdf6f5eaf3e3eafb02fd070f110b000105fdfff9ffedf3220af8ee07fb02f8fe",
			INIT_27 => X"faf6f4dd18040d04fbf6fbfbf0f0f6f4f905fe0f0aead9f8f2fcf90508f90d08",
			INIT_28 => X"0b2400fafc02fd0a0a09030907edf5ecd6edededf3f7e3f0fcfc05fc07070c05",
			INIT_29 => X"050d0b01ff01f3f403f900fe0b0101150e200d0a01fefbf6fef2f6f6fcfdfc00",
			INIT_2a => X"0c10000301f7eafaf4fc001314150eefe8e9eded01f8020508090d0003eff0fa",
			INIT_2b => X"04fffdf700ff11f3fff9f90b00e8f6ffecf3010e110d00fffa01f90804011100",
			INIT_2c => X"0212ef02e5faecede7ebf1fe1000fdf104070b020405fcf2f1f0e9ed0b02fbfc",
			INIT_2d => X"16f9040d0402f4e3e2fde9f6edfe03020a100603fefdfaedf1ec07faf5fe0103",
			INIT_2e => X"08fcfbf4f7201d0205041306f900fc03ff06f002f6e8dfe1dbea02010709fbff",
			INIT_2f => X"fff5f8f6ed16f2d9e4faff0708ff0608fef5faf4f600260109f4fffd03050af6",
			INIT_30 => X"0bf8fce2f803fdf90afc0500090b06f6f3e9fbdfe5df03070c0107000401f4fb",
			INIT_31 => X"eafdf3fa0000ff0b05061007fdf9eff8faf31a01fefbf4f3fb0bfc05fb010cfa",
			INIT_32 => X"11020f05fefef2f9f8050c0a0109fff0e2eff0f7f8fa0910fc040cfe00f6eff1",
			INIT_33 => X"0b0f06fef6f8f3f90b09030d021a130b07fdf8f8f7f706fff9fc0505fe150b12",
			INIT_34 => X"09f4f8f8f803fc080418011bfd2b140b0bfffffde4f702fa03130505faf50a0b",
			INIT_35 => X"0a04ff00fffbf5e7e7f903f4fa00f8fefcf80bedf8f907060e0811101e100ffb",
			INIT_36 => X"060807faf1f2dbf004010c0606f4fc02faf2010711191b0009f7f0faf0ff070f",
			INIT_37 => X"fdf1fcf9f5110e12140502faf5f7f7fffcfbf4040a1301fbfff5f500ff040111",
			INIT_38 => X"0019150df2f2f3f90007000bf1ff0a02050303edec04fbebf2090c0601fa0dff",
			INIT_39 => X"13fd2c1305fa000300fbf2f2fefefc0bfb121212120bf40a0500f5effb02ff02",
			INIT_3a => X"1d0f07f9f6fcffff03ff0409fe04f1eaf3210d0afbfafb02fdf1ffff0504f50d",
			INIT_3b => X"e4e3e6fbfb030b030bfa0a02f3f5f6e5f2edf7050a09060d02fd0300f5edefec",
			INIT_3c => X"060503feeefafef9fd0f040109f1f8f0eef1f0fd0710050008f9ff09f903f9f0",
			INIT_3d => X"0007e604fe080905fa0006ecfaf707fd0708fd0e1002feffefececf2270d0c18",
			INIT_3e => X"06fa000406fcf10b11fe070805f9000708eb01f7faf1e2ece7f3f3f6e7effafa",
			INIT_3f => X"0100ffff000001f3fbfd03ecfefc06f50004090c0bf4f8f3221302f604f2fcfb",
			INITP_00 => X"03603e07805f987c08fb83c4f0f23c0e80037003b0bf81e86f0703f07f007bc0",
			INITP_01 => X"01aa15f1f8b83f01f83f810f01791f1f417e3c1c5be1fc007c0fc07c7c20703f",
			INITP_02 => X"22be01f0307f07c2fdf27e1e840723f843ff00a0780fa3efc87c1dc5d01f1f78",
			INITP_03 => X"08790f88187843819e1ea0f80fe0bc3c522f02ffe05de2701fc006a0c03f8478",
			INITP_04 => X"0f00581b00bf8194fcfc1fbd07c3d4007d9178681e03e87e0ef4388f07e0881e",
			INITP_05 => X"041b078e87f5503cbc03f023d00cfc0c8a183e5ff83e0bf8f4aff801e5f8002f",
			INITP_06 => X"07e01e17e0f93f83d02423fe85f782f3e0ff8237f07c03680df0305684be03fc",
			INITP_07 => X"ce22f8e8b9bba000d762dc0fe0780f9407b01fb0e0b4710dbb817dc5f0f3e47a",
			SIM_DEVICE => "SPARTAN6"
		)
		port map (	
		DIPA => (others => '0'),
		DIA  => (others => '0'),		
		ADDRA(13 downto 3) => adress_A(10 downto 0),
		ADDRA( 2 downto 0) => (others => '0'),
		WEA	=> (others => '0'),
		ENA	=> '1',
		RSTA	=> '0',
		REGCEA=> '0',
		CLKA	=> clk, 
		
		DIB   => (others => '0'),
		DIPB  => (others => '0'),
		ADDRB(13 downto 3) => adress_B(10 downto 0),
		ADDRB( 2 downto 0) => (others => '0'),
		WEB	=> (others => '0'),
		ENB	=> '1',
		RSTB	=> '0',
		REGCEB=> '0',
		CLKB	=> clk,
		
		DOA( 7 downto 0) => out_a_2(7 downto 0),
		DOA(31 downto 8) => zero0(23 downto 0),
		DOPA(0) 			  => out_a_2(8),
		DOPA(3 downto 1) => zero0(26 downto 24),
		
		DOB( 7 downto 0) => out_b_2(7 downto 0),
		DOB(31 downto 8) => zero1(23 downto 0),
		DOPB(0) 			  => out_b_2(8),
		DOPB(3 downto 1) => zero1(26 downto 24)
		
	);
	
bram_3: RAMB16BWER
		generic map (
			DATA_WIDTH_A => 9, 
			DATA_WIDTH_B => 9, 
			WRITE_MODE_A => "NO_CHANGE",
			WRITE_MODE_B => "NO_CHANGE",
			SIM_COLLISION_CHECK => "WARNING_ONLY",
			--INIT_FILE => "table_memory_data_3.mif",
			INIT_00 => X"090bfb030af0dff600f7f40009f9080400f7f5fdedf62d0808fef7f501fefc01",
			INIT_01 => X"2306ebf9fae9d3f3070606f30304fef4efeafc00fa16040603eff9fbf7020609",
			INIT_02 => X"e5f3eee4eef3020801fd070afeebf3f0f4ffef0ef904fffcf9fcf8f900020d0d",
			INIT_03 => X"0214051505fefbf1f90206060f02e7edf4ebfbfa0109fe07130afafcfc03eee9",
			INIT_04 => X"fc051209fef6ff00f303f0fe040604040cf906f7fbf506faf502f9f8120e1c08",
			INIT_05 => X"02f9f905fef30202121804f8ddedf6f2fe0900060d110100fdf9f7e0f30808ee",
			INIT_06 => X"09140107f403f0f0eef8f9f4f3f4040d000d05050500fafef7e5fef504110a05",
			INIT_07 => X"0900030601f4f3e0fa0b00fe05fcf9faedf4ff07170a0e0412ef0df9f4fe0603",
			INIT_08 => X"fe01eef6f4e1f8fef7fcfe02030b040808071006fcf2e3e7ecf8f00005020b01",
			INIT_09 => X"0902fce2e9e2ec0700050908fb03fb000303fdf207eef7f3fef5010d0e0a04fa",
			INIT_0a => X"e0f6dbdce8f206060303fd08fcf9fc050b00f5fcf4faedfbe3f1f8f0faf90808",
			INIT_0b => X"10effaeaf9fafd080904fffdf8f6efff0df3edef01f6fb0000ff050b080bf6f5",
			INIT_0c => X"0a0708fcfaf7f30101fd130913041709000b000909fbee0bfcf4fc01fe150513",
			INIT_0d => X"0d0500f4f1f5040b0e060209f421021116fdf80201eb02fbfffe01f608ff170e",
			INIT_0e => X"fef4f500fdfe010a220b02ff130b0f06f9fcfb08fcf4f300fd0c0811ff04120a",
			INIT_0f => X"02f9fff0fd0102ff1600fef1e6dde2f7fffcfe050604fe010bfa12fd14060efb",
			INIT_10 => X"0bfcfff7ead3e6f5e5f70004fe02031003060cf8e9e5f2e3f1e2110c0308fbfe",
			INIT_11 => X"0afdff0323071705060601f9f709f3fcfc0dfc06170fedf8feff0007040bf903",
			INIT_12 => X"0202001c08fc01f3fefe03f5f6fef80106010718fb0b0903f9fbf7fb07fdf602",
			INIT_13 => X"110810fe0c040400f5e9fdfbf8f8fb010a1d0d0f050704fcfbeffeeaf90a0503",
			INIT_14 => X"f205f60003070c040908f7fdefebf50bf408ff110702f8e9f5ff05000a040b0a",
			INIT_15 => X"05fe030101f709040604fff1efc51218110701f6f9fffcfaf9000407131904f2",
			INIT_16 => X"010a07ff0b0505fffceee5d3fc101709fe01f7fae8fa00f80a0c140801000200",
			INIT_17 => X"07f503fdfdf3f507fa06150912fffbf8f7ff00fbf702fd14031002f1fd01f903",
			INIT_18 => X"070cfcf4f3f9ec01fffdfbf1f4fd0603fe0e0705fdf3fa01f8fdeae9e400ff07",
			INIT_19 => X"fff801fafa0b0ef5fefdf6fe090b040f050300f8edebfefcfef7e3fafbfd0701",
			INIT_1a => X"0c12160506160e1108fdfdf8f0f800fd0406130a09e8e5f2ebf8fe0702050506",
			INIT_1b => X"f3fceff7eae9030dfb05040904faeffdf3fff91d00090bfc0005fbeef7ff0608",
			INIT_1c => X"e2d9eef705fffc07f700080af6f4f2e3fbe8f3e8dbfdf00308f407030003f2ea",
			INIT_1d => X"060b1505fdf6edfdfbfe090c0d14f60c1f060c05fdfb00dd00f7fb0107070a19",
			INIT_1e => X"08f6fbf906f4f0f9faf7020b0ef4f0e2f0f2fbff06020e0300fb04f700e50307",
			INIT_1f => X"f9f901f5f90602170e06131b1408060005fdf4f8f8eff4fc010908061609fd09",
			INIT_20 => X"04fb03fef6f00a192906fb09fef601fbfb000e010cf2eeefeafafde30d080c05",
			INIT_21 => X"f5ecf1eee5edf6fcf3e0ebf5f50109fe020a02f8f6f2e7f30a09100102fbfef9",
			INIT_22 => X"fcfd0c040bf8eff70102fd00f60e000a0df505f6efe5fc0700ff00070511f0fc",
			INIT_23 => X"f6eff01a10130cfef7fcfff8f8f8060305120e120cf808fa04fafe0d05fbf3f9",
			INIT_24 => X"f61e12000a03f6f1f7fdf5f6fefbfc090d09020cf201000c0703f005fd06f6ec",
			INIT_25 => X"fc0f0202f4ff01f7fa01fffb110f140a08f9feee03ff0810fc0400fc02f1f801",
			INIT_26 => X"f2fa07fc090c0afdfbf7e7f9070c200efbfafe050400f806f8f905ece2061114",
			INIT_27 => X"fdfb02fef5effffb050d122ce2e4f80707f9080506fd0bfd00f3f301e3e3f3f8",
			INIT_28 => X"f4f1f8f003f70003f4f0e5effdfc0701060efb0903060107fffdee0804000a01",
			INIT_29 => X"faf7faf9ff080c13f9f0eafbfe04080df503fe0204faeafbfd0e080c0601f0fd",
			INIT_2a => X"01fb04fe010704f2eeddf0f804050d0501fcffe6e8e8000a19080ef804fd07e1",
			INIT_2b => X"ebf9f0e7fadef304f3090304fb0109fbf6edf9eaed040b0c0c04ffebfbf4f4fb",
			INIT_2c => X"150f190a0bfefdf8f3f9f3fef50d02fdff0b19f1f7f8e9f9fc040afb0802fcfb",
			INIT_2d => X"0113191501fdfef900f9fcfbfd0c1311060c06f702fbfafcf5f9f9fc03061803",
			INIT_2e => X"f7eff10a0407fef9fbf80707080510f1f6faf9fa020905f60a0002fdebe3ebeb",
			INIT_2f => X"03f8fcf8f500f705000a210800d9e706fbfbff02060f030307fbfcf9f4e8deee",
			INIT_30 => X"000a000301f5f3dfee0309e9fae3fe0ffa05fc01ff0a0d03f4f1fff905191808",
			INIT_31 => X"0e09f4e8dce6f9e7e5011f150a05faf3f60800fb0105110d05faebf8f5f3fc03",
			INIT_32 => X"02fcfcfff700f00807ff01fffdfd01eff3f700f806130f1d0b04fff8ff02000b",
			INIT_33 => X"fefeebe7ddf6eff9f70200020c00090006fc03ecf104e5f7effb06fc040afb0c",
			INIT_34 => X"edefeef2f2f7f20900ff0601010308faf7ded2f5e0fbfdf403fefc050f0a0900",
			INIT_35 => X"fa0f1f10040003f8f801fa0501060c1216001af009fefff60407ef0705f9f6ff",
			INIT_36 => X"fbfaffff000408ea070908f7f4f1efdae7f2f0f1f601000a030b0d0406fffaf5",
			INIT_37 => X"0207020e060f0ffdeff9fb0403effe0f0501fa03fe0103050301fd07e6d1ebed",
			INIT_38 => X"ee01f9ff04060407000002f6d7f8f3010e08fc0bf901f905fefa05fffdeffeef",
			INIT_39 => X"08d90606fbfa06f0fbe70bfcf7050c0308f6f2f9080df40af3e6ebe3e7dcd2e5",
			INIT_3a => X"07faf4f6f0f5ee0104fdfbeefe04070af40501fdfd09fdf4dce2f2fc00000504",
			INIT_3b => X"03f9f3e80200fa07e9f7fefa0303ec0b04fdf300ebf304fdfe00070c09f60608",
			INIT_3c => X"10fa0ae01209120506fafdf4fbf608fb07090b1208faf6ecf90502fe01080709",
			INIT_3d => X"f6ed00e4edf8fd0600f8fc0a0e06fcfcf3f8e1f3f6fbf9f7060202e806070a0a",
			INIT_3e => X"f7f0f204f7040b06f3080400fcefebf3faf4fc0605fd04fe0df40002fae008fd",
			INIT_3f => X"f4f9f607070d0402fffafafa02fefbf9ebf3fafd080c0df9fdfafbf4fcfd06fc",
			INITP_00 => X"f8681fa3f403fc0f93e07f06714fa24ff87c0dc403b0140fc0ec1787d89b8389",
			INITP_01 => X"86c01dae13ef1177e3f79a2be1bff91781c089bc03d1c003c1f5c83e401ff01f",
			INITP_02 => X"a17825e5ee0742ffbbc3e07e5fc15c3fef01fe07fa21f7099fe45c3d8037e03c",
			INITP_03 => X"27ff80fd88380fabf03df29f097001bc03781ec3ff82f81f260fe003c1037105",
			INITP_04 => X"20f1ba902e0f1d27724f8b697c01f7d41e03fa9838d7a1bc0006e0f8a3d2780f",
			INITP_05 => X"85f91f801c3e0ee0f887e80ff806606c017607c0ae0f83ea0707587c0b03df1f",
			INITP_06 => X"fe19d7d00ee007f87e5fe8d801be009f007fa42d85a22fc7c07c6f81f861570f",
			INITP_07 => X"1f080e0217701ab2219c00efaf82f86f8d0d927b8187640fb2278d004fe1d520",
			SIM_DEVICE => "SPARTAN6"
		)
		port map (	
		DIPA => (others => '0'),
		DIA  => (others => '0'),		
		ADDRA(13 downto 3) => adress_A(10 downto 0),
		ADDRA( 2 downto 0) => (others => '0'),
		WEA	=> (others => '0'),
		ENA	=> '1',
		RSTA	=> '0',
		REGCEA=> '0',
		CLKA	=> clk, 
		
		DIB   => (others => '0'),
		DIPB  => (others => '0'),
		ADDRB(13 downto 3) => adress_B(10 downto 0),
		ADDRB( 2 downto 0) => (others => '0'),
		WEB	=> (others => '0'),
		ENB	=> '1',
		RSTB	=> '0',
		REGCEB=> '0',
		CLKB	=> clk,
		
		DOA( 7 downto 0) => out_a_3(7 downto 0),
		DOA(31 downto 8) => zero0(23 downto 0),
		DOPA(0) 			  => out_a_3(8),
		DOPA(3 downto 1) => zero0(26 downto 24),
		
		DOB( 7 downto 0) => out_b_3(7 downto 0),
		DOB(31 downto 8) => zero1(23 downto 0),
		DOPB(0) 			  => out_b_3(8),
		DOPB(3 downto 1) => zero1(26 downto 24)
		
	);

end Behavioral;

