----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use work.data_types.all;		-- my data types

entity lbp is
	port(
		CLK 		: in std_logic;
		LBPMASK 	: in std_logic_vector(2 downto 0);
		
		DATA_IN	: in dsp_out;
		
		DATA_OUT	: out std_logic_vector(6 downto 0)
	);
end lbp;

architecture Behavioral of lbp is

	signal clasical_lbp	: std_logic_vector(7 downto 0);
	signal lbp_mask_next	: std_logic_vector(2 downto 0);
	
begin
	
	lbp: process (CLK, DATA_IN)
	begin
		--porovname okoli středního pixel se středním pixelem
		-- 7 downto 0
		-- 7 6 5
		-- 0   4
		-- 1 2 3
		if( CLK'event and CLK = '1') then
				if DATA_IN(4) < DATA_IN(3) then clasical_lbp(0) <= '1'; else clasical_lbp(0) <= '0';end if;--1
				if DATA_IN(4) < DATA_IN(6) then clasical_lbp(1) <= '1'; else clasical_lbp(1) <= '0';end if;--2
				if DATA_IN(4) < DATA_IN(7) then clasical_lbp(2) <= '1'; else clasical_lbp(2) <= '0';end if;--3
				if DATA_IN(4) < DATA_IN(8) then clasical_lbp(3) <= '1'; else clasical_lbp(3) <= '0';end if;--4
				if DATA_IN(4) < DATA_IN(5) then clasical_lbp(4) <= '1'; else clasical_lbp(4) <= '0';end if;--5
				if DATA_IN(4) < DATA_IN(2) then clasical_lbp(5) <= '1'; else clasical_lbp(5) <= '0';end if;--6
				if DATA_IN(4) < DATA_IN(1) then clasical_lbp(6) <= '1'; else clasical_lbp(6) <= '0';end if;--7
				if DATA_IN(4) < DATA_IN(0) then clasical_lbp(7) <= '1'; else clasical_lbp(7) <= '0';end if;--8
				
				lbp_mask_next<= LBPMASK;
		end if;
	end process;
	
	-- odstraníme maskovací bit
	mask: process(CLK, clasical_lbp)
	begin
		if( CLK'event and CLK = '1') then
			case lbp_mask_next is
				when "000" => DATA_OUT <= clasical_lbp(6 downto 0);
				when "001" => DATA_OUT <= clasical_lbp(7)&clasical_lbp(5 downto 0);
				when "010" => DATA_OUT <= clasical_lbp(7 downto 6)&clasical_lbp(4 downto 0);
				when "011" => DATA_OUT <= clasical_lbp(7 downto 5)&clasical_lbp(3 downto 0);
				when "100" => DATA_OUT <= clasical_lbp(7 downto 4)&clasical_lbp(2 downto 0);
				when "101" => DATA_OUT <= clasical_lbp(7 downto 3)&clasical_lbp(1 downto 0);
				when "110" => DATA_OUT <= clasical_lbp(7 downto 2)&clasical_lbp(0);
				when "111" => DATA_OUT <= clasical_lbp(7 downto 1);
				when others => DATA_OUT <=clasical_lbp(7 downto 1);
			end case;
		end if;
	end process;


end Behavioral;

