----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------



library IEEE;
use IEEE.STD_LOGIC_1164.all;
use STD.textio.all;

package data_types is

type array_6x6b is array (5 downto 0) of std_logic_vector(5 downto 0);
type array_8x6x6b is array (7 downto 0) of array_6x6b;
type array_6x6x6b is array (5 downto 0) of array_6x6b;
type array_4x6x6b is array (3 downto 0) of array_6x6b;
type array_12x36b is array (11 downto 0) of std_logic_vector(35 downto 0);
type array_4x36b is array (3 downto 0) of std_logic_vector(35 downto 0);
type array_6x36b is array (5 downto 0) of std_logic_vector(35 downto 0);
type array_12_9b is array (11 downto 0) of std_logic_vector(8 downto 0);
type array_13_int is array(0 to 12) of integer; 
type dsp_out 	is array (8 downto 0) of std_logic_vector (5 downto 0);


type mem_mode is (FEATURE, SCALE_IN, SCALE_OUT, WRITE_DATA);
type dsp_mode is (DSP_1x1,DSP_1x2,DSP_2x1,DSP_2x2);
type feature_mode is (F_LRD, F_LRP, F_LBP, F_NO);

procedure read_v1d(file f: text; v: out std_logic_vector);
 

end data_types;

package body data_types is 

procedure read_v1d(file f: text; v: out std_logic_vector) is
	variable buff: line; variable c: character;
begin
	readline(f, buff); -- complete line is read into buffer buf
	for i in v'range loop
		read(buff, c);
		case c is
			when 'X' => v(i) := 'X';
			when 'U' => v(i) := 'U';
			when 'Z' => v(i) := 'Z';
			when '0' => v(i) := '0';
			when '1' => v(i) := '1';
			when '-' => v(i) := '-';
			when 'W' => v(i) := 'W';
			when 'H' => v(i) := 'H';
			when 'L' => v(i) := 'L';
			when others => v(i) := '0';
		end case;
	end loop;
end procedure read_v1d;


end data_types;
