----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity convert12x8to12x6 is
port(
		clk 			: in std_logic;
		reset			: in std_logic;
		
		-- vstup
		in_data		: in std_logic_vector(31 downto 0);
		in_enable	: in std_logic;
		
		-- vystup
		out_data		: out std_logic_vector(71 downto 0);
		out_valid	: out std_logic
		
	);
end convert12x8to12x6;

architecture Behavioral of convert12x8to12x6 is

signal reorder_mem, reorder_mem_next : std_logic_vector(71 downto 0);

-- ridici automat
type state_type is (st1, st2, st3);
signal state, next_state : state_type;

signal out_valid_next : std_logic;

begin

SYNC_PROC_IN: process (clk, next_state, reorder_mem_next, out_valid_next)
   begin
      if (clk'event and clk = '1') then
         if (reset = '1') then
            state <= st1;
				reorder_mem <= (others => '0');
         else
            state <= next_state;
				reorder_mem <= reorder_mem_next;
				out_valid <= out_valid_next;
				out_data <= reorder_mem_next;
         end if;        
      end if;
   end process;

OUTPUT_DECODE_IN: process (state, in_enable, reorder_mem, in_data)
   begin		
	
		reorder_mem_next <= reorder_mem;
		out_valid_next	<= '0';
		
      case (state) is			
         when st1 =>
				if in_enable = '1' then 
					reorder_mem_next(23 downto 18) <= in_data(31 downto 26);
					reorder_mem_next(17 downto 12) <= in_data(23 downto 18);
					reorder_mem_next(11 downto  6) <= in_data(15 downto 10);
					reorder_mem_next( 5 downto  0) <= in_data( 7 downto  2);
				end if;
         when st2 =>
				reorder_mem_next(47 downto 42) <= in_data(31 downto 26);
				reorder_mem_next(41 downto 36) <= in_data(23 downto 18);
				reorder_mem_next(35 downto 30) <= in_data(15 downto 10);
				reorder_mem_next(29 downto 24) <= in_data( 7 downto  2);
			when st3 =>
				reorder_mem_next(71 downto 66) <= in_data(31 downto 26);
				reorder_mem_next(65 downto 60) <= in_data(23 downto 18);
				reorder_mem_next(59 downto 54) <= in_data(15 downto 10);
				reorder_mem_next(53 downto 48) <= in_data( 7 downto  2);
				out_valid_next	<= in_enable;
			when others =>
      end case;  
   end process;

NEXT_STATE_DECODE_IN: process (state, in_enable)
   begin
	
      next_state <= state;
		
      case (state) is
         when st1 =>	
				if in_enable = '1' then
					next_state <= st2;
				end if;
         when st2 =>
				if in_enable = '1' then
					next_state <= st3;
				end if;			
			when st3 =>
				if in_enable = '1' then
					next_state <= st1;
				end if;
			when others =>
      end case; 
	end process;


end Behavioral;

