#ifndef _LIBPCLINES_H
#define _LIBPCLINES_H

/********************************************************/
/* defines                                              */
/********************************************************/
#ifndef max
    #define max( a, b ) ( ((a) > (b)) ? (a) : (b) )
#endif

#ifndef min
    #define min( a, b ) ( ((a) < (b)) ? (a) : (b) )
#endif

#ifndef sgn
    #define sgn( a ) ( ((a) > 0) ? 1 : ( ((a) < 0) ? -1 : 0 ) )
#endif

#ifndef HALF_PI
    #define HALF_PI (M_PI/2.)
#endif

#ifndef QUARTER_PI
    #define QUARTER_PI (M_PI/4.)
#endif

/********************************************************/
/* structures                                           */
/********************************************************/
typedef struct PCpoint
{
    int x;
    int y;
}PCpoint;

typedef struct PCpoint32F
{
    float x;
    float y;
}PCpoint32F;

typedef struct PCline
{
    float rho;
    float angle;
}PCline;

typedef struct ImageData8U
{
    unsigned char *data;
    unsigned int width;
    unsigned int height;
}ImageData8U;

typedef struct ImageData32S
{
    long int *data;
    unsigned int width;
    unsigned int height;
}ImageData32S;

typedef struct ImageData32F
{
    float *data;
    unsigned int width;
    unsigned int height;
}ImageData32F;


typedef struct SpaceParameters
{
    int distance;
    int vertical_offset;
    float scale;
}SpaceParameters;

/********************************************************/
/* prototypes                                           */
/********************************************************/
#ifdef __cplusplus
extern "C" {
#endif

void getEdgePoints(PCline *line, unsigned int image_width, unsigned int image_height, PCpoint *A, PCpoint *B);
int pcLinesStandard(ImageData8U *inputImg, PCline *line, unsigned int lineCount, unsigned int spaceW, unsigned int spaceH, unsigned int threshold, unsigned int local_max_radius);
int pcLinesStandardWeighted(ImageData8U *inputImg, PCline *lines, unsigned int lineCount, unsigned int spaceW, unsigned int spaceH, unsigned int threshold, unsigned int local_max_radius);
int pcLinesEdgeOrientation(ImageData32F *gradientImg, ImageData8U *maskImg, PCline *lines, unsigned int lineCount, float estimation_radius, unsigned int spaceW, unsigned int spaceH, unsigned int threshold, unsigned int local_max_radius);
int pcLinesStandardParallel(ImageData8U *inputImg, PCline *lines, unsigned int line_count, unsigned int spaceW, unsigned int spaceH, unsigned int threshold, unsigned int local_max_radius, int num_threads);

#ifdef __cplusplus
	   }
#endif

#endif
