#ifndef CALIB_CALIBRATION_UNIT_H
#define CALIB_CALIBRATION_UNIT_H

#include "Calibration\Projector.h"

using namespace std;
using namespace CALIB;

namespace CALIB
{	
	class CalibrationUnit
	{
		public:
			CalibrationUnit(int projectorsCount,int projectorsInRow,int width,int height);
			~CalibrationUnit();	

			void CalculateHomographyDisplay(int projectorIndex,CvMat* displayPoints,CvMat* projectorPoints);
			CvMat *  GetPoints(int projectorIndex,int coordSystem);
			CvMat *  TransformPoints(int projectorIndex,int homogType,CvMat * points);
			CvMat *  GetHomography(int projectorIndex ,int type, bool as4x4 = false);
			std::vector<CvMat*> * GetAdjacentProjectroHomographies(int projectorIndex);
			bool CalibrateDisplay(int baseProjectorIndex = 0);
			/**
			 * Calculates overlap polygons between all projectors.
			 * Calculates camera-projector homography from overlapping points
			 */
			bool CalculateOverlapPolygons();
			Projector * GetProjector(int index);
			void calculateHomography(vector<geometry::Vector2Df> * srcPlanePoints, vector<geometry::Vector2Df> * dstPlanePoints,int homographyType,int projectorIndex);
		protected:
			vector<Projector*> projectors;
			Projector* display;
			int count;
			int cols;
			int rows;

			void addProjector(Projector * projector)	{ this->projectors.push_back(projector); }
			/**
			 * p1 Projector #1 index.
			 * p2 Projector #2 index.
			 * h12 Homography from projector 1 to 2
			 */
			void calculatePPHomography(int p1,int p2,CvMat * h12);
			void calculatePDHomography(int pIndex);
			void calculateHomography(CvMat* srcPlanePoints, CvMat* dstPlanePoints,int homographyType,int projectorIndex);
	};
}; 

#endif
		
