#!/bin/bash 
if [ "$#" == "0" ]; then
  echo "Error: no arguments supplied."
  echo " -b 	 compilation to resulting binary (almost always needed)"
  echo " -a SOURCE	 set source file name to be accelerated, just one file is supported currently"
  echo " -u 	 disable acceleration (for accelerated file)"
  echo " -m SOURCE 	 process OpenMP pragmas with rose compiler (for accelerated file)"
  echo " -l	 no loop extract (for accelerated file)"
  echo " -s SOURCE 	 additional sources to be linked together, multiple files are allowed "
  echo " -o FILE	resulting output binary file name"
  echo " -f STRING	flags to all C compilers"
  echo " -C STRING	flags to microblaze C compiler"
  echo " -L STRING	flags linker"
  exit 1
fi

# only for testing, do not commit uncommented
#export RAVAC_BASE_PATH="/home/wizzard/edkdsp"
export RAVAC_BASE_PATH="/home/ihusar/lissom/cvs/edkdsp"
export JDK_PATH=/usr/lib/jvm/java-1.7.0-openjdk-1.7.0.9/jre/lib/i386/server/

if [ "$RAVAC_BASE_PATH" == "" ]; then
	echo "Error: environment variable RAVAC_BASE_PATH was not set. Must contain absolute path to the directory containing the to ravac directory"
	exit 1
fi   

if [ "$JDK_PATH" == "" ]; then
	echo "Error: environment variable JDK_PATH was not set. Must contain absolute path to the directory containing the Java JDK, e.g. /usr/lib/jvm/java-1.7.0-openjdk-1.7.0.9/jre/lib/i386/server/"
	exit 1
fi  

AUTOGEN_TMP_SOURCE_PATH=$RAVAC_BASE_PATH/autogen_tmp
#LLVM_BIN_PATH=$RAVAC_BASE_PATH/llvm_install/bin/
LLVM_BIN_PATH=$RAVAC_BASE_PATH/llvm_obj/Debug+Asserts+Checks/bin/

#add microblaze tools to path
PATH=$PATH:$RAVAC_BASE_PATH/microblaze_gcc/tools/linux-i386/microblaze-uclinux-tools/bin/
PATH=$PATH:$RAVAC_BASE_PATH/pb-toolchain/
PATH=$PATH:$RAVAC_BASE_PATH/utia-pblaze-cc-2.1.0/bin/

#--save-temps
#FLOAT_FLAGS="-mno-xl-soft-mul -mhard-float"
FLOAT_FLAGS=""
MICROBLAZE_INCLUDES=" -I $AUTOGEN_TMP_PATH/api/12-mb-petalinux/libbce_step4 -I $RAVAC_BASE_PATH/libs/xomp/ -I $RAVAC_BASE_PATH/libs/gomp/libgomp" 
MICROBLAZE_CFLAGS=" -O3 -std=c99 $FLOAT_FLAGS -mcpu=v7.30.b -Wall -DLINUX -I $AUTOGEN_TMP_SOURCE_PATH/api/12-mb-petalinux/libwal $MICROBLAZE_INCLUDES "


MICROBLAZE_LDFLAGS="-lm -L $AUTOGEN_TMP_SOURCE_PATH/api/12-mb-petalinux/libbce_config_step4 -L $AUTOGEN_TMP_SOURCE_PATH/api/12-mb-petalinux/libwal -lwal -lbce_config -lpthread "

CLANG_CFLAGS="-I /usr/lib/gcc/i686-linux-gnu/4.6/include "

CLANG_HOST_TRIPLE="-ccc-host-triple i386-unknown-linux-gnu"

ACC_SRC=""
ADD_SRCS=""
OMP_SRC=""
OUT_FILE=""

#DO_LOOP_TRANSFORM="0"
DO_OPENMP_TRANSFORM="0"


err2="1"
opt="1"
opt2="1"

while getopts "s:lbua:o:f:m:C:L:"  OPTION # 2>/dev/null  
  do
  case $OPTION in
  a) ACC_SRC="$OPTARG" err2="0"
		;;
  l) opt="2" 
     echo "loop extract triggered"     
    	;; #loop isolation into functions
  b) opt2="2" 
        ;; #back to C
  u) opt2="3"
        ;; #testing compilation without acceleration
  s) ADD_SRCS+="$OPTARG "
		;;
  o) OUT_FILE="$OPTARG "
		;;
  f) USER_FLAGS=" $OPTARG "
		;;
  m) DO_OPENMP_TRANSFORM="1"
  	 OMP_SRC="$OPTARG"
		;;
  C) ADD_CFLAGS=" $OPTARG"
  		;;
  L) ADD_LDFLAGS=" $OPTARG"
  		;;

  \?) err="1"
		echo "?" 

		;;
  :)  err= "1" 
		echo ":" 

		;; 
  esac
done 
	
if [ "$err2" == "1" ]; then
	echo "Input file was not set"
	exit 1
fi  

if [ "$OUT_FILE" == "" ]; then
	echo "Output file was not set"
	exit 1
fi

MICROBLAZE_CFLAGS+=$USER_FLAGS
MICROBLAZE_CFLAGS+=$ADD_CFLAGS
MICROBLAZE_LDFLAGS+=$ADD_LDFLAGS
CLANG_CFLAGS+=$USER_FLAGS

echo "---MICROBLAZE_CFLAGS--"
echo $MICROBLAZE_CFLAGS
echo "---MICROBLAZE_LDFLAGS--"
echo $MICROBLAZE_LDFLAGS

#compile unoptimized sources
ADD_OBJS=""
echo "compiling additional files: $ADD_SRCS "
for FILE in $ADD_SRCS 
do
	OBJECT=`echo $FILE | sed -e 's/.*\/\(.*\)\.c.*/\1/g'`.o
	microblaze-uclinux-gcc $MICROBLAZE_CFLAGS -c -o $OBJECT  $FILE || exit 1
	ADD_OBJS+="$OBJECT "
done

	
#echo "---ADD_OBJS--"
#echo $ADD_OBJS


ACC_NAME=`echo $ACC_SRC | sed -e 's/.*\/\(.*\)\.c.*/\1/g'`
OMP_NAME=`echo $OMP_SRC | sed -e 's/.*\/\(.*\)\.c.*/\1/g'`

# first clean previous files and prepare needed files in autogen_tmp directory
AUTOGEN_TMP_PATH=`pwd`/autogen_tmp
rm -f -R $AUTOGEN_TMP_PATH
echo "cp -p -r $AUTOGEN_TMP_SOURCE_PATH/ . || exit 1"
cp -p -r $AUTOGEN_TMP_SOURCE_PATH/ . || exit 1

OMP_LIBS=""

# usage of rose compiler
if [ "$DO_OPENMP_TRANSFORM" == "1" ]; then
	#needs some paths to be set
	export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$RAVAC_BASE_PATH/rose/install/lib:$RAVAC_BASE_PATH/rose/rose_install_libs/lib:$RAVAC_BASE_PATH/rose/rose_libs:$RAVAC_BASE_PATH/rose/libboost_1_46_1_ub32/:$JDK_PATH

	FRONTEND_FLAGS=""
	if [ "$DO_LOOP_TRANSFORM" == "1" ] ; then
		FRONTEND_FLAGS="--transform_loops "
	fi
	if [ "$$DO_OPENMP_TRANSFORM" == "1" ] ; then
		FRONTEND_FLAGS="--translate_openmp "
	fi

	$RAVAC_BASE_PATH/rose/asvp_frontend/asvp_frontend --translate_openmp  $FRONTEND_FLAGS $OMP_SRC -o rose_$OMP_SRC.c || exit 1

	OMP_SRC=rose_$OMP_SRC.c
	OMP_NAME=rose_$OMP_NAME
	OMP_LIBS="$RAVAC_BASE_PATH/libs/xomp/xomp.o -L $RAVAC_BASE_PATH/libs/gomp/libgomp -lgomp -lpthread $RAVAC_BASE_PATH/libs/builtins/builtins.c"
	microblaze-uclinux-gcc $MICROBLAZE_CFLAGS -c -o $OMP_NAME.o  $OMP_SRC || exit 1
fi



if [ "3" -eq $opt2 ]; then #direct compilation for microblaze - no difference between -s and -a
      
	microblaze-uclinux-gcc $MICROBLAZE_CFLAGS -DRAVAC_UNACCELERATED -c -o $ACC_SRC.o  $ACC_SRC || exit 1

	#link
	echo "Final link command: ---- "
	echo " microblaze-uclinux-gcc $MICROBLAZE_CFLAGS $ACC_SRC.o $OMP_NAME.o $ADD_OBJS $MICROBLAZE_LDFLAGS -o $OUT_FILE"
	echo " ---------- "
	microblaze-uclinux-gcc $MICROBLAZE_CFLAGS $ACC_SRC.o $ADD_OBJS $OMP_NAME.o $MICROBLAZE_LDFLAGS $OMP_LIBS -o $OUT_FILE  || exit 1

	echo "*** Resulting binary without optimizations was generated as $OUT_FILE ***"
	#cp ${arg1:0:(-2)} /tftpboot
	exit 0
fi


# from here on, the compilation using RAVAC begins

# process vectorize pragmas
echo "Preprocessing for pragma handling"
# must be preprocessed with microblaze compiler
microblaze-uclinux-gcc -std=c99 -E -P $ACC_SRC > $AUTOGEN_TMP_PATH/prep_$ACC_SRC || exit 1
echo "Running pragma handling"
$RAVAC_BASE_PATH/pragma_handler/pragma_handler $AUTOGEN_TMP_PATH/prep_$ACC_SRC -t $AUTOGEN_TMP_PATH/mb_$ACC_SRC -f $AUTOGEN_TMP_PATH/ravac_$ACC_SRC || exit 1

#and now begin compilation
#FIXME - target for clang has little endianess, microblaze has big
$LLVM_BIN_PATH/clang -I. -O1 -emit-llvm -fno-inline-functions $CLANG_HOST_TRIPLE -S $AUTOGEN_TMP_PATH/ravac_$ACC_SRC -o $AUTOGEN_TMP_PATH/$ACC_NAME.ll $CLANG_CFLAGS || exit 1

$LLVM_BIN_PATH/clang $AUTOGEN_TMP_PATH/link/manager_empty.c -emit-llvm $CLANG_HOST_TRIPLE -S -o $AUTOGEN_TMP_PATH/out.ll $CLANG_CFLAGS  || exit 1

echo "empty manager processed"
$LLVM_BIN_PATH/llvm-as $AUTOGEN_TMP_PATH/out.ll  || exit 1
$LLVM_BIN_PATH/llvm-as $AUTOGEN_TMP_PATH/$ACC_NAME.ll  || exit 1

# todo - is this safe? same input and outpt file
$LLVM_BIN_PATH/llvm-link $AUTOGEN_TMP_PATH/out.bc $AUTOGEN_TMP_PATH/$ACC_NAME.bc -o $AUTOGEN_TMP_PATH/$ACC_NAME.bc  || exit 1
echo "linking original .ll with manager declarations"

$LLVM_BIN_PATH/llvm-dis $AUTOGEN_TMP_PATH/$ACC_NAME.bc  || exit 1

if [ "2" -eq $opt  ]; then 
	$LLVM_BIN_PATH/opt $AUTOGEN_TMP_PATH/$ACC_NAME.ll -o $AUTOGEN_TMP_PATH/$ACC_NAME.ll  -loop-extract -S  || exit 1 #loop extraction -mem2reg-lcssa-
    echo "loop extract,SE,iv + loop simplify, mem2reg passes ready "
fi 

echo "canonic, loopsimpl, mem2reg"
$LLVM_BIN_PATH/opt $AUTOGEN_TMP_PATH/$ACC_NAME.ll -o $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.ll -mem2reg  -loop-simplify -indvars -scalar-evolution -enable-iv-rewrite -S || exit 1 #canonicalization,-lcssa loop simplification


#~/edkdsp/llvm_obj/Debug+Asserts+Checks/bin/opt -load=./LLVMPhiToSelect.so -compact-short-evaluation $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.ll -S -o $AUTOGEN_TMP_PATH/${ACC_NAME}_pass_phi.ll 
echo "acceleration pass"
echo "generating firmwares"
echo "integration of manager"
echo "generating firmware include header"
echo "$LLVM_BIN_PATH/opt -load=LLVMAcc.so -acc $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.ll > $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.bc"
echo "RUNNING: $LLVM_BIN_PATH/opt -load=LLVMAcc.so -acc $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.ll > $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.bc"
$LLVM_BIN_PATH/opt -load=LLVMAcc.so -acc $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.ll > $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.bc  || exit 1 #2> /dev/null

echo "regenerating .ll source file"
$LLVM_BIN_PATH/llvm-dis $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.bc  || exit 1


#compilation into C
if [ "2" -eq $opt2 ];  then
	
	echo "recompiling to C"
	$LLVM_BIN_PATH/llc $AUTOGEN_TMP_PATH/${ACC_NAME}_pass.ll -march=c -o $AUTOGEN_TMP_PATH/${ACC_NAME}_recomp.c || exit 1
    echo "recomp succesfull### beginning pb firmware compilation ###"
      
    #scan for generated firmwares 
    cd $AUTOGEN_TMP_PATH
	#ls fw_*.c > /dev/null 2> /dev/null
	
	if [ "`ls fw_*.h 2> /dev/null`" == "" ]; then
		echo "*** No suitable for-loop was found in the source file $ACC_NAME, aborting compilation. For unaccelerated compilation, please rerun this application with option -u ***"
		exit 1
	fi
	   
	
    for f in fw_*.c ; do
                echo "******** generating firmware"
		echo $f
		echo "pbcc run"
		
		echo "$RAVAC_BASE_PATH/utia-pblaze-cc-2.1.0/bin/pblaze-cc -mcpu=pb3a $f -I $RAVAC_BASE_PATH/autogen_tmp/api/20-pb-firmware/include -L $RAVAC_BASE_PATH/autogen_tmp/api/20-pb-firmware/lib-pb3a -lbce -o ${f:0:(-2)}.elf"
		$RAVAC_BASE_PATH/utia-pblaze-cc-2.1.0/bin/pblaze-cc -mcpu=pb3a $f -I $RAVAC_BASE_PATH/autogen_tmp/api/20-pb-firmware/include -L $RAVAC_BASE_PATH/autogen_tmp/api/20-pb-firmware/lib-pb3a -lbce -o ${f:0:(-2)}.elf || exit 1
		
		echo "objcopy run"
                objcopy -I elf32-little -O binary -j .text ${f:0:(-2)}.elf ${f:0:(-2)}.bin
                echo "pblaze bincopy run"
                $RAVAC_BASE_PATH/utia-pblaze-cc-2.1.0/bin/pblaze-bincopy --format=c ${f:0:(-2)}.bin ${f:0:(-2)}.h
		echo "******** generated PicoBlaze firmware"
	done

	for f in fw_*.h
	do
		echo "cp $f $AUTOGEN_TMP_PATH/link/$f"
		cp $f $AUTOGEN_TMP_PATH/link/$f || exit 1
	done


	cd ..
	echo "end of picoblaze firmware compilation"
	echo ""
	echo ""
	echo "### beginning MicroBlaze core compilation ###"
	
	#temporary fix for just one specific firmware
	sed 's/\.body_clone/_body_clone/g' $AUTOGEN_TMP_PATH/link/fw_incl.c -i 
	
	echo "microblaze-uclinux-gcc $MICROBLAZE_CFLAGS -c -o $AUTOGEN_TMP_PATH/$ACC_NAME.o -isystem home/smecy/smecy/tests/simple_tests/build/autogen_tmp/link/../api/12-mb-petalinux/libwal/  $AUTOGEN_TMP_PATH/${ACC_NAME}_recomp.c $AUTOGEN_TMP_PATH/link/fw_incl.c $AUTOGEN_TMP_PATH/link/manager.c "


	microblaze-uclinux-gcc $MICROBLAZE_CFLAGS -c -o $AUTOGEN_TMP_PATH/$ACC_NAME.o -I $AUTOGEN_TMP_PATH/api/12-mb-petalinux/libwal/  $AUTOGEN_TMP_PATH/${ACC_NAME}_recomp.c $AUTOGEN_TMP_PATH/link/fw_incl.c $AUTOGEN_TMP_PATH/link/manager.c || exit 1
	echo "Integrating manager core "
	#pwd

	microblaze-uclinux-gcc $MICROBLAZE_CFLAGS -c -o $AUTOGEN_TMP_PATH/mb_$ACC_SRC.o $AUTOGEN_TMP_PATH/mb_$ACC_SRC || exit 1
	
	echo "microblaze-uclinux-gcc -o $OUT_FILE $OMP_NAME.o $AUTOGEN_TMP_PATH/mb_$ACC_SRC.o $AUTOGEN_TMP_PATH/$ACC_NAME.o  $ADD_OBJS $OMP_LIBS -lbce_config -lpthread  -lwal $MICROBLAZE_LDFLAGS"
    microblaze-uclinux-gcc -o $OUT_FILE $OMP_NAME.o $AUTOGEN_TMP_PATH/mb_$ACC_SRC.o $AUTOGEN_TMP_PATH/$ACC_NAME.o  $ADD_OBJS $OMP_LIBS -lbce_config -lpthread  -lwal $MICROBLAZE_LDFLAGS || exit 1

    echo "Final API linking complete with exit code $?"
	echo "end of MicroBlaze core compilation final binary created"
#           echo "Copy generated binary file to TFTP directory"
		
	echo "*** Resulting binary with optimized source file $ACC_SRC was generated as $OUT_FILE ***"

#           cp ${arg1:0:len-2} /tftpboot
#           echo "cleanup"
         # rm ${arg1:0:len-2}.o
        #   rm ${arg1:0:len-2}.ll
         #  rm ${arg1:0:len-2}_pass.bc
         #  rm ${arg1:0:len-2}.bc
fi

