/**
 * Simple class which is used by CompactShortEvaluation pass.
 * It finds basic blocks with phi nodes, and try find this pattern
 *                      bb0
 *                     /  \
 *                    /    |
 *                   bb1   |
 *                    \    |
 *                     \  /
 *                      bb2 with phi node
 *  is triangle in graph of basic blocks. It is importnat to bb0 has two succesors and
 *  bb1 has only one succesor. bb2 has to contain phi node.
 *  This triangle is possible tranform to this
 *                      bb0
 *                       |
 *                       |
 *                      bb1
 *                       |
 *                    select instr
 *                       |
 *                      bb2
 *  If bb2 contain simple phi node with two arguments it is simple to transform.
 *  But if phi node contain more then two arguments, we take two of them which contains
 *  bb0 and bb1 basic block. Create select instr and result of select instr add like argument
 *  to phi node.
 *  And another pattern is important:
 *
 *          bb0
 *         /  \
 *        /    \
 *      bb1    bb2
 *       \      /
 *         \  /
 *         bb3 with phi node
 *
 *
 * Author:  Tomas Minac <xminac01@stud.fit.vutbr.cz>
 * Date:    16.07.2012
 */

#ifndef __TRANSFERPHIINSTRTOSELECT_H__
#define __TRANSFERPHIINSTRTOSELECT_H__

#include "llvm/Pass.h"
#include "llvm/Module.h"
#include "llvm/Function.h"
#include "llvm/BasicBlock.h"
#include "llvm/Instructions.h"
#include "llvm/Type.h"
#include "llvm/Constants.h"
#include "llvm/Support/raw_ostream.h"

#include "llvm/Transforms/Utils/Cloning.h"

#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Support/InstIterator.h"
#include "llvm/Intrinsics.h"
#include "llvm/Support/Debug.h"

#include <vector>
#include <map>
//#include "SemExtrUtils.h"

using namespace llvm;
using namespace std;

class TransformPhiInstrToSelect {
  public:
        map<BasicBlock *, unsigned> mapBBtoIncomingEdge;

	TransformPhiInstrToSelect(){}; //constructor
        bool testForTriangle(Function *F);
        void createNewInstr(BranchInst *branchInst,BasicBlock * bb, BasicBlock *secondBB, bool firstRight);
        bool checkForMerging(Function *F, BasicBlock *bbF, BasicBlock *bbS);
        bool checkForMerging(Function *F,BasicBlock*bb0,  BasicBlock *bbF, BasicBlock *bbS);
        void setMapBBtoIncomingEdge(Function *F);
        //void reConnectAllPredecessor(Function *F, BasicBlock *bb, BasicBlock *firstBB, BasicBlock *brotherBB, bool neg);
        bool isPhiNodeInBB(BasicBlock *bb, BasicBlock *firstBB, BasicBlock *secondBB);
        void repairPhiNode(BasicBlock *origBB, BasicBlock *cloneBB);
        void repairInstruction(ValueToValueMapTy &VMap, BasicBlock *origBB, BasicBlock *cloneBB);

        vector<PHINode *> vecPhiNodes;
        vector<SelectInst *> vecSelectInst;
  
        //prepare for alone pass
	/*virtual bool runOnFunction(Function &F);
        void tryJointBBWithPredessors(Function &F);*/

};
#endif
