/* Provide Declarations */
#include <stdarg.h>
#include <setjmp.h>
#include <limits.h>
/* get a declaration for alloca */
#if defined(__CYGWIN__) || defined(__MINGW32__)
#define  alloca(x) __builtin_alloca((x))
#define _alloca(x) __builtin_alloca((x))
#elif defined(__APPLE__)
extern void *__builtin_alloca(unsigned long);
#define alloca(x) __builtin_alloca(x)
#define longjmp _longjmp
#define setjmp _setjmp
#elif defined(__sun__)
#if defined(__sparcv9)
extern void *__builtin_alloca(unsigned long);
#else
extern void *__builtin_alloca(unsigned int);
#endif
#define alloca(x) __builtin_alloca(x)
#elif defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__DragonFly__) || defined(__arm__)
#define alloca(x) __builtin_alloca(x)
#elif defined(_MSC_VER)
#define inline _inline
#define alloca(x) _alloca(x)
#else
#include <alloca.h>
#endif

#ifndef __GNUC__  /* Can only support "linkonce" vars with GCC */
#define __attribute__(X)
#endif

#if defined(__GNUC__) && defined(__APPLE_CC__)
#define __EXTERNAL_WEAK__ __attribute__((weak_import))
#elif defined(__GNUC__)
#define __EXTERNAL_WEAK__ __attribute__((weak))
#else
#define __EXTERNAL_WEAK__
#endif

#if defined(__GNUC__) && defined(__APPLE_CC__)
#define __ATTRIBUTE_WEAK__
#elif defined(__GNUC__)
#define __ATTRIBUTE_WEAK__ __attribute__((weak))
#else
#define __ATTRIBUTE_WEAK__
#endif

#if defined(__GNUC__)
#define __HIDDEN__ __attribute__((visibility("hidden")))
#endif

#ifdef __GNUC__
#define LLVM_NAN(NanStr)   __builtin_nan(NanStr)   /* Double */
#define LLVM_NANF(NanStr)  __builtin_nanf(NanStr)  /* Float */
#define LLVM_NANS(NanStr)  __builtin_nans(NanStr)  /* Double */
#define LLVM_NANSF(NanStr) __builtin_nansf(NanStr) /* Float */
#define LLVM_INF           __builtin_inf()         /* Double */
#define LLVM_INFF          __builtin_inff()        /* Float */
#define LLVM_PREFETCH(addr,rw,locality) __builtin_prefetch(addr,rw,locality)
#define __ATTRIBUTE_CTOR__ __attribute__((constructor))
#define __ATTRIBUTE_DTOR__ __attribute__((destructor))
#define LLVM_ASM           __asm__
#else
#define LLVM_NAN(NanStr)   ((double)0.0)           /* Double */
#define LLVM_NANF(NanStr)  0.0F                    /* Float */
#define LLVM_NANS(NanStr)  ((double)0.0)           /* Double */
#define LLVM_NANSF(NanStr) 0.0F                    /* Float */
#define LLVM_INF           ((double)0.0)           /* Double */
#define LLVM_INFF          0.0F                    /* Float */
#define LLVM_PREFETCH(addr,rw,locality)            /* PREFETCH */
#define __ATTRIBUTE_CTOR__
#define __ATTRIBUTE_DTOR__
#define LLVM_ASM(X)
#endif

#if __GNUC__ < 4 /* Old GCC's, or compilers not GCC */ 
#define __builtin_stack_save() 0   /* not implemented */
#define __builtin_stack_restore(X) /* noop */
#endif

#if __GNUC__ && __LP64__ /* 128-bit integer types */
typedef int __attribute__((mode(TI))) llvmInt128;
typedef unsigned __attribute__((mode(TI))) llvmUInt128;
#endif

#define CODE_FOR_MAIN() /* Any target-specific code for main()*/

#ifndef __cplusplus
typedef unsigned char bool;
#endif


/* Support for floating point constants */
typedef unsigned long long ConstantDoubleTy;
typedef unsigned int        ConstantFloatTy;
typedef struct { unsigned long long f1; unsigned short f2; unsigned short pad[3]; } ConstantFP80Ty;
typedef struct { unsigned long long f1; unsigned long long f2; } ConstantFP128Ty;


/* Global Declarations */
/* Helper union for bitcasts */
typedef union {
  unsigned int Int32;
  unsigned long long Int64;
  float Float;
  double Double;
} llvmBitCastUnion;

/* Function Declarations */
double fmod(double, double);
float fmodf(float, float);
long double fmodl(long double, long double);
void dummy_call(void);
void fw_data_get(unsigned int , unsigned int , unsigned int , unsigned int , float *, unsigned int , unsigned int , unsigned int );
unsigned int fw_init_fw(unsigned int );
void fw_data_init(unsigned int , unsigned int , unsigned int , unsigned int , float *, unsigned int , unsigned int , unsigned int , float );
void fw_op_start(unsigned int );
void fw_init_table(void);
float bar(float llvm_cbe_c);
float foo(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b);
void foo2(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b);
float foo_bar(float *llvm_cbe_b, float *llvm_cbe_a, float *llvm_cbe_c);
void compute(float *llvm_cbe_a, float *llvm_cbe_b, float *llvm_cbe_c, unsigned int llvm_cbe_decide);
unsigned int main(void);
void abort(void);


/* Function Bodies */
static inline int llvm_fcmp_ord(double X, double Y) { return X == X && Y == Y; }
static inline int llvm_fcmp_uno(double X, double Y) { return X != X || Y != Y; }
static inline int llvm_fcmp_ueq(double X, double Y) { return X == Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_une(double X, double Y) { return X != Y; }
static inline int llvm_fcmp_ult(double X, double Y) { return X <  Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_ugt(double X, double Y) { return X >  Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_ule(double X, double Y) { return X <= Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_uge(double X, double Y) { return X >= Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_oeq(double X, double Y) { return X == Y ; }
static inline int llvm_fcmp_one(double X, double Y) { return X != Y && llvm_fcmp_ord(X, Y); }
static inline int llvm_fcmp_olt(double X, double Y) { return X <  Y ; }
static inline int llvm_fcmp_ogt(double X, double Y) { return X >  Y ; }
static inline int llvm_fcmp_ole(double X, double Y) { return X <= Y ; }
static inline int llvm_fcmp_oge(double X, double Y) { return X >= Y ; }

void dummy_call(void) {
  unsigned int llvm_cbe_tmp__1;

  fw_data_get(0u, 0u, 0u, 0u, ((float *)/*NULL*/0), 0u, 0u, 0u);
  llvm_cbe_tmp__1 = fw_init_fw(0u);
  fw_data_init(0u, 0u, 0u, 0u, ((float *)/*NULL*/0), llvm_cbe_tmp__1, llvm_cbe_tmp__1, 0u, 0x0p+0);
  fw_op_start(0u);
  fw_init_table();
  return;
}


float bar(float llvm_cbe_c) {
  return (((float )(llvm_cbe_c * llvm_cbe_c)));
}


float foo(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b) {
  unsigned int llvm_cbe_i_2e_01;
  unsigned int llvm_cbe_i_2e_01__PHI_TEMPORARY;
  float *llvm_cbe_scevgep;
  float llvm_cbe_tmp__2;
  float llvm_cbe_tmp__3;
  float llvm_cbe_tmp__4;
  unsigned int llvm_cbe_tmp__5;
  float *llvm_cbe_tmp__6;
  float llvm_cbe_tmp__7;
  float llvm_cbe_tmp__8;

  llvm_cbe_i_2e_01__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__9;

  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__9:
  llvm_cbe_i_2e_01 = llvm_cbe_i_2e_01__PHI_TEMPORARY;
  llvm_cbe_scevgep = (&llvm_cbe_a[((signed int )llvm_cbe_i_2e_01)]);
  llvm_cbe_tmp__2 = *((&llvm_cbe_b[((signed int )llvm_cbe_i_2e_01)]));
  llvm_cbe_tmp__3 = *((&llvm_cbe_c[((signed int )llvm_cbe_i_2e_01)]));
  llvm_cbe_tmp__4 = *llvm_cbe_scevgep;
  *llvm_cbe_scevgep = (((float )((((float )(llvm_cbe_tmp__2 + (((float )(llvm_cbe_tmp__3 * llvm_cbe_tmp__4)))))) + (((float )(llvm_cbe_tmp__3 * llvm_cbe_tmp__2))))));
  llvm_cbe_tmp__5 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_01) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__5 == 250u)) {
    goto llvm_cbe_tmp__10;
  } else {
    llvm_cbe_i_2e_01__PHI_TEMPORARY = llvm_cbe_tmp__5;   /* for PHI node */
    goto llvm_cbe_tmp__9;
  }

  } while (1); /* end of syntactic loop '' */
llvm_cbe_tmp__10:
  llvm_cbe_tmp__6 = (&llvm_cbe_b[((signed int )3u)]);
  llvm_cbe_tmp__7 = *llvm_cbe_tmp__6;
  *((&llvm_cbe_b[((signed int )5u)])) = llvm_cbe_tmp__7;
  llvm_cbe_tmp__8 = *llvm_cbe_tmp__6;
  return llvm_cbe_tmp__8;
}


void foo2(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b) {
  unsigned int llvm_cbe_indvar4;
  unsigned int llvm_cbe_indvar4__PHI_TEMPORARY;
  float *llvm_cbe_scevgep7;
  float llvm_cbe_tmp__11;
  unsigned int llvm_cbe_indvar;
  unsigned int llvm_cbe_indvar__PHI_TEMPORARY;
  unsigned int llvm_cbe_i_2e_01;
  unsigned int llvm_cbe_i_2e_01__PHI_TEMPORARY;
  float *llvm_cbe_scevgep;
  float llvm_cbe_tmp__12;
  float llvm_cbe_tmp__13;
  float llvm_cbe_tmp__14;
  unsigned int llvm_cbe_tmp__15;
  unsigned int llvm_cbe_indvar_2e_next;
  unsigned int llvm_cbe_indvar_2e_next5;
  float llvm_cbe_tmp__16;

  llvm_cbe_indvar4__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__17;

  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__17:
  llvm_cbe_indvar4 = llvm_cbe_indvar4__PHI_TEMPORARY;
  llvm_cbe_scevgep7 = (&llvm_cbe_c[((signed int )(((unsigned int )(((unsigned int )llvm_cbe_indvar4) * ((unsigned int )2u)))))]);
  llvm_cbe_tmp__11 = *llvm_cbe_scevgep7;
  *llvm_cbe_scevgep7 = (((float )(llvm_cbe_tmp__11 + 0x1p+1)));
  llvm_cbe_indvar__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe__2e_preheader;

llvm_cbe_tmp__18:
  llvm_cbe_indvar_2e_next5 = ((unsigned int )(((unsigned int )llvm_cbe_indvar4) + ((unsigned int )1u)));
  if ((llvm_cbe_indvar_2e_next5 != 125u)) {
    llvm_cbe_indvar4__PHI_TEMPORARY = llvm_cbe_indvar_2e_next5;   /* for PHI node */
    goto llvm_cbe_tmp__17;
  } else {
    goto llvm_cbe_tmp__19;
  }

  do {     /* Syntactic loop '.preheader' to make GCC happy */
llvm_cbe__2e_preheader:
  llvm_cbe_indvar = llvm_cbe_indvar__PHI_TEMPORARY;
  llvm_cbe_i_2e_01__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__20;

llvm_cbe_tmp__21:
  llvm_cbe_indvar_2e_next = ((unsigned int )(((unsigned int )llvm_cbe_indvar) + ((unsigned int )1u)));
  if ((llvm_cbe_indvar_2e_next != 125u)) {
    llvm_cbe_indvar__PHI_TEMPORARY = llvm_cbe_indvar_2e_next;   /* for PHI node */
    goto llvm_cbe__2e_preheader;
  } else {
    goto llvm_cbe_tmp__18;
  }

  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__20:
  llvm_cbe_i_2e_01 = llvm_cbe_i_2e_01__PHI_TEMPORARY;
  llvm_cbe_scevgep = (&llvm_cbe_b[((signed int )llvm_cbe_i_2e_01)]);
  llvm_cbe_tmp__12 = *((&llvm_cbe_a[((signed int )llvm_cbe_i_2e_01)]));
  llvm_cbe_tmp__13 = *((&llvm_cbe_c[((signed int )llvm_cbe_i_2e_01)]));
  llvm_cbe_tmp__14 = *llvm_cbe_scevgep;
  *llvm_cbe_scevgep = (((float )((((float )(llvm_cbe_tmp__12 * llvm_cbe_tmp__13))) + llvm_cbe_tmp__14)));
  llvm_cbe_tmp__15 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_01) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__15 == 250u)) {
    goto llvm_cbe_tmp__21;
  } else {
    llvm_cbe_i_2e_01__PHI_TEMPORARY = llvm_cbe_tmp__15;   /* for PHI node */
    goto llvm_cbe_tmp__20;
  }

  } while (1); /* end of syntactic loop '' */
  } while (1); /* end of syntactic loop '.preheader' */
  } while (1); /* end of syntactic loop '' */
llvm_cbe_tmp__19:
  llvm_cbe_tmp__16 = *((&llvm_cbe_b[((signed int )2u)]));
  *((&llvm_cbe_b[((signed int )5u)])) = llvm_cbe_tmp__16;
  return;
}


float foo_bar(float *llvm_cbe_b, float *llvm_cbe_a, float *llvm_cbe_c) {
  unsigned int llvm_cbe_i_2e_01;
  unsigned int llvm_cbe_i_2e_01__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp__22;
  float llvm_cbe_tmp__23;
  float llvm_cbe_tmp__24;
  unsigned int llvm_cbe_tmp__25;
  float llvm_cbe_tmp__26;

  llvm_cbe_i_2e_01__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__27;

  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__27:
  llvm_cbe_i_2e_01 = llvm_cbe_i_2e_01__PHI_TEMPORARY;
  llvm_cbe_tmp__22 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_01) + ((unsigned int )2u)));
  llvm_cbe_tmp__23 = *((&llvm_cbe_b[((signed int )llvm_cbe_i_2e_01)]));
  llvm_cbe_tmp__24 = *((&llvm_cbe_c[((signed int )llvm_cbe_tmp__22)]));
  *((&llvm_cbe_a[((signed int )llvm_cbe_tmp__22)])) = (((float )(llvm_cbe_tmp__23 + (((float )(llvm_cbe_tmp__24 * llvm_cbe_tmp__23))))));
  llvm_cbe_tmp__25 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_01) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__25 == 250u)) {
    goto llvm_cbe_tmp__28;
  } else {
    llvm_cbe_i_2e_01__PHI_TEMPORARY = llvm_cbe_tmp__25;   /* for PHI node */
    goto llvm_cbe_tmp__27;
  }

  } while (1); /* end of syntactic loop '' */
llvm_cbe_tmp__28:
  llvm_cbe_tmp__26 = *((&llvm_cbe_a[((signed int )6u)]));
  *((&llvm_cbe_b[((signed int )3u)])) = llvm_cbe_tmp__26;
  return llvm_cbe_tmp__26;
}


void compute(float *llvm_cbe_a, float *llvm_cbe_b, float *llvm_cbe_c, unsigned int llvm_cbe_decide) {
  float llvm_cbe_tmp__29;

  if ((llvm_cbe_decide == 0u)) {
    goto llvm_cbe_tmp__30;
  } else {
    goto llvm_cbe_tmp__31;
  }

llvm_cbe_tmp__31:
  llvm_cbe_tmp__29 =  /*tail*/ foo(llvm_cbe_c, llvm_cbe_a, llvm_cbe_b);
  goto llvm_cbe_tmp__32;

llvm_cbe_tmp__30:
   /*tail*/ foo2(llvm_cbe_b, llvm_cbe_a, llvm_cbe_c);
  goto llvm_cbe_tmp__32;

llvm_cbe_tmp__32:
  return;
}


unsigned int main(void) {
  float llvm_cbe_a[256];    /* Address-exposed local */
  float llvm_cbe_b[256];    /* Address-exposed local */
  float llvm_cbe_c[256];    /* Address-exposed local */
  unsigned int llvm_cbe_i_2e_02;
  unsigned int llvm_cbe_i_2e_02__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp__33;
  float *llvm_cbe_tmp__34;
  float *llvm_cbe_tmp__35;
  float *llvm_cbe_tmp__36;
  unsigned int llvm_cbe_i_2e_11;
  unsigned int llvm_cbe_i_2e_11__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp__37;

  CODE_FOR_MAIN();
  llvm_cbe_i_2e_02__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__38;

  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__38:
  llvm_cbe_i_2e_02 = llvm_cbe_i_2e_02__PHI_TEMPORARY;
  *((&llvm_cbe_a[((signed int )llvm_cbe_i_2e_02)])) = 0x1.4p+3;
  *((&llvm_cbe_b[((signed int )llvm_cbe_i_2e_02)])) = 0x1p+1;
  *((&llvm_cbe_c[((signed int )llvm_cbe_i_2e_02)])) = 0x1p+0;
  llvm_cbe_tmp__33 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_02) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__33 == 256u)) {
    goto llvm_cbe_tmp__39;
  } else {
    llvm_cbe_i_2e_02__PHI_TEMPORARY = llvm_cbe_tmp__33;   /* for PHI node */
    goto llvm_cbe_tmp__38;
  }

  } while (1); /* end of syntactic loop '' */
llvm_cbe_tmp__39:
  llvm_cbe_tmp__34 = ((float *)(unsigned long)((((unsigned int )(unsigned long)((&llvm_cbe_a[((signed int )1u)])))) & 4294967288u));
  llvm_cbe_tmp__35 = ((float *)(unsigned long)((((unsigned int )(unsigned long)((&llvm_cbe_b[((signed int )1u)])))) & 4294967288u));
  llvm_cbe_tmp__36 = ((float *)(unsigned long)((((unsigned int )(unsigned long)((&llvm_cbe_c[((signed int )1u)])))) & 4294967288u));
  llvm_cbe_i_2e_11__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__40;

  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__40:
  llvm_cbe_i_2e_11 = llvm_cbe_i_2e_11__PHI_TEMPORARY;
  compute(llvm_cbe_tmp__34, llvm_cbe_tmp__35, llvm_cbe_tmp__36, 0u);
  llvm_cbe_tmp__37 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_11) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__37 == 10000u)) {
    goto llvm_cbe_tmp__41;
  } else {
    llvm_cbe_i_2e_11__PHI_TEMPORARY = llvm_cbe_tmp__37;   /* for PHI node */
    goto llvm_cbe_tmp__40;
  }

  } while (1); /* end of syntactic loop '' */
llvm_cbe_tmp__41:
  return 0u;
}

