/*
 * IndvarMod.cpp
 *
 *  Created on: 23.4.2012
 *  Author: Robert Barucak
 *  Email: xbaruc00@stud.fit.vutbr.cz
 */
#include "IndvarMod.h"

namespace llvm {
IndvarMod::IndvarMod(Loop *nL,int nTripCount, Value *nIndVar) {
	L=nL;
	TripCount=nTripCount;
	IndVar=nIndVar;
	InfoPool=NULL;
	InfoCount=0;
	InfoPoolSize=0;
}

void IndvarMod::IndvarAnalysis(){
	errs()<<"------------------------Analysis begin\n\n\n\n";
	L->dump();
	/**for (Loop::block_iterator LI = L->block_begin(), LE = L->block_end(); LI != LE; ++LI) { //iterating over multiple blocks in one loop
    	llvm::Instruction *I;
    	//errs()<<**LI<<" \n \n";
    	for (BasicBlock::iterator BI = (*LI)->begin(), BE = (*LI)->end(); BI != BE; ++BI) { //iterating over instructions in one block
    		if (BI->mayWriteToMemory() && BI->getOpcode()== Instruction::Store){ //store modifiers
    			 //if store is localized indvar modifiers analysis is triggered
                I=BI;
                errs()<<"***OPSCAN***\n";
                VEdges.clear();
                IndvarMod::OpScan(dyn_cast<Instruction>(I->getOperand(0)));
                errs()<<"***OPSCAN***\n";
               // errs()<<"store catch\n";
                IndvarMod::InfoGet(dyn_cast<Value>(I),0);
                errs()<<"found store:"<<*I<<"\n";
            }
    		if(BI->mayReadFromMemory() && BI->getOpcode()== Instruction::Load){
    			//if load is found in main block extract relevant info too
                I=BI;

                errs()<<*I<<"load catch\n";
                IndvarMod::InfoGet(dyn_cast<Value>(I),1);
    		}


        }
    }**/

	for (Loop::block_iterator LI = L->block_begin(), LE = L->block_end(); LI != LE; ++LI) { //iterating over multiple blocks in one loop
	    	llvm::Instruction *I;
	    	//errs()<<**LI<<" \n \n";
	    	for (BasicBlock::iterator BI = (*LI)->begin(), BE = (*LI)->end(); BI != BE; ++BI) { //iterating over instructions in one block
	    		if (BI->mayWriteToMemory() && BI->getOpcode()== Instruction::Store){ //store modifiers
	    			 //if store is localized indvar modifiers analysis is triggered
	                I=BI;
	                errs()<<"***OPSCAN***\n";
	                VEdges.clear();

	                //for(int numOps = 0; numOps< I->getNumOperands();numOps++){
	                	IndvarMod::OpScan(dyn_cast<Instruction>(I->getOperand(0)));
	                //}

	                errs()<<"***OPSCAN***\n";
	               // errs()<<"store catch\n";
	                IndvarMod::InfoGet(dyn_cast<Value>(I),0);
	                errs()<<"found store:"<<*I<<"\n";
	            }
	                //IndvarMod::InfoGet(dyn_cast<Value>(I),1);


	        }
	    }
	IndvarMod::StoreCorrector();
	for(int i=0; i< InfoCount ; i++){
		errs()<<(InfoPool[i])->Type<<"\n";
	}
	errs()<<"\n\n\n\n------------------------Analysis end\n";
	return;
}

bool IndvarMod::CheckNode(Value *V){
	for(std::vector<Value *>::iterator ValIt = VEdges.begin(), ValIte = VEdges.end(); ValIt!=ValIte;++ValIt){
		if(*ValIt==V){
			return false;
		}
	}
	VEdges.push_back(V);
    return true;
}

void IndvarMod::OpScan(Instruction *I){ //with help of this function we can establish order even if there are constants - browsing the code be use-def

   if(I==NULL){
	   return;
   }

   errs()<<"\n------------------\n"<<*I;

   errs()<<*I<<"|main inst\n";



   for(llvm::Instruction::op_iterator OpIter=I->op_begin(), OpItere=I->op_end(); OpIter!=OpItere;OpIter++){

       errs()<< "\n********** "<<*I <<"\n";

	   if(isa<PHINode>(I)){
	        errs()<<"\nIn PHI";
	      }
	   if(isa<SelectInst>(I)){
		   errs()<<"\n In Select| |"<<**OpIter;
	   }


	    //select tweaks begin
        if(!isa<Constant>(OpIter) && isa<PHINode>(I)){
                        	PHINode *tmpPHI= dyn_cast<PHINode>(I);
        					BasicBlock *cPHIS=tmpPHI->getIncomingBlock(*OpIter);
        					Instruction *cBr= cPHIS->getTerminator();
        					if((dyn_cast<BranchInst>(cBr))->isConditional()){
        						//BranchInst *tmpBR=dyn_cast<BranchInst(cBr);
        						OpScan(dyn_cast<Instruction>((dyn_cast<BranchInst>(cBr))->getCondition()));
        						//to get zero
        						BasicBlock *zCons=(dyn_cast<BranchInst>(cBr))->getSuccessor(0);
        						Instruction *zcbr= zCons->getTerminator();
                                if((dyn_cast<BranchInst>(zcbr))->isConditional()){
                                	OpScan(dyn_cast<Instruction>((dyn_cast<BranchInst>(zcbr))->getCondition()));
                                }
                                //end to get zero
        					}
        }
        if(!isa<Constant>(OpIter)&&!IndvarMod::CheckNode(*OpIter) ){ //check if node of optree was already visited
	    	continue;
	    }
        if(isa<SelectInst>(OpIter)){
        	OpScan(dyn_cast<Instruction>(OpIter));
        }
        if(isa<FCmpInst>(OpIter)){
        	OpScan(dyn_cast<Instruction>(OpIter));
        }

        //select tweaks end
		if(isa<Instruction>(OpIter) && dyn_cast<Instruction>(OpIter)->isBinaryOp()){
			errs()<< "\n I have inst \n"<<*OpIter<<"\n";
			OpScan(dyn_cast<Instruction>(OpIter));
		}

		if(isa<Constant>(OpIter)){
			errs()<<"\n Xgot constant\n";
			if(IndvarMod::CheckNode(*OpIter))
			IndvarMod::InfoGet(dyn_cast<Value>(OpIter),2);
			//this piece of code is complete clusterfuck, it is here to ensure funcionality of complicated selects
			if(isa<PHINode>(I)){
				errs()<<"activating cluster fuck avoidance procedure\n\n";
				PHINode *tmpPHI= dyn_cast<PHINode>(I);
				BasicBlock *cPHIS=tmpPHI->getIncomingBlock(*OpIter);
				Instruction *cBr= cPHIS->getTerminator();
				if((dyn_cast<BranchInst>(cBr))->isConditional()){
					//BranchInst *tmpBR=dyn_cast<BranchInst(cBr)
					OpScan(dyn_cast<Instruction>((dyn_cast<BranchInst>(cBr))->getCondition()));
				}
			}

			//end of clusterfuck
		}



		if(isa<Instruction>(OpIter) && dyn_cast<Instruction>(OpIter)->mayReadFromMemory() && dyn_cast<Instruction>(OpIter)->getOpcode()== Instruction::Load){
		    			//if load is found in main block extract relevant info too
            errs()<<**OpIter<<"load catch\n";
			IndvarMod::InfoGet(dyn_cast<Value>(OpIter),1);
		    errs()<<"end catch\n";
		    //IndvarMod::InfoGet(dyn_cast<Value>(I),1);
		}

		if(isa<Argument>(OpIter) && (*OpIter)->getType()->isFloatTy()){ //classic float variable
			errs()<< "one const var\n";
			IndvarMod::InfoGet(dyn_cast<Value>(OpIter),2);
		}


	}
   // if(isa<PHINode>(I)){
   // 	PHINode *tmpPHI= dyn_cast<PHINode>(I);

    //}


}

void IndvarMod::Update(MemInit **xNewInfo){
	MemInit *NewInfo=new MemInit;
	for(int i=0;i<3;i++){
		NewInfo->Init[i]=NULL;
	}
	if(InfoPoolSize==InfoCount){
		InfoPoolSize+=5;
		MemInit **TmpPool= new MemInit*[InfoPoolSize];
		for(int i=0;i<InfoCount;++i){
		    	TmpPool[i]= InfoPool[i];
		}
		delete [] InfoPool;
		InfoPool=TmpPool;
	}
	InfoPool[InfoCount]=NewInfo;
	++InfoCount;
	*xNewInfo=NewInfo;
}

void IndvarMod::InfoGet(Value *V, int type){
	MemInit *NewInfo=NULL;
    IndvarMod::Update(&NewInfo);
				//resize info pool if needed

    Instruction *I=NULL;

    NewInfo->Origin=V;
    errs()<<"Origin Value "<< *V;
    if(type==2){ //if this is constant
    	NewInfo->Type=loadCONST;
    	return;
    }
    I=dyn_cast<Instruction>(V);

    Instruction *I_getElem=dyn_cast<Instruction>(I->getOperand(0)); //it is load

    if(type==0){ //it is store
    	I_getElem= dyn_cast<Instruction>(I->getOperand(1));
    }else if(I_getElem==NULL){
    	NewInfo->Type=loadVARCONST;
    }
    errs()<<"\n"<<*I->getOperand(0)<< "\n";
	if(I_getElem !=NULL && I_getElem->getOpcode()==Instruction::GetElementPtr){ //first operand must be getelemenptr every time
		if(I_getElem->getOperand(1)==dyn_cast<Value>(IndVar)){ //is getelem operand indvar itself?
			//errs()<<"Indvar equivalent, no mods in mem init\n";  //loadEQ
			NewInfo->Type=loadEQ;
			if(type==0){
				NewInfo->Type=storeEQ;
			}
	        //NewInfo->Init[0]=dyn_cast<Value>(I_getElem);
	        //errs()<<"eq: "<<NewInfo->Init[0];
	     }else{//if not, it must be bin op with numeric constant and indvar
	    	//errs()<<"----KomplexChange------\n";
	    	 IndvarMod::TopDownMod(type,I_getElem->getOperand(1),0,&NewInfo);
	    	//errs()<<"-----KomplexChangeEnd---------\n";
	     }
	}

}

void IndvarMod::TopDownMod(int type, Value *Input, int depth,MemInit **NewInfo){
    if(isa<Instruction>(Input) && !isa<PHINode>(Input)&&depth<3){
    	//errs()<<"|"<<*Input<<":"<<depth<<"\n";
    	Instruction *I_mod=dyn_cast<Instruction>(Input);
    	if(I_mod->isBinaryOp()){
    		(*NewInfo)->Init[depth]=Input;
    		(*NewInfo)->Type=loadMOD;
    		if(type==0){
    			(*NewInfo)->Type=storeMOD;
    		}
    		depth++;
    		for(unsigned int i=0;i<I_mod->getNumOperands();i++){
    			IndvarMod::TopDownMod(type,I_mod->getOperand(i),depth,NewInfo);
    		}
//errs()<<*((*NewInfo)->Init[depth-1])<<"\n";
    	}

    }
}


IndvarMod::~IndvarMod() {
	// TODO Auto-generated destructor stub
	if(InfoPool!=NULL){
	    for(int j=0;j<InfoCount;++j){
	         delete InfoPool[j];
	    }
	    delete [] InfoPool;
	}
}


void IndvarMod::StoreCorrector(){
	for(int i=InfoCount-1;i>=0;--i){
		errs()<<"Corrector   "<<*InfoPool[i]->Origin<<"\n";
		if(InfoPool[i]->Type>=storeMOD && i!=InfoCount-1){
			errs()<<"detected misplaced store\n\n";
		}
	}
}


}
