/*
 * FwIntegrator.h
 *
 *  Created on: 13.4.2012
 *  Author: Robert Barucak
 *  Email: xbaruc00@stud.fit.vutbr.cz
 */

#ifndef FWINTEGRATOR_H_
#define FWINTEGRATOR_H_
#include "llvm/Pass.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Transforms/Utils/FunctionUtils.h"
#include "llvm/ADT/Statistic.h"
#include "llvm/Transforms/Scalar.h"
#include "llvm/Module.h"
#include "llvm/Analysis/LoopPass.h"
#include "llvm/Analysis/ScalarEvolution.h"
#include "llvm/Analysis/AliasAnalysis.h"
#include "llvm/Analysis/LoopInfo.h"
#include "llvm/Analysis/LoopDependenceAnalysis.h"
#include "llvm/Analysis/MemoryDependenceAnalysis.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include "llvm/Support/IRBuilder.h"
#include "llvm/Instruction.h"
#include "llvm/ADT/SmallVector.h"
#include "llvm/ADT/ArrayRef.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include <errno.h>
#include "IndvarMod.h"
#include "llvm/LLVMContext.h"
#include <unistd.h>
#include <regex.h>

namespace llvm {

class FwIntegrator {
public:
	/**
	 * public constructor for fw integrator
	 *
	 */
	FwIntegrator(Loop *nL, std::string nFwName,int nFwCount,IndvarMod *nInfo);

	/**
	 * Function which deletes original block with loop and creates new one for manager.
	 * @param *ForbidenBlocks already altered blocks, legacy from version 1.0
	 */
	int Integrate(std::vector<BasicBlock*> *ForbidenBlocks);
	virtual ~FwIntegrator();

	enum MemType{
		   loadClassic, //load
		   loadCombined, // load+ store
		   storeClassic // store only
	    };
	enum ModType{
		   loadMOD, //modified indvar
		   loadCONST, //constant
		   loadEQ,
		   loadVARCONST,//equivalent to indvar
		   storeMOD,
		   storeCONST,
		   storeEQ

	    };

	typedef struct MemMapx{
			std::vector<std::string> Address;
			std::vector<int> Type;
	}MemMap;
private:
	IndvarMod *Info; /**< Object with informations about possible induction variable modifs in vector loads*/
	Loop *L; /**< Pointer to processed loop */
	std::string FwName; /**< Name of processed firmware */
	int FwCount; /**< ID of firmware */
	MemMap Map; /**< Memory map generated by backend, must be known on manager side for data init in runtime */

	/**
	 * Generate firmware registrator function and associated includes for runtime
	 */
	void FwIncludeGenerator();

	/**
	 * Create call system of manager in newly created block.
	 * @param *TheModule - current module in program, needed for callbuilder
	 * @param *Target target block for manager calls
	 */
	void CallGenerator(Module *TheModule, BasicBlock *Target);

	/**
	 * Generate calls of data transfer functions for runtime transfering vectors for computation
	 * @param *TheModule pointer to module, needed by call builder
	 * @param *Target target basic block for builder
	 * @param *WrkId ID of BCE core
	 * @param it place for instruction in newly constructed block
	 * @param Mem ID of dualport RAM block in BCE worker, where data is stored
	 * @param InfoIndex index to infopool, where info about data operation is stored
	 * @param LoadMarker switch load or store
	 */
	void LoadDataCallGenerator(Module *TheModule, BasicBlock *Target,CallInst *WrkId, BasicBlock::iterator it,std::string Mem,int InfoIndex,int LoadMarker);

	/**
	 * Get memory map from file generated  by backend.
	 */
	void RetrieveDataMap();

	void LinkMems(IndvarMod::MemInit *MBSideMem,std::string *Mem);

	void FakeLinkMems(IndvarMod::MemInit *MBSideMem, std::string *Mem, int InfoIndex, BasicBlock *Target );
	void ExtractMemID(unsigned int ArgNum, std::string *Mem,int store);

	/**
	 * insert increment modificators (if there are ones) into .*_linc_def.h
	 */
	void InsertLoadDefInfo(std::string Mem, int InfoIndex);
	void InsertStoreDefInfo(std::string Mem, int InfoIndex);

	void LoopCleaner(BasicBlock *PoI, BasicBlock *NBody, BasicBlock *End, BasicBlock *Start);
	void LoopCleanerHelper(BasicBlock *Current, BasicBlock *NBody, BasicBlock *End, BasicBlock *Start, std::vector<BasicBlock*> *destroyer);
	int GetNumArgsFromParentF(Value *Origin);
};

}

#endif /* FWINTEGRATOR_H_ */
