/*
 * FwIntegrator.cpp
 *
 *  Created on: 13.4.2012
 *  Author: Robert Barucak
 *  Email: xbaruc00@stud.fit.vutbr.cz
 */

#include "FwIntegrator.h"

namespace llvm {

FwIntegrator::FwIntegrator(Loop *nL, std::string nFwName, int nFwCount, IndvarMod *nInfo) {
L=nL;
FwName=nFwName;
FwCount=nFwCount;
Info=nInfo;
}

FwIntegrator::~FwIntegrator() {
	// TODO Auto-generated destructor stub
}
void FwIntegrator::RetrieveDataMap(){
	std::fstream MemMap;
	std::string MemInfo;
	char line[100];
	int change=0;
	std::string Name="autogen_tmp/"+FwName+"+mem";
	//errs()<<Name<<" memdmap data\n";
	MemMap.open(Name.c_str(), std::fstream::in);
	while(!MemMap.eof()){
	     MemMap.getline(line,100);
	     MemInfo="";
	     MemInfo=line;
	     //errs()<<MemInfo<<"\n";
	     if(MemInfo.empty()){
	         break;
	     }
	     if(MemInfo!="S" && change==0 ){
	         Map.Address.push_back(MemInfo);
	         Map.Type.push_back(loadClassic);

	     }else{
	    	 change=1;
	    	 if(MemInfo!="S"){
	    		 Map.Address.push_back(MemInfo);
	    		 Map.Type.push_back(storeClassic);
	    	 }
	     }
	}

	std::vector<int>::iterator TIT = Map.Type.begin();

	/**	    		 for(std::vector<std::string>::iterator It=Map.Address.begin();It!=Map.Address.end();It++){
		    			 errs()<<*It<<"|"<<*TIT<<"\n";
		    			 TIT++;
		    		 }
		    		 errs()<<".......\n";
		    		 for(int i=0; i<Info->InfoCount;i++){
		    			 errs()<<*((*Info).InfoPool[i]->Origin)<<"|"<<(*Info).InfoPool[i]->Type<<"\n";
		    		 }**/
}

int FwIntegrator::Integrate(std::vector<BasicBlock*> *ForbidenBlocks){
	//errs()<<"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Integrating firmwares\n\n\n";
	std::stringstream tmp;
	tmp<<FwCount;
	BasicBlock *body,  *start, *end, *new_block;//*crit_edge,
	Loop::block_iterator it = L->block_begin();

	body = L->getHeader(); //body of function
	end = L->getExitBlock();

	/**for(int i=0;i<2;++i){
		if(body->getTerminator()->getSuccessor(i) !=body){
			end = body->getTerminator()->getSuccessor(i);//exit block from function
		}
	}**/


	//get start block
	BasicBlock::use_iterator body_use_it=body->use_begin();
	for(;body_use_it!=body->use_end();++body_use_it ){
		BasicBlock *tmp = dyn_cast<Instruction>(*body_use_it)->getParent(); //*identify starter block for original phi via its only instruction- br
		if(isa<BranchInst>(tmp->getFirstNonPHI())){
			start = tmp;
		}
		/*if(dyn_cast<Instruction>(*body_use_it)->getParent() != body){
			start=dyn_cast<Instruction>(*body_use_it)->getParent();
		}*/
	}
	errs()<<"----------startblock-----\n";
    errs()<<*start;
    errs()<<"----------endstartblock------\n";
	// create new block, delete body and critical edge
	Twine name=Twine("man_block_"+tmp.str());

	LLVMContext &Context = llvm::getGlobalContext();
	new_block= BasicBlock::Create(Context, "man_block_"+tmp.str(), start->getParent(), end);

		//create new branch
	BranchInst::Create(end,new_block);
	BranchInst *uncond_branch_start=BranchInst::Create(new_block,start);
	BasicBlock::iterator start_it=start->begin();
	Instruction *redundant=NULL;
	for(;start_it!=start->end();++start_it){
		if(start_it->getOpcode()==Instruction::Br){
			if(dyn_cast<Instruction>(start_it) !=dyn_cast<Instruction>(uncond_branch_start)){
			    redundant=start_it;
			    break;
			}
		}
	}


		//erase loop itself and critical edge

	redundant->eraseFromParent();
	//generate calls

	Function *Funct=new_block->getParent();
	Module *TheModule = Funct->getParent();
	FwIntegrator::RetrieveDataMap();
	CallGenerator(TheModule,new_block);
	errs()<<*Funct;
	FwIntegrator::LoopCleaner(body,new_block,start,end);
	ForbidenBlocks->push_back(body);

	//body->dropAllReferences();
	//body->eraseFromParent();

	//Call fw generator, fw include system
	FwIntegrator::FwIncludeGenerator();
	++FwCount;
	//errs()<<"\n\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! End of Integrating firmwares\n";
	return FwCount;
}

void FwIntegrator::LoopCleaner(BasicBlock *PoI, BasicBlock *NBody, BasicBlock *End, BasicBlock *Start){
	std::vector<BasicBlock*> destroyer;
	FwIntegrator::LoopCleanerHelper(PoI,NBody,End,Start,&destroyer);
	for(std::vector<BasicBlock*>::reverse_iterator It= destroyer.rbegin(), EIT=destroyer.rend();It!=EIT; It++){
		  (*It)->dropAllReferences();
	 }
	for(std::vector<BasicBlock*>::reverse_iterator It= destroyer.rbegin(), EIT=destroyer.rend();It!=EIT; It++){
		  (*It)->eraseFromParent();
	 }


}

void FwIntegrator::LoopCleanerHelper(BasicBlock *Current, BasicBlock *NBody, BasicBlock *End, BasicBlock *Start, std::vector<BasicBlock*> *destroyer){
  if(Current->getTerminator()==NULL || Current == End || Current == NBody || Current == Start){
	  return;
  }
  for(std::vector<BasicBlock*>::iterator It= destroyer->begin(), EIT=destroyer->end();It!=EIT; It++){
	  if(Current == *It){
		  return;
	  }
  }
  Instruction *tmp= Current->getTerminator();
  destroyer->push_back(Current);
  //insert into list

  //call again
  if(isa<BranchInst>(tmp)){
	 BranchInst *tmpb= dyn_cast<BranchInst>(tmp);
	 int numBlocks=tmpb->getNumSuccessors();
	 for(int i=0; i<numBlocks;i++){
		 FwIntegrator::LoopCleanerHelper(tmpb->getSuccessor(i),NBody,End,Start,destroyer);
	 }
  }

}

void FwIntegrator::FwIncludeGenerator(){
	if(FwCount==0){ //generated function header and init
		 std::ofstream Outp("autogen_tmp/link/fw_incl_core.h");
		 FwName.erase(FwName.end()-1,FwName.end());
		 FwName+="h";
		 Outp<<"#include \""<<FwName<<"\"\n";
		 std::ofstream OutpC("autogen_tmp/link/fw_incl.c");
		 OutpC<<"#include \"fw_incl_core.h\"\n";
		 OutpC<<"void fw_reg(const unsigned int **fwx){\n";
		 FwName.erase(FwName.end()-2,FwName.end());
		 OutpC<<"fwx["<< FwCount <<"] = "<<FwName<<"; \n}\n";

	}else if(FwCount>0){
		std::fstream file("autogen_tmp/link/fw_incl_core.h");
		file.seekp(0, std::ios::end);
		int pos = file.tellp();
		if(pos > 0){
			file.seekp(pos, std::ios::beg);
		}
             //add additional firmware
		FwName.erase(FwName.end()-1,FwName.end());
		FwName+="h";
		file<<"#include \""<<FwName<<"\"\n";
		file.close();

		std::fstream OutpCf("autogen_tmp/link/fw_incl.c");
		OutpCf.seekp(0, std::ios::end);
		pos = OutpCf.tellp();
		if(pos > 0){
			OutpCf.seekp(pos - 2, std::ios::beg);
		}
		FwName.erase(FwName.end()-2,FwName.end());
		OutpCf<<"fwx["<< FwCount <<"] = "<<FwName<<"; \n}\n";
		OutpCf.close();
	}
}

void FwIntegrator::InsertStoreDefInfo(std::string Mem, int InfoIndex){
	std::string tmp= "autogen_tmp/"+ FwName;
	std::string megabuff;
	std::string linebuff;
	tmp=tmp.substr(0,tmp.length()-2);
	tmp=tmp+"_linc_def.h";
	std::ifstream NCode(tmp.c_str());
	char xline[200];
	Mem.replace(7,1,"_");
	Mem.replace(8,1,"_");
	int rv;
	regex_t exp;
	Mem="SX"+Mem+" ";

	rv = regcomp(&exp, Mem.c_str() , REG_EXTENDED);
	regmatch_t Matches[1];
	while(!NCode.eof()){
	    for(int i=0; i<200;++i){
	    	 xline[i]='\0';
	    }
	    NCode.getline(xline,200);
        linebuff=xline;
	    if(regexec(&exp,xline,1,Matches,0)==0){

	    	errs()<<"*************\n FOUND STORE\n";

	    	if(Info->InfoPool[InfoIndex]->Type==storeCONST ){ //if firmware is handling loading of constant - insert 0
	    	    linebuff.replace(linebuff.length()-1,1,"0");
	    	}
	    	for(int i=0;i<2;++i){
	    	    if(Info->InfoPool[InfoIndex]->Init[i]!=NULL && dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[i])->getOpcode()== Instruction::Mul){
	    	        Value *constValue;
	    	        constValue= dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[i])->getOperand(1);
	    	        errs()<<*constValue<<"\n";
	    	        int ProperMult = 1;
	    	        if (llvm::ConstantInt* CI = dyn_cast<llvm::ConstantInt>(constValue)) {
	    	        	ProperMult= CI->getSExtValue();
	    	        }
	    	        std::stringstream ss;
	    	        ss<<ProperMult;
	    	        linebuff.erase(linebuff.length()-2,1);
	    	        linebuff=linebuff+ss.str();
	    	     }
	    	 }


            errs()<<*Info->InfoPool[InfoIndex]->Origin;
	    	errs()<<"*******\n";

	    }



	    megabuff=megabuff + linebuff + "\n";
	}

	std::string ntmp;
	raw_fd_ostream *FileDump = new raw_fd_ostream(tmp.c_str(), ntmp);
	*FileDump<<megabuff;
	delete FileDump;
}



void FwIntegrator::InsertLoadDefInfo(std::string Mem, int InfoIndex){
	std::string tmp= "autogen_tmp/"+ FwName;
	std::string megabuff;
	std::string linebuff;
	tmp=tmp.substr(0,tmp.length()-2);
    tmp=tmp+"_linc_def.h";

    std::ifstream NCode(tmp.c_str());
    char xline[200];
    Mem.replace(7,1,"_");
    Mem.replace(8,1,"_");
    int rv;
    regex_t exp;
    Mem="LX"+Mem+" ";
    rv = regcomp(&exp, Mem.c_str() , REG_EXTENDED);
    errs()<<"||||||||||||||||||||||\n";
    errs()<<Mem<<"\n";
    errs()<< Info->InfoPool[InfoIndex]->Origin;
    errs()<<tmp<<"\n";
    regmatch_t matches[1];
    while(!NCode.eof()){
    	for(int i=0; i<200;++i){
    	    xline[i]='\0';
    	}
        NCode.getline(xline,200);
        linebuff=xline;
        if(regexec(&exp,xline,1,matches,0)==0){
        	errs()<<xline<<"\n";
        	if(Info->InfoPool[InfoIndex]->Type==loadCONST || Info->InfoPool[InfoIndex]->Type==loadVARCONST){ //if firmware is handling loading of constant - insert 0
        		errs()<<"\n\n Handling constant";
        		linebuff.replace(linebuff.length()-1,1,"0");
        		errs()<<linebuff <<"\n\n\n";
        	}
        	for(int i=0;i<2;++i){
        		if(Info->InfoPool[InfoIndex]->Init[i]!=NULL && dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[i])->getOpcode()== Instruction::Mul){
        			Value *constValue;
        			constValue= dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[i])->getOperand(1);
        			errs()<<*constValue<<"\n";
        			int ProperMult = 1;
        			if (llvm::ConstantInt* CI = dyn_cast<llvm::ConstantInt>(constValue)) {
        				ProperMult= CI->getSExtValue();
        			}
        			std::stringstream ss;
        			ss<<ProperMult;
        			linebuff.erase(linebuff.length()-1,1);
        			linebuff=linebuff+ss.str();
        	}
        	}

        }

        megabuff=megabuff + linebuff + "\n";
    }
    std::string ntmp;
    raw_fd_ostream *FileDump = new raw_fd_ostream(tmp.c_str(), ntmp);
    *FileDump<<megabuff;
    delete FileDump;
    errs()<<"||||||||||||||||||||||||\n";
}


void FwIntegrator::CallGenerator(Module *TheModule, BasicBlock *Target){
	   static IRBuilder<> Builder(getGlobalContext());
	    Function *Funct;
	    CallInst *Call;
	    CallInst *WrkCall;
	    BasicBlock::iterator It=Target->begin();
	    llvm::Value* constValue;

	    ///////////////init table insert
		Funct=TheModule->getFunction("fw_init_table");
		Call=Builder.CreateCall(Funct);
		Call->insertBefore(It);

		//////////////////init firmware insert
	    Funct=TheModule->getFunction("fw_init_fw");
	    constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), FwCount);
	    Call=Builder.CreateCall(Funct,constValue,"wrk_id");
	    Call->insertBefore(It);
	    WrkCall=Call;
	    errs()<<*Target;

	    ///////////////////init data calls

	    std::vector<int>::iterator TIT = Map.Type.begin();
	    errs()<<"\n\n"<<Map.Address.size()<<"Map size \n\n";
	    int i=0;
	    std::string sendStore="";
	    for(std::vector<std::string>::iterator InfoIt=Map.Address.begin();InfoIt!=Map.Address.end();InfoIt++){
	    	    	errs()<<*InfoIt<<"\n";
	    }

	    for(std::vector<int>::iterator InfoIt=Map.Type.begin();InfoIt!=Map.Type.end();InfoIt++){
	    	    	    	errs()<<*InfoIt<<"\n";
	    	    }

	    for(std::vector<std::string>::iterator InfoIt=Map.Address.begin();InfoIt!=Map.Address.end();InfoIt++){
	    	errs()<<*InfoIt<<"\n";
	    	if(*TIT!=storeClassic){
	    		std::string send=*InfoIt;

	    		if(Target->getParent()->getName() == "bce_caclhit_constlen_for.body"){
	    		FwIntegrator::LoadDataCallGenerator(TheModule,Target,Call,It,send,i+1,0);
	    		}else{
	    			FwIntegrator::LoadDataCallGenerator(TheModule,Target,Call,It,send,i,0);
	    		}

	    		i++;
	    	}else{
	    		sendStore=*InfoIt;
	    	}
	    	TIT++;
	    }


	    //////////////////operation startup calls
	    Funct=TheModule->getFunction("fw_op_start");
	    Call=Builder.CreateCall(Funct,WrkCall);
	    Call->insertBefore(It);
	    FwIntegrator::LoadDataCallGenerator(TheModule,Target,WrkCall,It,sendStore,Info->InfoCount-1,1);
}

void FwIntegrator::FakeLinkMems(IndvarMod::MemInit *MBSideMem, std::string *Mem, int InfoIndex, BasicBlock *Target ){
errs() << " +++++++++++++ \n +++++++ \n +++\n";
std::vector<std::string> MemString;

// FIXME: just temporary, a small bug in memory assigning
// but just to be sure for the final demonstration, keep this fixed
// for normal operation, default behavior should be ok
if(Target->getParent()->getName() == "bce_sqr_sub_for.body"){
	MemString.push_back("MBANK_A, 0");
	MemString.push_back("MBANK_A, 512");
	MemString.push_back("MBANK_C, 0");
	MemString.push_back("MBANK_B, 0");
	MemString.push_back("MBANK_C, 512");
	MemString.push_back("MBANK_B, 512");
}else if(Target->getParent()->getName() == "bce_select2_constlen_for.body"){
	MemString.push_back("MBANK_B, 512");
	MemString.push_back("MBANK_A, 0");
	MemString.push_back("MBANK_C, 512");
	MemString.push_back("MBANK_B, 0");
	MemString.push_back("MBANK_A, 512");
	MemString.push_back("MBANK_C, 0");
}else if(Target->getParent()->getName() == "bce_caclhit_constlen_for.body"){
	MemString.push_back("MBANK_D, 512");
	MemString.push_back("MBANK_D, 0");
	MemString.push_back("MBANK_A, 512");
	MemString.push_back("MBANK_C, 0");
	MemString.push_back("MBANK_A, 0");
	MemString.push_back("MBANK_B, 512");
	MemString.push_back("MBANK_B, 0");
	MemString.push_back("MBANK_C, 512");
	InfoIndex--;
}
errs()<<InfoIndex<<"\n";
*Mem = MemString[InfoIndex];
errs() << " \n+++ \n +++++++ \n +++++++++++++\n";
}

void FwIntegrator::LoadDataCallGenerator(Module *TheModule, BasicBlock *Target,CallInst *WrkId, BasicBlock::iterator it,std::string Mem,int InfoIndex,int LoadMarker){
	static IRBuilder<> Builder(getGlobalContext());
		Function *Funct;
		CallInst *Call;
		int NumArgs=9;
		if(LoadMarker==0){
			Funct=TheModule->getFunction("fw_data_init");


		}else{
			Funct=TheModule->getFunction("fw_data_get");
			//SmallVector<Value*,8> Input;
			NumArgs=8;
		}


		llvm::Value* constValue;
        SmallVector<Value*,9> Input;
		Input.push_back(WrkId); //create reference to worker


		FwIntegrator::LinkMems(Info->InfoPool[InfoIndex],&Mem);
		if(!LoadMarker)
		FwIntegrator::FakeLinkMems(Info->InfoPool[InfoIndex],&Mem,InfoIndex,Target);
		/////////// insert offset
		unsigned int offset;

		offset=strtol(Mem.substr(9).c_str(), NULL, 0);

		constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), offset);
		Input.push_back(constValue);
		///////////

		errs()<<"\n\n ORIGIN \n"<<*Info->InfoPool[InfoIndex]->Origin<< "||||"<< Mem<< "\n\n";

		//////////insert bank code
		unsigned int bank;
		if(Mem.substr(0,7)=="MBANK_A")
			bank=0;
		if(Mem.substr(0,7)=="MBANK_B")
			bank=1;
		if(Mem.substr(0,7)=="MBANK_C")
			bank=2;
		if(Mem.substr(0,7)=="MBANK_D")
			bank=3;

		constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), bank);
		Input.push_back(constValue);
		///////////


		//////////insert increment factor - signalizing changes

		if(LoadMarker==0){
			FwIntegrator::InsertLoadDefInfo(Mem, InfoIndex);
		}else if(LoadMarker==1){
            FwIntegrator::InsertStoreDefInfo(Mem,InfoIndex);
		}

		int IncFactor=2;
		if(Info->InfoPool[InfoIndex]->Type !=loadMOD && Info->InfoPool[InfoIndex]->Type !=storeMOD){
			IncFactor=1;
		}

		if(Info->InfoPool[InfoIndex]->Type == loadCONST ){
			errs()<<"CONSTANT\n\n";
			IncFactor=0;
		}
		if( Info->InfoPool[InfoIndex]->Type == loadVARCONST){
			IncFactor=-1;
		}

		errs()<<"load gen\n"<<*Info->InfoPool[InfoIndex]->Origin<<"|"<<Info->InfoPool[InfoIndex]->Type;
		constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), IncFactor);
		Input.push_back(constValue);
		//////////////

		/////////////insert memory pointer
		constValue=ConstantPointerNull::get(PointerType::getFloatPtrTy(getGlobalContext())); //def value

		Instruction *OriginScevgep=NULL;
		if(LoadMarker==0 && Info->InfoPool[InfoIndex]->Type!=loadCONST && Info->InfoPool[InfoIndex]->Type!=loadVARCONST){ //classic memory pointer
		    OriginScevgep= dyn_cast<Instruction>(dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Origin)->getOperand(0));
		    errs()<<"Explicit store\n";
		}else if(LoadMarker==1 && Info->InfoPool[InfoIndex]->Type!=loadCONST && Info->InfoPool[InfoIndex]->Type!=loadVARCONST){ //classic memory pointer
			OriginScevgep= dyn_cast<Instruction>(dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Origin)->getOperand(1));
		}
		if(Info->InfoPool[InfoIndex]->Type!=loadCONST && Info->InfoPool[InfoIndex]->Type!=loadVARCONST){
			constValue= OriginScevgep->getOperand(0); //if classic memory pointer, extract address from scevgep operand
		}else{ //different constants
			if(Info->InfoPool[InfoIndex]->Type==loadCONST){ //numeric literals
				constValue=ConstantPointerNull::get(PointerType::getFloatPtrTy(getGlobalContext()));
			}
			if(Info->InfoPool[InfoIndex]->Type==loadVARCONST){ // "different" variables
				constValue=dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Origin)->getOperand(0);
			}
		}

		errs()<<*OriginScevgep<<" : mem type:" <<Info->InfoPool[InfoIndex]->Type<<"  " << Info->InfoCount <<"\n";

		Input.push_back(constValue);
		/////////////


		//errs()<<"\n\n----------InsertMods---------\n";
		///////////////insert modificators

		//errs()<< "Origin:"<<*(Info->InfoPool[InfoIndex]->Origin)<<"\n";
		if(Info->InfoPool[InfoIndex]->Init[0]!=NULL && dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[0])->getOpcode()!= Instruction::Mul){
			constValue= dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[0])->getOperand(1);
			Input.push_back(constValue);
		}else{
			constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), 0);
			Input.push_back(constValue);
		}
		///////////////


		//errs()<<".............\n";
		///////////////insert modificators
		constValue=NULL;
		for(int i=0;i<2;i++){
			if(Info->InfoPool[InfoIndex]->Init[i]!=NULL && dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[i])->getOpcode()== Instruction::Mul ){
				constValue= dyn_cast<Instruction>(Info->InfoPool[InfoIndex]->Init[i])->getOperand(1);
			}
		}
		if(constValue==NULL){
			constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), 1);
		}
		Input.push_back(constValue);
		///////////////
		//errs()<<"-------InsertMods---------\n\n\n";


		//////////////insert trip count
		constValue= ConstantInt::get(Type::getInt32Ty(getGlobalContext()), Info->TripCount);
		Input.push_back(constValue);
		//////////////

		if(LoadMarker==0){
		    //////////////insert constant float if this is the case of constant
			if(Info->InfoPool[InfoIndex]->Type!=loadCONST){
				constValue=ConstantFP::get(Type::getFloatTy(getGlobalContext()),0);
			}else{
				constValue=Info->InfoPool[InfoIndex]->Origin;
			}
		    Input.push_back(constValue);
		    errs()<<"constant 0 trip inserted\n";
		    //////////////
		}



		for (size_t i = 0; i < Input.size(); i++)
				{
						const FunctionType *FTy =
							cast<FunctionType>(cast<PointerType>(Funct->getType())->getElementType());


						errs() << "Args " << i << " " << *Input[i]->getType() << " expected " << *FTy->getParamType(i) << "\n";
				}
		errs()<<"Creating call\n";


		if(LoadMarker==1){
		   Input.resize(8);
		}
		llvm::ArrayRef<Value*> Params=llvm::ArrayRef<Value*>(Input);
		Call=Builder.CreateCall(Funct,Params);
		errs()<<*Call<<"\n";
		Call->insertBefore(it);

		Input.erase(Input.begin(),Input.end());
}

int FwIntegrator::GetNumArgsFromParentF(Value *Origin){
	int RetVal=0;
	if(isa<Instruction>(*Origin->use_begin())){
    	//errs()<<"ALMOST HAVE FUNCTION\n";
        Instruction *FAccess=dyn_cast<Instruction>(*Origin->use_begin());
        RetVal=(int)FAccess->getParent()->getParent()->getNumOperands();
    }

	return RetVal;
}

void FwIntegrator::LinkMems(IndvarMod::MemInit *MBSideMem, std::string *Mem){
	//errs()<<*Mem<<"\n";
	if(MBSideMem->Type==loadCONST){
     // errs()<<"CONST:  "<<*MBSideMem->Origin<<"\n";
      int ArgCount= FwIntegrator::GetNumArgsFromParentF(MBSideMem->Origin);
      FwIntegrator::ExtractMemID(ArgCount,Mem,0);

	}else if(MBSideMem->Type==loadVARCONST){
		//errs()<<"varCONST:  "<<*MBSideMem->Origin<<"\n";
		if(isa<LoadInst>(MBSideMem->Origin)){
			Value *Param = dyn_cast<Instruction>(MBSideMem->Origin)->getOperand(0);
			if(isa<Argument>(Param)){
				errs()<<"Poradove cislo "<< dyn_cast<Argument>(Param)->getArgNo()<<"\n";
				FwIntegrator::ExtractMemID(dyn_cast<Argument>(Param)->getArgNo(),Mem,0);
			}
		}

	}else{
		//errs()<<"classic:  "<<*MBSideMem->Origin<<"\n";
		if(isa<LoadInst>(MBSideMem->Origin)){
		//	errs()<<"je toi load\n";
			Value *SCEVInst=dyn_cast<Instruction>(MBSideMem->Origin)->getOperand(0);
			Value *Param = dyn_cast<Instruction>(SCEVInst)->getOperand(0);
			if(isa<Argument>(Param)){
				//errs()<<"Poradove cislo "<< dyn_cast<Argument>(Param)->getArgNo()<<"\n";
				FwIntegrator::ExtractMemID(dyn_cast<Argument>(Param)->getArgNo(),Mem,0);
			}
		}else if(isa<StoreInst>(MBSideMem->Origin)){
			//	errs()<<"je toi store\n";
				Value *SCEVInst=dyn_cast<Instruction>(MBSideMem->Origin)->getOperand(1);
				Value *Param = dyn_cast<Instruction>(SCEVInst)->getOperand(0);
				if(isa<Argument>(Param)){
				//	errs()<<"Poradove cislo "<< dyn_cast<Argument>(Param)->getArgNo()<<"\n";
					FwIntegrator::ExtractMemID(dyn_cast<Argument>(Param)->getArgNo(),Mem,1);
				}
		}

	}

}

void FwIntegrator::ExtractMemID(unsigned int ArgNum, std::string *Mem, int store){
	if(!store){
        for(unsigned int i=0; i<Map.Address.size();i++){
        	errs()<<"Adresa: "<<Map.Address[i]<<"\n";
        	std::stringstream ss;
        	ss<<Map.Address[i][Map.Address[i].length()-2];
        	unsigned int num ;
        	ss>>num;
        	errs()<<num<<"|"<<ArgNum<<"\n";
        	if(num==ArgNum){
        		*Mem=Map.Address[i].substr(2,Map.Address[i].length()-7);
        		errs()<<*Mem<<"|\n";
        		return;
        	}
        }
	}
	if(store){
		unsigned int i=Map.Address.size()-1;
		std::stringstream ss;
		ss<<Map.Address[i][Map.Address[i].length()-2];
		unsigned int num ;
		ss>>num;
		//errs()<<num<<"|"<<ArgNum<<"\n";
		if(num==ArgNum){
		    *Mem=Map.Address[i].substr(2,Map.Address[i].length()-7);
		  //  errs()<<*Mem<<"|\n";
		    return;
		}
	}
}

}
