/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#include "llvm/MC/MachineLocation.h"
#include "llvm/MC/MCCodeGenInfo.h"
#include "llvm/MC/MCInstrInfo.h"
#include "llvm/MC/MCRegisterInfo.h"
#include "llvm/MC/MCStreamer.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/TargetRegistry.h"

#include "MCTargetDesc/CodasipMCTargetDesc.h"
#include "MCTargetDesc/CodasipMCAsmInfo.h"

#define GET_INSTRINFO_MC_DESC
#include "CodasipGenInstrInfo.inc"

#define GET_SUBTARGETINFO_MC_DESC
#include "CodasipGenSubtargetInfo.inc"

#define GET_REGINFO_MC_DESC
#include "CodasipGenRegisterInfo.inc"

using namespace llvm;

static MCInstrInfo *createCodasipMCInstrInfo() {
  MCInstrInfo *X = new MCInstrInfo();
  InitCodasipMCInstrInfo(X);
  return X;
}

static MCRegisterInfo *createCodasipMCRegisterInfo(StringRef TT) {
  MCRegisterInfo *X = new MCRegisterInfo();
  //InitCodasipMCRegisterInfo(X, Codasip::RA);
  return X;
}

static MCSubtargetInfo
*createCodasipMCSubtargetInfo(StringRef TT, StringRef CPU, StringRef FS) {
  MCSubtargetInfo *X = new MCSubtargetInfo();
  InitCodasipMCSubtargetInfo(X, TT, CPU, FS);
  return X;
}

static MCAsmInfo *createCodasipMCAsmInfo(const Target &T, StringRef TT) {
  MCAsmInfo *MAI = new CodasipTargetAsmInfo(T, TT);
  //MachineLocation Dst(MachineLocation::VirtualFP);
  //MachineLocation Src(Codasip::SP, 0);
  //MAI->addInitialFrameState(0, Dst, Src);
  return MAI;
}

static MCCodeGenInfo *createCodasipMCCodeGenInfo
(StringRef TT, Reloc::Model RM, CodeModel::Model CM) {
  MCCodeGenInfo *X = new MCCodeGenInfo();
  //if (RM == Reloc::Default) RM = Reloc::PIC_;
  X->InitMCCodeGenInfo(RM, CM);
  return X;
}

static MCStreamer *createMCStreamer
(const Target &T, StringRef TT, MCContext &Ctx, MCAsmBackend &MAB, raw_ostream &_OS, MCCodeEmitter *_Emitter, bool RelaxAll, bool NoExecStack) {
  Triple TheTriple(TT);
  return createELFStreamer(Ctx, MAB, _OS, _Emitter, RelaxAll, NoExecStack);
}

extern "C" void LLVMInitializeCodasipTargetMC()
{
  // Register the MC asm info.
  RegisterMCAsmInfoFn X(TheCodasipTarget, createCodasipMCAsmInfo);
  // Register the MC codegen info.
  TargetRegistry::RegisterMCCodeGenInfo(TheCodasipTarget, createCodasipMCCodeGenInfo);
  // Register the MC instruction info.
  TargetRegistry::RegisterMCInstrInfo(TheCodasipTarget, createCodasipMCInstrInfo);
  // Register the MC register info.
  TargetRegistry::RegisterMCRegInfo(TheCodasipTarget, createCodasipMCRegisterInfo);
  // Register the object streamer.
  TargetRegistry::RegisterMCObjectStreamer(TheCodasipTarget, createMCStreamer);
  // Register the MC subtarget info.
  TargetRegistry::RegisterMCSubtargetInfo(TheCodasipTarget, createCodasipMCSubtargetInfo);
}

