/*******************************************************************************
 * This file is part of the PB2DFU library developed
 * within the EU Artemis project SMECY (Smart Multicore Embedded Systems)
 * Artemis JU 100230 and MSMT 7H10001,       http://www.smecy.eu
 * Copyright (C) 2011 UTIA AV CR, v.v.i.     http://sp.utia.cz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even 
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.
 *
 * This file has been released within the SMECY project
 * consortium for the requirements of the SMECY project.
 * Any use outside the SMECY consortium and/or for any
 * developments outside the scope of the SMECY project is prohibited.
 *
 * For more details contact Roman Bartosinski <bartosr@utia.cas.cz>.
 *******************************************************************************
 * Filename  : dfu_fp01_1x1_fir.h
 * Authors   : Roman Bartosinski <bartosr@utia.cas.cz>
 * Project   : SMECY
 * Purpose   : Header file of firmware API for DFU_FP01_1x1 hardware accelerator
 * Release   : 
 * Version   : 0.1
 * Date      : 2011/01/10
 *
 * Long Description:
 *  Functions, constants and definitions specific for the DFU_FP01_1x1
 *  hardware accelerator in EdkDSP platform. This version is temporary and it
 *  is used to avoid constraints from the current version of PB C compiler.
 * 
 *******************************************************************************
 * Modifications:
 *  Author: Roman Bartosinski
 *  Date  : 2011/04/18
 *  Description: Renamed functions and constants in PB2MB interface:
 *      MB2PB -> PB2MB, PB2MB_FL_ -> PB2MB_STAT_, MB2PB_FL_ -> PB2MB_CTRL_, ...
 *  --
 *  
 ******************************************************************************/

#ifndef _DFU_FP01_1X1_HEADER_
#define _DFU_FP01_1X1_HEADER_

/*
 * dfu_fp01_operations - codes of operations supported by DFU_FP01
 * @DFU_OP_VVER: ask about HW version
 * @DFU_OP_VZ2A: copy vector    a[i] <= z[j]
 * @DFU_OP_VB2A: copy vector    a[i] <= b[j]
 * @DFU_OP_VZ2B: copy vector    b[i] <= z[j]
 * @DFU_OP_VA2B: copy vector    b[i] <= a[j]
 * @DFU_OP_VADD: add vectors    z[i] <= a[j] + b[k]
 * @DFU_OP_VADD_BZ2A: add vectors    a[i] <= b[j] + z[k]
 * @DFU_OP_VADD_AZ2B: add vectors    b[i] <= a[j] + z[k]
 * @DFU_OP_VSUB: sub vectors    z[i] <= a[j] - b[k]
 * @DFU_OP_VSUB_BZ2A: sub vectors    a[i] <= b[j] + z[k]
 * @DFU_OP_VSUB_AZ2B: sub vectors    b[i] <= a[j] + z[k]
 * @DFU_OP_VMULT: mult vectors   z[i] <= a[j] * b[k]
 * @DFU_OP_VMULT_BZ2A: mult vectors   a[i] <= b[j] * z[k]
 * @DFU_OP_VMULT_AZ2B: mult vectors   b[i] <= a[j] * z[k]
 * @DFU_OP_VPROD: vector product z    <= a[i..i+nn]*b[i..i+nn]
 * @DFU_OP_VMAC: vector MAC     z[i] <= z[i] + a[j]*b[k] 1..13
 * @DFU_OP_VMSUBAC: vector MSUBAC  z[i] <= z[i] - a[j]*b[k] 1..13
 */
/*
enum dfu_fp01_operations {
  DFU_OP_VVER       = 0x00,	// ask about HW version
  DFU_OP_VZ2A       = 0x01,	// copy vector    a[i] <= z[j]
  DFU_OP_VB2A       = 0x02,	// copy vector    a[i] <= b[j]
  DFU_OP_VZ2B       = 0x03,	// copy vector    b[i] <= z[j]
  DFU_OP_VA2B       = 0x04,	// copy vector    b[i] <= a[j]
  DFU_OP_VADD       = 0x05,	// add vectors    z[i] <= a[j] + b[k]
  DFU_OP_VADD_BZ2A  = 0x06,	// add vectors    a[i] <= b[j] + z[k]
  DFU_OP_VADD_AZ2B  = 0x07,	// add vectors    b[i] <= a[j] + z[k]
  DFU_OP_VSUB       = 0x08,	// sub vectors    z[i] <= a[j] - b[k]
  DFU_OP_VSUB_BZ2A  = 0x09,	// sub vectors    a[i] <= b[j] + z[k]
  DFU_OP_VSUB_AZ2B  = 0x0A,	// sub vectors    b[i] <= a[j] + z[k]
  DFU_OP_VMULT      = 0x0B,	// mult vectors   z[i] <= a[j] * b[k]
  DFU_OP_VMULT_BZ2A = 0x0C,	// mult vectors   a[i] <= b[j] * z[k]
  DFU_OP_VMULT_AZ2B = 0x0D,	// mult vectors   b[i] <= a[j] * z[k]
  DFU_OP_VPROD      = 0x0E, // vector product z    <= a[i..i+nn]*b[i..i+nn]
  DFU_OP_VMAC       = 0x0F, // vector MAC     z[i] <= z[i] + a[j]*b[k] 1..13
  DFU_OP_VMSUBAC    = 0x10, // vector MSUBAC  z[i] <= z[i] - a[j]*b[k] 1..13
};
*/
#define DFU_OP_VVER       0x00 // ask about HW version
#define DFU_OP_VZ2A       0x01 // copy vector    a[i] <= z[j]
#define DFU_OP_VB2A       0x02 // copy vector    a[i] <= b[j]
#define DFU_OP_VZ2B       0x03 // copy vector    b[i] <= z[j]
#define DFU_OP_VA2B       0x04 // copy vector    b[i] <= a[j]
#define DFU_OP_VADD       0x05 // add vectors    z[i] <= a[j] + b[k]
#define DFU_OP_VADD_BZ2A  0x06 // add vectors    a[i] <= b[j] + z[k]
#define DFU_OP_VADD_AZ2B  0x07 // add vectors    b[i] <= a[j] + z[k]
#define DFU_OP_VSUB       0x08 // sub vectors    z[i] <= a[j] - b[k]
#define DFU_OP_VSUB_BZ2A  0x09 // sub vectors    a[i] <= b[j] + z[k]
#define DFU_OP_VSUB_AZ2B  0x0A // sub vectors    b[i] <= a[j] + z[k]
#define DFU_OP_VMULT      0x0B // mult vectors   z[i] <= a[j] * b[k]
#define DFU_OP_VMULT_BZ2A 0x0C // mult vectors   a[i] <= b[j] * z[k]
#define DFU_OP_VMULT_AZ2B 0x0D // mult vectors   b[i] <= a[j] * z[k]
#define DFU_OP_VPROD      0x0E // vector product z    <= a[i..i+nn]*b[i..i+nn]
#define DFU_OP_VMAC       0x0F // vector MAC     z[i] <= z[i] + a[j]*b[k] 1..13
#define DFU_OP_VMSUBAC    0x10 // vector MSUBAC  z[i] <= z[i] - a[j]*b[k] 1..13


/*
 * enum dfu_fp01_memories - IDs of data memories in DFU_FP01
 * @DFU_MEM_A: select memory A
 * @DFU_MEM_B: select memory B
 * @DFU_MEM_Z: select memory Z
 */
/*
enum dfu_fp01_memories {
	DFU_MEM_A,
	DFU_MEM_B,
	DFU_MEM_Z
};
*/
#define DFU_MEM_A 0x00
#define DFU_MEM_B 0x01
#define DFU_MEM_Z 0x02

/******************************************************************************/
#define PB2MB_MODE_BYTE  0x01 // send user value (byte)
#define PB2MB_MODE_EOL   0x03 // send end of transaction/message
#define PB2MB_MODE_REQ   0x07 // send request for reset
#define PB2MB_MODE_RESET 0x08 // send reset acknowledge


/* functions - interface MB-PB */
unsigned char pb2mb_read_data();
void pb2mb_write_data(unsigned char data);
void pb2mb_eoc(unsigned char data);
void pb2mb_req_reset(unsigned char data);
void pb2mb_reset();
/* functions - interface PB-DFU */
void pb2dfu_wait4hw();
void pb2dfu_start_op(unsigned char op, unsigned char cnt);


void pb2dfu_set_addr_A(unsigned char addr);
void pb2dfu_set_bank_A(unsigned char bank);
void pb2dfu_set_fulladdr_A(unsigned char bank, unsigned char addr);
void pb2dfu_set_inc_A(unsigned short inc);
void pb2dfu_set_restart_addr_A(unsigned char addr);

void pb2dfu_set_addr_B(unsigned char addr);
void pb2dfu_set_bank_B(unsigned char bank);
void pb2dfu_set_fulladdr_B(unsigned char bank, unsigned char addr);
void pb2dfu_set_inc_B(unsigned short inc);
void pb2dfu_set_restart_addr_B(unsigned char addr);

void pb2dfu_set_addr_Z(unsigned char addr);
void pb2dfu_set_bank_Z(unsigned char bank);
void pb2dfu_set_fulladdr_Z(unsigned char bank, unsigned char addr);
void pb2dfu_set_inc_Z(unsigned short inc);
void pb2dfu_set_restart_addr_Z(unsigned char addr);


#endif /* _DFU_FP01_1X1_HEADER_ */
