/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#ifndef CODASIPGENINSTRUCTIONINFO_H
#define CODASIPGENINSTRUCTIONINFO_H

#include "Codasip.h"
#include "CodasipRegisterInfo.h"
#include "llvm/Target/TargetInstrInfo.h"
#include "llvm/CodeGen/ScheduleHazardRecognizer.h"

#define GET_INSTRINFO_ENUM
#define GET_INSTRINFO_HEADER
#include "CodasipGenInstrInfo.inc"

namespace llvm {
  
  class CodasipGenInstrInfo2: public CodasipGenInstrInfo {
    
    const CodasipRegisterInfo RI;
    
    public:
      explicit CodasipGenInstrInfo2(CodasipTargetMachine &TM);
      
      virtual const TargetRegisterInfo &getRegisterInfo() const {return RI;}
      
      virtual void copyPhysReg(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI, DebugLoc DL,
                               unsigned DestReg, unsigned SrcReg, bool KillSrc) const;
      
      virtual void
      storeRegToStackSlot(MachineBasicBlock &MBB, MachineBasicBlock::iterator MBBI, unsigned SrcReg, bool isKill, int FrameIndex,
                          const TargetRegisterClass *RC, const TargetRegisterInfo *TRI) const;

      virtual void
      loadRegFromStackSlot(MachineBasicBlock &MBB, MachineBasicBlock::iterator MBBI, unsigned DestReg, int FrameIndex,
                           const TargetRegisterClass *RC, const TargetRegisterInfo *TRI) const;
      
      virtual unsigned InsertBranch(MachineBasicBlock &MBB, MachineBasicBlock *TBB, MachineBasicBlock *FBB,
                                    const SmallVectorImpl<MachineOperand> &Cond, DebugLoc DL) const;
      
      // VLIW-related methods
      void insertNoop(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI) const;
      void insertNoopOnPos(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI,unsigned pos) const;
      void getAllPosInBundle(std::string &Instr, std::vector<int> &vect) const;
      void swapInstrInBundle(MachineFunction *MF, SUnit *unit, int pos) const;
  };

}

#endif
