/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#include "CodasipInstrInfo.h"
#include "llvm/ADT/STLExtras.h"
#include "llvm/ADT/SmallVector.h"
#include "llvm/CodeGen/MachineInstrBuilder.h"
#include "llvm/CodeGen/ScheduleDAG.h"

#include "CodasipTargetMachine.h"

#define GET_INSTRINFO_CTOR
#include "CodasipGenInstrInfo.inc"

#include <cstdio>
#include <iostream>
#include <vector>

llvm::CodasipGenInstrInfo2::CodasipGenInstrInfo2(CodasipTargetMachine &TM)
: CodasipGenInstrInfo(Codasip::CALLSTART,Codasip::CALLEND), RI(*this) {}

// R2R moves
void llvm::CodasipGenInstrInfo2::
copyPhysReg(MachineBasicBlock &MBB, MachineBasicBlock::iterator I, DebugLoc DL,
            unsigned DestReg, unsigned SrcReg, bool KillSrc) const
{
  // check all supported combinations
  /*if ((Codasip::gpregsRegClass.contains(SrcReg)) && (Codasip::gpregsRegClass.contains(DestReg)))
  {
    BuildMI(MBB,I,DL, get(Codasip::instr_special_rrr__ops_movz__gpr_std__gpr_std__gpr0__), DestReg).addReg(SrcReg,getKillRegState(KillSrc));
  }
  else*/
  {
    assert(false && "It's impossible to perform this copy.");
  }
}

// R2S stores
void llvm::CodasipGenInstrInfo2::
storeRegToStackSlot(MachineBasicBlock &MBB, MachineBasicBlock::iterator I, unsigned Reg, bool isKill, int FrameIndex,
                    const TargetRegisterClass *RC, const TargetRegisterInfo *TRI) const
{
  assert(false && "this is not allowed");
}

// S2R loads
void llvm::CodasipGenInstrInfo2::
loadRegFromStackSlot(MachineBasicBlock &MBB, MachineBasicBlock::iterator I, unsigned Reg, int FrameIndex,
                     const TargetRegisterClass *RC, const TargetRegisterInfo *TRI) const
{
  assert(false && "this is not allowed");
}

// only for tail-merging
unsigned llvm::CodasipGenInstrInfo2::
InsertBranch(MachineBasicBlock &MBB, MachineBasicBlock *TBB, MachineBasicBlock *FBB,
             const SmallVectorImpl<MachineOperand> &Cond, DebugLoc DL) const
{
  assert(Cond.empty() && FBB==NULL);
  //BuildMI(&MBB,DL, get(Codasip::instr_direct_branch_rri__op_beq__gpr0__gpr0__rel_offset16__)).addMBB(TBB);
  return 1;
}

//adding NO-OP instruction to code
void llvm::CodasipGenInstrInfo2::insertNoop(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI) const {
  DebugLoc DL;
  /*if (MI!=MBB.end()) DL=MI->getDebugLoc();
    BuildMI(MBB, MI, DL, get(Codasip::instr_special_shift_rrs__ops_sll__gpr0__gpr0__uimm5__));*/
}

//adding specific NO-OP instruction to code on specific position
void llvm::CodasipGenInstrInfo2::insertNoopOnPos(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI, unsigned pos) const {
  assert(false && "this is not allowed");
}

//function return array in vector with all positions, where
//instruction can be
void llvm::CodasipGenInstrInfo2::getAllPosInBundle(std::string &Instr, std::vector<int> &vect) const {
  
}

//method for swap instruction on position
//if instruction on the other position has another asm syntax,
//we swap it with instruction with correct syntax
void llvm::CodasipGenInstrInfo2::swapInstrInBundle(MachineFunction *MF, SUnit *unit, int pos) const {
  assert(false && "this is not allowed");
}
