/** @file deceive.h
* hlavickovy soubor k deceive.cpp
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef DECEIVE_H
#define DECEIVE_H

#define WINDOWS_DEFAULT_HLIM 128
#define LINUX_DEFAULT_HLIM 64
#define ECHO_WAIT_LIMIT_SEC 0.5

// rezie ethernetu: 8 preambule + 14 hlavicka ramce + 4 CRC + 12 meziramcova mezera = 38
#define ETH_OVERHEAD 38

#include <netinet/ip6.h>
#include <netinet/tcp.h>
#include <list>

#include "config.h"

typedef struct sBytePkt {
  ip6_hdr ipv6_header;
  tcphdr tcp_header;
  uint8_t msg_byte;
} TBytePkt;

bool deceiveConditions(Packet *pkt, TConfig &cfg);

void * deceptionThread(void * cfg);
bool dec_processPacket(Packet *pkt, TConfig &cfg);

void sendWithNoise(TConnection *con, uint8_t *ipv6_datagram, unsigned int ipv6_datagramLen, string targetInterface, TConfig &cfg);
void waitNano(double nanoSec);
void sendNormally(uint8_t *ipv6_datagram, unsigned int ipv6_datagramLen, string ifName, TConfig &cfg);

void * hcThread(void * arg);

bool secretConnection(TConnection &con, TConfig &cfg);
TConnection * getConnectionPointer(in6_addr sndIP, in6_addr rcvIP, unsigned short int sndPort, unsigned short int rcvPort, TConfig &cfg);

TConnection * addConnection(in6_addr sndIP, in6_addr rcvIP, unsigned short int sndPort, unsigned short int rcvPort, TConfig &cfg);
void removeConnection(TConnection *con, TConfig &cfg);

bool compareAddresses(in6_addr address1, in6_addr address2);

bool ackToIgnore(unsigned long int ackNum, TConnection *con);
void addToIgnoreList(unsigned long int ackNum, TConnection *con);
void clearIgnoreList(TConnection *con);

bool processIcmpEchoReply(Packet *Packet, TConfig &cfg);
bool icmpReplyExists(in6_addr srcAddr, uint16_t id, uint16_t seq, TConfig &cfg);

#endif
