/** @file config.h
* Hlavickovy soubor k config.cpp
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef CONFIG_H
#define CONFIG_H

#include <list>

#include <arpa/inet.h>

#include "packet.h"

using namespace std;

// pravidlo pro preklad
typedef struct strRule {
  string inIf;
  struct in6_addr inPrefix;
  int inPrefixLength;
  struct in6_addr exPrefix;
  int exPrefixLength;
} TRule;

// vycet typu rozhrani
enum TInterfaceType {
  IN_IF,     // vnitrni
  OUT_IF,    // vnejsi
  UNKNOWN_IF  // nezname
};

typedef struct sAck {
  uint32_t ackNum;
  in6_addr sndIP;
  in6_addr rcvIP;
  unsigned short int sndPort;
  unsigned short int rcvPort;
} TAck;

typedef struct sConnection {
  bool active;                           // je spojeni aktivni?
  in6_addr sndIP;                        // IPv6 adresa odesilatele
  in6_addr rcvIP;                        // IPv6 adresa prijemce
  unsigned short int sndPort;            // TCP port odesilatele
  unsigned short int rcvPort;            // TCP port prijemce

  uint8_t hopCount;                 // minimalni pocet skoku pro dosazeni prijemce
  bool estimated_hc_set;            // byl jiz nastaven predpokladany pocet skoku?
  bool final_hc_set;                // byl jiz nstaven finalni (overeny) pocet skoku?
  bool hc_failure;                  // nepodarilo se overit pocet skoku

  pthread_t hc_thread;              // vlakno pro detekci poctu skoku v ramci tohoto spojeni
  pthread_mutex_t con_mutex;        // mutex spojeni
  string outIf;                     // nazev vnejsiho rozhrani

  void * cfgPtr;
} TConnection;

// struktura pro rozhrani
typedef struct strInterface {
  string name;          // nazev rozhrani, napr. em0
  TInterfaceType type;  // typ rozhrani vnitrni/vnejsi
  int *descr;           // pcap_t descriptor
  int fd;               // prideleny file descriptor
} TInterface;

typedef struct sIcmpReply {
  in6_addr srcAddr;
  uint16_t id;
  uint16_t seq;
} TIcmpReply;

typedef struct sConfig {
  /* konfigurace programu */
  string config_file;               // nazev konfiguracniho souboru

  in6_addr senderPrefix;            // podminka na IPv6 prefix odesilatele
  int senderPrefixLen;              // delka IPv6 prefixu odesilatele
  in6_addr receiverPrefix;          // podminka na IPv6 prefix prijemce
  int receiverPrefixLen;            // delka IPv6 prefixu prijemce
  unsigned int noiseAmount;         // mnozstvi sumu
  unsigned int senderPort;          // podminka na port odesilatele
  unsigned int receiverPort;        // podminka na port prijemce
  string fakeMsgFile1;              // nazev souboru s 1. podvrzenou zpravou
  string fakeMsgFile2;              // nazev souboru s 2. podvrzenou zpravou
  double pktNanoInterval;           // interval (v ns) mezi odesilanim jednobytovych paketu
  bool verbose;                     // "ukecany" rezim

  list<TRule> rules_list;           // seznam pravidel pro preklad
  list<TInterface> interface_list;  // seznam definovanych rozhrani

  fd_set read_set;                  // definujeme mnozinu deskriptoru rozhrani
  int max_fd;                       // nejvyssi pouzity file descriptor rozhrani

  pthread_t deception_thread;       // vlakno zajistujici utajeni pozadovane komunikace
  pthread_cond_t deception_cond;    // podminka pro cekani druheho vlakna
  bool newPacket;                   // prisel novy paket do seznamu

  /* stav programu  */
  bool main_loop;                   // povoleno provadeni hlavni smycky (zachytavani paketu)
  bool err;                         // nastala chyba
  bool interfaces_open;             // jsou otevrena rozhrani
  bool sig;                         // byl prijat signal
  bool reload;                      // je potreba znovu nacist konfiguraci
  string pkt_ifName;                // nazev rozhrani, kde byl zachycen aktualni paket
  TInterfaceType pkt_ifType;        // typ rozhrani, kde byl zachycen aktualni paket

  /* sdilene promenne mezi obema vlakny */
  list<Packet*> pkt_queue;    // fronta paketu pro druhe vlakno
  pthread_mutex_t pkt_queue_mutex;

  list<TConnection*> con_list;       // seznam aktivnich spojeni
  //pthread_mutex_t con_list_mutex;

  list<TIcmpReply> reply_list;
  pthread_mutex_t reply_mutex;

  pthread_mutex_t libnet_mutex;      // mutex pro pristup libnetu na rozhrani

} TConfig;

int loadConfig(TConfig &cfg);
int examineConfigRecord (string &key, string &value, TConfig &cfg);

int addTranslateRule(string &value, TConfig &cfg);
int addOutIf(string &value, TConfig &cfg);
int setSenderPrefix(string &value, TConfig &cfg);
int setSenderPort(string &value, TConfig &cfg);
int setReceiverPrefix(string &value, TConfig &cfg);
int setReceiverPort(string &value, TConfig &cfg);
int setNanoInterval(string &value, TConfig &cfg);
int setNoiseAmount(string &value, TConfig &cfg);
int setFakeMsgFile(int msgNum, string &value, TConfig &cfg);

#endif
