/*
  File autogenerated by gengetopt version 2.22.5
  generated with the following command:
  gengetopt --conf-parser --file-name=vtapi_settings --c-extension=cpp --no-handle-error -u

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "vtapi_settings.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: vtapi [OPTIONS] [COMMAND]";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help               Print help and exit",
  "  -V, --version            Print version and exit",
  "\nOPTIONS\n",
  "  -v, --verbose            Verbose output mode - write used SQL commands etc.",
  "\n Config arguments",
  "      --config=FILENAME    Config file location  (default=`./vtapi.conf')",
  "      --log=FILENAME       Log file location  (default=`./vtapi.log')",
  "  -u, --user=STRING        User name",
  "  -p, --password=STRING    User password",
  "  -l, --location=filename  Base location of data files",
  "  -c, --connection=STRING  Connection string \"host=.. port=.. dbname=.. \n                             user=.. password=..\"",
  "  -f, --format=STRING      Input/output format  (possible values=\"standard\", \n                             \"csv\", \"html\", \"binary\", \"sparse\", \n                             \"html\" default=`standard')",
  "  -i, --input=FILENAME     Read from specific input",
  "  -o, --output=FILENAME    Write to specific output",
  "\n Context specification (WHERE clause)",
  "  -W, --where=SQLSTRING    explicit WHERE, ex.: --where=\"features is NULL\"",
  "  -D, --dataset=STRING     Set dataset to use",
  "  -S, --sequence=STRING    Set sequence to use",
  "  -I, --interval=STRING    Set interval to use",
  "  -M, --method=STRING      Set method to use",
  "  -P, --process=STRING     Set process to use",
  "  -E, --selection=STRING   Set selection to use",
  "\nCOMMANDS\n\nEnter one command via argument or sequence of them in interactive mode\n\nquery SQLQUERY\n\n    * executes custom SQLQUERY\n    * ex.: list methods with active processes\n                   query SELECT DISTINCT mtname FROM public.processes\n\nselect dataset|sequence|interval|process|method|selection|help [ARGS]\n\n    *  selects data and prints them in specified format (-f option)\n    *  for detailed help about ARGS, use command \"select help\"\n    *  ex.: pick processes of method 'm1'\n                   select process method=m1\n\ninsert sequence|interval|process|help [ARGS]\n\n    *  inserts data into database\n    *  for detailed help about ARGS, use command \"insert help\"\n    *  ex.: insert interval in sequence 'seq1'\n                   insert interval t1=10 t2=20 sequence=seq1\n\nupdate *not implemented in CLI\n\ndelete *not implemented in CLI\n\nshow   *not implemented in CLI\n\ntest\n    * Tests VTApi methods and prints details\n\nhelp\n    * prints this help\n\nexit\n    * exits interactive mode (or enter EOF)\n",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *cmdline_parser_format_values[] = {"standard", "csv", "html", "binary", "sparse", "html", 0}; /*< Possible values for format. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->config_given = 0 ;
  args_info->log_given = 0 ;
  args_info->user_given = 0 ;
  args_info->password_given = 0 ;
  args_info->location_given = 0 ;
  args_info->connection_given = 0 ;
  args_info->format_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->where_given = 0 ;
  args_info->dataset_given = 0 ;
  args_info->sequence_given = 0 ;
  args_info->interval_given = 0 ;
  args_info->method_given = 0 ;
  args_info->process_given = 0 ;
  args_info->selection_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->config_arg = gengetopt_strdup ("./vtapi.conf");
  args_info->config_orig = NULL;
  args_info->log_arg = gengetopt_strdup ("./vtapi.log");
  args_info->log_orig = NULL;
  args_info->user_arg = NULL;
  args_info->user_orig = NULL;
  args_info->password_arg = NULL;
  args_info->password_orig = NULL;
  args_info->location_arg = NULL;
  args_info->location_orig = NULL;
  args_info->connection_arg = NULL;
  args_info->connection_orig = NULL;
  args_info->format_arg = gengetopt_strdup ("standard");
  args_info->format_orig = NULL;
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->where_arg = NULL;
  args_info->where_orig = NULL;
  args_info->dataset_arg = NULL;
  args_info->dataset_orig = NULL;
  args_info->sequence_arg = NULL;
  args_info->sequence_orig = NULL;
  args_info->interval_arg = NULL;
  args_info->interval_orig = NULL;
  args_info->method_arg = NULL;
  args_info->method_orig = NULL;
  args_info->process_arg = NULL;
  args_info->process_orig = NULL;
  args_info->selection_arg = NULL;
  args_info->selection_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->verbose_help = gengetopt_args_info_help[3] ;
  args_info->config_help = gengetopt_args_info_help[5] ;
  args_info->log_help = gengetopt_args_info_help[6] ;
  args_info->user_help = gengetopt_args_info_help[7] ;
  args_info->password_help = gengetopt_args_info_help[8] ;
  args_info->location_help = gengetopt_args_info_help[9] ;
  args_info->connection_help = gengetopt_args_info_help[10] ;
  args_info->format_help = gengetopt_args_info_help[11] ;
  args_info->input_help = gengetopt_args_info_help[12] ;
  args_info->output_help = gengetopt_args_info_help[13] ;
  args_info->where_help = gengetopt_args_info_help[15] ;
  args_info->dataset_help = gengetopt_args_info_help[16] ;
  args_info->sequence_help = gengetopt_args_info_help[17] ;
  args_info->interval_help = gengetopt_args_info_help[18] ;
  args_info->method_help = gengetopt_args_info_help[19] ;
  args_info->process_help = gengetopt_args_info_help[20] ;
  args_info->selection_help = gengetopt_args_info_help[21] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->config_arg));
  free_string_field (&(args_info->config_orig));
  free_string_field (&(args_info->log_arg));
  free_string_field (&(args_info->log_orig));
  free_string_field (&(args_info->user_arg));
  free_string_field (&(args_info->user_orig));
  free_string_field (&(args_info->password_arg));
  free_string_field (&(args_info->password_orig));
  free_string_field (&(args_info->location_arg));
  free_string_field (&(args_info->location_orig));
  free_string_field (&(args_info->connection_arg));
  free_string_field (&(args_info->connection_orig));
  free_string_field (&(args_info->format_arg));
  free_string_field (&(args_info->format_orig));
  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->where_arg));
  free_string_field (&(args_info->where_orig));
  free_string_field (&(args_info->dataset_arg));
  free_string_field (&(args_info->dataset_orig));
  free_string_field (&(args_info->sequence_arg));
  free_string_field (&(args_info->sequence_orig));
  free_string_field (&(args_info->interval_arg));
  free_string_field (&(args_info->interval_orig));
  free_string_field (&(args_info->method_arg));
  free_string_field (&(args_info->method_orig));
  free_string_field (&(args_info->process_arg));
  free_string_field (&(args_info->process_orig));
  free_string_field (&(args_info->selection_arg));
  free_string_field (&(args_info->selection_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->config_given)
    write_into_file(outfile, "config", args_info->config_orig, 0);
  if (args_info->log_given)
    write_into_file(outfile, "log", args_info->log_orig, 0);
  if (args_info->user_given)
    write_into_file(outfile, "user", args_info->user_orig, 0);
  if (args_info->password_given)
    write_into_file(outfile, "password", args_info->password_orig, 0);
  if (args_info->location_given)
    write_into_file(outfile, "location", args_info->location_orig, 0);
  if (args_info->connection_given)
    write_into_file(outfile, "connection", args_info->connection_orig, 0);
  if (args_info->format_given)
    write_into_file(outfile, "format", args_info->format_orig, cmdline_parser_format_values);
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->where_given)
    write_into_file(outfile, "where", args_info->where_orig, 0);
  if (args_info->dataset_given)
    write_into_file(outfile, "dataset", args_info->dataset_orig, 0);
  if (args_info->sequence_given)
    write_into_file(outfile, "sequence", args_info->sequence_orig, 0);
  if (args_info->interval_given)
    write_into_file(outfile, "interval", args_info->interval_orig, 0);
  if (args_info->method_given)
    write_into_file(outfile, "method", args_info->method_orig, 0);
  if (args_info->process_given)
    write_into_file(outfile, "process", args_info->process_orig, 0);
  if (args_info->selection_given)
    write_into_file(outfile, "selection", args_info->selection_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->connection_given)
    {
      fprintf (stderr, "%s: '--connection' ('-c') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  
  /* checks for dependences among options */
  if (args_info->password_given && ! args_info->user_given)
    {
      fprintf (stderr, "%s: '--password' ('-p') option depends on option 'user'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "config",	1, NULL, 0 },
        { "log",	1, NULL, 0 },
        { "user",	1, NULL, 'u' },
        { "password",	1, NULL, 'p' },
        { "location",	1, NULL, 'l' },
        { "connection",	1, NULL, 'c' },
        { "format",	1, NULL, 'f' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "where",	1, NULL, 'W' },
        { "dataset",	1, NULL, 'D' },
        { "sequence",	1, NULL, 'S' },
        { "interval",	1, NULL, 'I' },
        { "method",	1, NULL, 'M' },
        { "process",	1, NULL, 'P' },
        { "selection",	1, NULL, 'E' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVvu:p:l:c:f:i:o:W:D:S:I:M:P:E:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Verbose output mode - write used SQL commands etc..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* User name.  */
        
        
          if (update_arg( (void *)&(args_info->user_arg), 
               &(args_info->user_orig), &(args_info->user_given),
              &(local_args_info.user_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "user", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* User password.  */
        
        
          if (update_arg( (void *)&(args_info->password_arg), 
               &(args_info->password_orig), &(args_info->password_given),
              &(local_args_info.password_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "password", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Base location of data files.  */
        
        
          if (update_arg( (void *)&(args_info->location_arg), 
               &(args_info->location_orig), &(args_info->location_given),
              &(local_args_info.location_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "location", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Connection string \"host=.. port=.. dbname=.. user=.. password=..\".  */
        
        
          if (update_arg( (void *)&(args_info->connection_arg), 
               &(args_info->connection_orig), &(args_info->connection_given),
              &(local_args_info.connection_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "connection", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Input/output format.  */
        
        
          if (update_arg( (void *)&(args_info->format_arg), 
               &(args_info->format_orig), &(args_info->format_given),
              &(local_args_info.format_given), optarg, cmdline_parser_format_values, "standard", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "format", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Read from specific input.  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Write to specific output.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'W':	/* explicit WHERE, ex.: --where=\"features is NULL\".  */
        
        
          if (update_arg( (void *)&(args_info->where_arg), 
               &(args_info->where_orig), &(args_info->where_given),
              &(local_args_info.where_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "where", 'W',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* Set dataset to use.  */
        
        
          if (update_arg( (void *)&(args_info->dataset_arg), 
               &(args_info->dataset_orig), &(args_info->dataset_given),
              &(local_args_info.dataset_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "dataset", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* Set sequence to use.  */
        
        
          if (update_arg( (void *)&(args_info->sequence_arg), 
               &(args_info->sequence_orig), &(args_info->sequence_given),
              &(local_args_info.sequence_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "sequence", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'I':	/* Set interval to use.  */
        
        
          if (update_arg( (void *)&(args_info->interval_arg), 
               &(args_info->interval_orig), &(args_info->interval_given),
              &(local_args_info.interval_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "interval", 'I',
              additional_error))
            goto failure;
        
          break;
        case 'M':	/* Set method to use.  */
        
        
          if (update_arg( (void *)&(args_info->method_arg), 
               &(args_info->method_orig), &(args_info->method_given),
              &(local_args_info.method_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "method", 'M',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Set process to use.  */
        
        
          if (update_arg( (void *)&(args_info->process_arg), 
               &(args_info->process_orig), &(args_info->process_given),
              &(local_args_info.process_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "process", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'E':	/* Set selection to use.  */
        
        
          if (update_arg( (void *)&(args_info->selection_arg), 
               &(args_info->selection_orig), &(args_info->selection_given),
              &(local_args_info.selection_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "selection", 'E',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Config file location.  */
          if (strcmp (long_options[option_index].name, "config") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->config_arg), 
                 &(args_info->config_orig), &(args_info->config_given),
                &(local_args_info.config_given), optarg, 0, "./vtapi.conf", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "config", '-',
                additional_error))
              goto failure;
          
          }
          /* Log file location.  */
          else if (strcmp (long_options[option_index].name, "log") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_arg), 
                 &(args_info->log_orig), &(args_info->log_given),
                &(local_args_info.log_given), optarg, 0, "./vtapi.log", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "log", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  return result;
}
