/** @file vtapi_settings.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.5
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef VTAPI_SETTINGS_H
#define VTAPI_SETTINGS_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "VTApi"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "VTApi"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "0.1"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  const char *verbose_help; /**< @brief Verbose output mode - write used SQL commands etc. help description.  */
  char * config_arg;	/**< @brief Config file location (default='./vtapi.conf').  */
  char * config_orig;	/**< @brief Config file location original value given at command line.  */
  const char *config_help; /**< @brief Config file location help description.  */
  char * log_arg;	/**< @brief Log file location (default='./vtapi.log').  */
  char * log_orig;	/**< @brief Log file location original value given at command line.  */
  const char *log_help; /**< @brief Log file location help description.  */
  char * user_arg;	/**< @brief User name.  */
  char * user_orig;	/**< @brief User name original value given at command line.  */
  const char *user_help; /**< @brief User name help description.  */
  char * password_arg;	/**< @brief User password.  */
  char * password_orig;	/**< @brief User password original value given at command line.  */
  const char *password_help; /**< @brief User password help description.  */
  char * location_arg;	/**< @brief Base location of data files.  */
  char * location_orig;	/**< @brief Base location of data files original value given at command line.  */
  const char *location_help; /**< @brief Base location of data files help description.  */
  char * connection_arg;	/**< @brief Connection string \"host=.. port=.. dbname=.. user=.. password=..\".  */
  char * connection_orig;	/**< @brief Connection string \"host=.. port=.. dbname=.. user=.. password=..\" original value given at command line.  */
  const char *connection_help; /**< @brief Connection string \"host=.. port=.. dbname=.. user=.. password=..\" help description.  */
  char * format_arg;	/**< @brief Input/output format (default='standard').  */
  char * format_orig;	/**< @brief Input/output format original value given at command line.  */
  const char *format_help; /**< @brief Input/output format help description.  */
  char * input_arg;	/**< @brief Read from specific input.  */
  char * input_orig;	/**< @brief Read from specific input original value given at command line.  */
  const char *input_help; /**< @brief Read from specific input help description.  */
  char * output_arg;	/**< @brief Write to specific output.  */
  char * output_orig;	/**< @brief Write to specific output original value given at command line.  */
  const char *output_help; /**< @brief Write to specific output help description.  */
  char * where_arg;	/**< @brief explicit WHERE, ex.: --where=\"features is NULL\".  */
  char * where_orig;	/**< @brief explicit WHERE, ex.: --where=\"features is NULL\" original value given at command line.  */
  const char *where_help; /**< @brief explicit WHERE, ex.: --where=\"features is NULL\" help description.  */
  char * dataset_arg;	/**< @brief Set dataset to use.  */
  char * dataset_orig;	/**< @brief Set dataset to use original value given at command line.  */
  const char *dataset_help; /**< @brief Set dataset to use help description.  */
  char * sequence_arg;	/**< @brief Set sequence to use.  */
  char * sequence_orig;	/**< @brief Set sequence to use original value given at command line.  */
  const char *sequence_help; /**< @brief Set sequence to use help description.  */
  char * interval_arg;	/**< @brief Set interval to use.  */
  char * interval_orig;	/**< @brief Set interval to use original value given at command line.  */
  const char *interval_help; /**< @brief Set interval to use help description.  */
  char * method_arg;	/**< @brief Set method to use.  */
  char * method_orig;	/**< @brief Set method to use original value given at command line.  */
  const char *method_help; /**< @brief Set method to use help description.  */
  char * process_arg;	/**< @brief Set process to use.  */
  char * process_orig;	/**< @brief Set process to use original value given at command line.  */
  const char *process_help; /**< @brief Set process to use help description.  */
  char * selection_arg;	/**< @brief Set selection to use.  */
  char * selection_orig;	/**< @brief Set selection to use original value given at command line.  */
  const char *selection_help; /**< @brief Set selection to use help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int config_given ;	/**< @brief Whether config was given.  */
  unsigned int log_given ;	/**< @brief Whether log was given.  */
  unsigned int user_given ;	/**< @brief Whether user was given.  */
  unsigned int password_given ;	/**< @brief Whether password was given.  */
  unsigned int location_given ;	/**< @brief Whether location was given.  */
  unsigned int connection_given ;	/**< @brief Whether connection was given.  */
  unsigned int format_given ;	/**< @brief Whether format was given.  */
  unsigned int input_given ;	/**< @brief Whether input was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int where_given ;	/**< @brief Whether where was given.  */
  unsigned int dataset_given ;	/**< @brief Whether dataset was given.  */
  unsigned int sequence_given ;	/**< @brief Whether sequence was given.  */
  unsigned int interval_given ;	/**< @brief Whether interval was given.  */
  unsigned int method_given ;	/**< @brief Whether method was given.  */
  unsigned int process_given ;	/**< @brief Whether process was given.  */
  unsigned int selection_given ;	/**< @brief Whether selection was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_format_values[];  /**< @brief Possible values for format. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* VTAPI_SETTINGS_H */
