/* sd.h - Header file: SD card functions.
 * Author: Vlastimil Kosar ikosar@fit.vutbr.cz
 */

// Standard capacity SD Memory Card - ver 1.X
#define SD_TYPE_SD1_X 1

// Standard capacity SD Memory Card - ver >= 2.00
#define SD_TYPE_SD2 2

// SDHC or SDXC SD memory card
#define SD_TYPE_SDHC 3

// SD block (sector) with size 512B, 2B added for SD CRC16, not used otherwise
typedef uint8_t t_sd_block[514];

/*
 * Init SD card and check if SD card is operable.
 * Params: 
 *   info - informations about SD card
 * Returns: 1 if everything is OK, 0 if error happend.
 */
uint32_t sd_init(t_sd_info *info);

/*
 * Read 512B from SD card.
 * Params:
 *   sector - LBA number of sector (512B block)
 *   block - 512B of data read from SD card
 *   info - informations about SD card
 * Returns: 1 if everything is OK, 0 if error happend.
 */
uint32_t read_sd_block_512B(uint32_t sector, t_sd_block *block, t_sd_info *info);
